/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.query.DataSet;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.Mark;
import com.hp.hpl.jena.query.core.QueryElement;
import com.hp.hpl.jena.query.core.QueryIterator;
import com.hp.hpl.jena.query.util.iterator.QueryIterNullIterator;
import java.util.Collection;
import java.util.Set;

public class ElementBlock
extends Element {
    private DataSet dataSet = null;
    private QueryElement queryElement = null;

    public ElementBlock(DataSet dataSet, QueryElement queryElement) {
        this.dataSet = dataSet;
        this.queryElement = queryElement;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public QueryElement getQueryElement() {
        return this.queryElement;
    }

    public void setQueryElement(QueryElement queryElement) {
        this.queryElement = queryElement;
    }

    public QueryIterator exec(Mark mark, QueryIterator queryIterator) {
        if (this.dataSet == null) {
            throw new QueryException("QueryBlock: no data source");
        }
        if (this.queryElement == null) {
            return new QueryIterNullIterator();
        }
        return this.queryElement.exec(mark, queryIterator, this.dataSet);
    }

    public QueryIterator exec(Mark mark, QueryIterator queryIterator, DataSet dataSet) {
        if (this.dataSet != null) {
            dataSet = this.dataSet;
        }
        return this.queryElement.exec(mark, queryIterator, dataSet);
    }

    protected void varsRequired(Set set) {
        if (this.queryElement != null) {
            if (this.queryElement instanceof Element) {
                ((Element)this.queryElement).varsRequired(set);
            } else {
                set.addAll(this.queryElement.varsRequired());
            }
        }
    }

    protected void varsBound(Set set) {
        if (this.queryElement != null) {
            if (this.queryElement instanceof Element) {
                ((Element)this.queryElement).varsBound(set);
            } else {
                set.addAll(this.queryElement.varsBound());
            }
        }
    }

    public void subst(Collection collection, Binding binding) {
        if (this.queryElement != null) {
            this.queryElement.subst(collection, binding);
        }
    }

    public void visit(ElementVisitor elementVisitor) {
        elementVisitor.visit(this);
    }

    public void phase2(Query query2) {
        if (this.queryElement != null) {
            this.queryElement.phase2(query2);
        }
    }
}

