/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.DataSet;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasePattern;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.Mark;
import com.hp.hpl.jena.query.core.QueryEngineUtils;
import com.hp.hpl.jena.query.core.QueryIterator;
import com.hp.hpl.jena.query.util.iterator.QueryIterNullIterator;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.LogFactory;

public class ElementTriplePattern
extends Element {
    Triple triple = null;

    public ElementTriplePattern() {
    }

    public ElementTriplePattern(Triple triple) {
        this.triple = triple;
    }

    public void setTriple(Triple triple) {
        this.triple = triple;
    }

    public Triple getTriple() {
        return this.triple;
    }

    public QueryIterator exec(Mark mark, QueryIterator queryIterator, DataSet dataSet) {
        if (this.triple == null) {
            LogFactory.getLog((Class)ElementTriplePattern.class).warn((Object)"Triple is null");
            return new QueryIterNullIterator();
        }
        ElementBasePattern elementBasePattern = new ElementBasePattern();
        elementBasePattern.addTriple(this.triple);
        return elementBasePattern.exec(mark, queryIterator, dataSet);
    }

    protected void varsRequired(Set set) {
    }

    protected void varsBound(Set set) {
        this.addVar(set, this.triple.getSubject());
        this.addVar(set, this.triple.getPredicate());
        this.addVar(set, this.triple.getObject());
    }

    private void addVar(Set set, Node node) {
        if (node.isVariable()) {
            set.add(node.getName());
        }
    }

    public void subst(Collection collection, Binding binding) {
        Triple triple = QueryEngineUtils.substituteIntoTriple(this.triple, binding);
        collection.add(triple);
    }

    public void visit(ElementVisitor elementVisitor) {
        elementVisitor.visit(this);
    }

    public void phase2(Query query2) {
        this.triple = this.fixUpTriple(query2, this.triple);
    }

    private Triple fixUpTriple(Query query2, Triple triple) {
        Node node = this.fixUpNode(query2, this.triple.getSubject());
        Node node2 = this.fixUpNode(query2, this.triple.getPredicate());
        Node node3 = this.fixUpNode(query2, this.triple.getObject());
        return new Triple(node, node2, node3);
    }

    private Node fixUpNode(Query query2, Node node) {
        if (!node.isBlank()) {
            return node;
        }
        node = query2.allocAnonVariable(node);
        return node;
    }
}

