/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Constraint;
import com.hp.hpl.jena.query.core.Mark;
import com.hp.hpl.jena.query.core.QueryIterator;
import com.hp.hpl.jena.query.expr.ExprException;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.iterator.QueryIterFilter;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryIterConstraintFilter
extends QueryIterFilter {
    static Log log = LogFactory.getLog((Class)QueryIterConstraintFilter.class);

    QueryIterConstraintFilter(Mark mark, QueryIterator queryIterator, List list) {
        super(new FilterByConstraints(mark, list), queryIterator);
    }

    private static String constraintToString(Query query2, Constraint constraint) {
        IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
        constraint.format(query2, indentedLineBuffer.getIndentedWriter());
        return indentedLineBuffer.toString();
    }

    static class FilterByConstraints
    implements QueryIterFilter.Filter {
        List constraints = null;
        Mark mark;

        FilterByConstraints(Mark mark, List list) {
            this.constraints = list;
            this.mark = mark;
        }

        public boolean accept(Object object) {
            Binding binding = (Binding)object;
            Iterator iterator = this.constraints.iterator();
            while (iterator.hasNext()) {
                Constraint constraint = (Constraint)iterator.next();
                boolean bl = false;
                try {
                    bl = constraint.isSatisfied(binding);
                }
                catch (ExprException exprException) {
                    bl = false;
                }
                catch (Exception exception) {
                    bl = false;
                    log.warn((Object)("General exeception in " + QueryIterConstraintFilter.constraintToString(null, constraint)));
                }
                if (bl) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)this.mark.msg("Reject: " + constraint + " - " + binding));
                }
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)this.mark.msg("Accept: " + this.tests() + " - " + binding));
            }
            return true;
        }

        String tests() {
            String string = "";
            Iterator iterator = this.constraints.iterator();
            while (iterator.hasNext()) {
                Constraint constraint = (Constraint)iterator.next();
                string = string + constraint;
            }
            return string;
        }
    }
}

