/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.BindingMap;
import com.hp.hpl.jena.query.core.QueryEngineUtils;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import java.util.Collection;
import java.util.Iterator;

public class ResultBinding
implements QuerySolution {
    Collection causalTriples = null;
    Binding binding;
    Model model;

    public ResultBinding(Model model, Binding binding) {
        this.model = model;
        this.binding = binding;
    }

    public ResultBinding(Model model) {
        this.model = model;
        this.binding = new BindingMap();
    }

    public RDFNode get(String string) {
        Node node = this.getNode(string);
        if (node == null) {
            return null;
        }
        return QueryEngineUtils.convertGraphNodeToRDFNode(node, this.model);
    }

    public Node getNode(String string) {
        return (Node)this.binding.get(string);
    }

    public boolean contains(String string) {
        return this.binding.contains(string);
    }

    public Iterator varNames() {
        return this.binding.names();
    }

    public void add(String string, RDFNode rDFNode) {
        this.binding.add(string, rDFNode.asNode());
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public Model getModel() {
        return this.model;
    }

    public String toString() {
        if (this.binding == null) {
            return "<no binding>";
        }
        return this.binding.toString();
    }
}

