/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprNodeFunction;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.ReturnBoolean;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class E_Regex
extends ExprNodeFunction
implements ReturnBoolean {
    private static final String name = "regex";
    Expr expr;
    String patternStr;
    String flags;
    int mask;
    Pattern pattern;
    PatternCompiler compiler = new Perl5Compiler();
    PatternMatcher matcher = new Perl5Matcher();

    public E_Regex(Expr expr, String string, String string2) {
        super(name);
        this.patternStr = string;
        this.expr = expr;
        this.flags = string2;
        this.mask = this.makeMask(this.flags);
        try {
            this.pattern = this.compiler.compile(this.patternStr, this.mask);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new ExprEvalException("E_Regexp: Pattern exception: " + (Object)((Object)malformedPatternException));
        }
    }

    public NodeValue eval(Binding binding) {
        NodeValue nodeValue = this.expr.eval(binding);
        if (!nodeValue.isString()) {
            throw new ExprEvalException("REGEXP: " + this.expr + " evaluates to " + nodeValue + ", which is not a string");
        }
        boolean bl = this.matcher.contains(nodeValue.getString(), this.pattern);
        return bl ? NodeValue.TRUE : NodeValue.FALSE;
    }

    public void check() {
    }

    private int makeMask(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        block6: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case 'i': {
                    n |= 1;
                    continue block6;
                }
                case 'm': {
                    n |= 8;
                    continue block6;
                }
                case 's': {
                    n |= 0x10;
                    continue block6;
                }
                case 'x': {
                    n |= 0x20;
                    continue block6;
                }
                default: {
                    throw new ExprEvalException("Illegal flag in regex modifiers: " + string.charAt(i));
                }
            }
        }
        return n;
    }

    public Expr getArg(int n) {
        if (n == 1) {
            return this.expr;
        }
        if (n == 2) {
            return NodeValue.makeString(this.patternStr);
        }
        if (n == 3 && this.flags != null) {
            return NodeValue.makeString(this.flags);
        }
        return null;
    }

    public String getPrintName(Query query2) {
        return name;
    }
}

