/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprNode;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.ReturnBoolean;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.util.QueryPrintUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class E_RegexpJava
extends ExprNode
implements ReturnBoolean {
    private static final String printName = "strMatch";
    Expr expr;
    String patternStr;
    String flags;
    int mask;
    Pattern pattern;

    public E_RegexpJava(Expr expr, String string, String string2) {
        this.patternStr = string;
        this.expr = expr;
        this.flags = string2;
        this.mask = this.makeMask(this.flags);
        this.pattern = Pattern.compile(this.patternStr, this.mask);
    }

    public NodeValue eval(Binding binding) {
        NodeValue nodeValue = this.expr.eval(binding);
        if (!nodeValue.isString()) {
            throw new ExprEvalException("REGEXP: " + this.expr + " evaluates to " + nodeValue + ", which is not a string");
        }
        Matcher matcher = this.pattern.matcher(nodeValue.getString());
        if (matcher.matches()) {
            return NodeValue.TRUE;
        }
        return NodeValue.FALSE;
    }

    public void checkSelf() {
    }

    public void format(Query query2, IndentedWriter indentedWriter) {
        indentedWriter.print(this.asInfixString(query2));
    }

    public void check() {
    }

    public String asInfixString(Query query2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("REGEXP");
        stringBuffer.append("(");
        stringBuffer.append(this.expr.asInfixString(query2));
        stringBuffer.append(", ");
        stringBuffer.append(QueryPrintUtils.stringForString(this.patternStr));
        if (this.flags != null) {
            stringBuffer.append(", ");
            stringBuffer.append(QueryPrintUtils.stringForString(this.flags));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String asPrefixString(Query query2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("REGEXP");
        stringBuffer.append("(");
        stringBuffer.append(this.expr.asPrefixString(query2));
        stringBuffer.append(", ");
        stringBuffer.append(QueryPrintUtils.stringForString(this.patternStr));
        if (this.flags != null) {
            stringBuffer.append(", ");
            stringBuffer.append(QueryPrintUtils.stringForString(this.flags));
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.asInfixString(null);
    }

    private int makeMask(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        block5: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case 'i': {
                    n |= 0x40;
                    continue block5;
                }
                case 'm': {
                    n |= 8;
                    continue block5;
                }
                case 's': {
                    n |= 0x20;
                    continue block5;
                }
                default: {
                    throw new ExprEvalException("Illegal flag in regexp modifiers: " + string.charAt(i));
                }
            }
        }
        return n;
    }
}

