/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.ExprNode;
import com.hp.hpl.jena.query.expr.NodePatternLiteral;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.util.IndentedWriter;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public abstract class ExprNodeStringMatch
extends ExprNode {
    Expr left = null;
    NodePatternLiteral regex = null;
    String opSymbol;
    String opName;
    PatternCompiler compiler = new Perl5Compiler();
    PatternMatcher matcher = new Perl5Matcher();
    Pattern pattern = null;

    protected ExprNodeStringMatch(Expr expr, NodePatternLiteral nodePatternLiteral, String string, String string2) {
        this.left = expr;
        this.regex = nodePatternLiteral;
        this.opSymbol = string;
        this.opName = string2;
        try {
            this.pattern = this.compiler.compile(this.regex.getPattern(), this.regex.getMask());
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new ExprEvalException("ExprNodeStringMatch: Pattern exception: " + (Object)((Object)malformedPatternException));
        }
    }

    protected boolean match(Binding binding) {
        NodeValue nodeValue = this.left.eval(binding);
        if (!nodeValue.isString()) {
            throw new ExprEvalException("StringMatch: Wanted a string: " + nodeValue);
        }
        String string = nodeValue.getString();
        return this.matcher.contains(string, this.pattern);
    }

    public abstract void checkSelf();

    public void check() {
        this.checkSelf();
        this.left.check();
        this.regex.check();
    }

    public String asInfixString(Query query2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.left.asInfixString(query2));
        stringBuffer.append(" ");
        stringBuffer.append(this.opSymbol);
        stringBuffer.append(" ");
        stringBuffer.append(this.regex.asInfixString(query2));
        return stringBuffer.toString();
    }

    public String asPrefixString(Query query2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.opName);
        stringBuffer.append("(");
        stringBuffer.append(this.left.asPrefixString(query2));
        stringBuffer.append(", ");
        stringBuffer.append(this.regex.asPrefixString(query2));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void format(Query query2, IndentedWriter indentedWriter) {
        indentedWriter.print(this.asInfixString(query2));
    }

    public String toString() {
        return this.asInfixString(null);
    }
}

