/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.expr.ExprCheckException;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.util.IndentedWriter;

public class NodePatternLiteral {
    String pattern = null;
    int mask = -1;
    String modifiers;

    public NodePatternLiteral(String string) {
        this(string, "");
    }

    public NodePatternLiteral(String string, String string2) {
        this.pattern = string;
        this.modifiers = string2;
        this.mask = this.makeMask(this.modifiers);
    }

    public int makeMask(String string) {
        int n = 0;
        block6: for (int i = 0; i < this.modifiers.length(); ++i) {
            switch (this.modifiers.charAt(i)) {
                case 'i': {
                    n |= 1;
                    continue block6;
                }
                case 'm': {
                    n |= 8;
                    continue block6;
                }
                case 's': {
                    n |= 0x10;
                    continue block6;
                }
                case 'x': {
                    n |= 0x20;
                    continue block6;
                }
                default: {
                    throw new ExprEvalException("Illegal flag in regex modifiers: " + this.modifiers.charAt(i));
                }
            }
        }
        return n;
    }

    public String getPattern() {
        return this.pattern;
    }

    public int getMask() {
        return this.mask;
    }

    public String asInfixString(Query query2) {
        return this.toString();
    }

    public String asPrefixString(Query query2) {
        return this.toString();
    }

    public void format(Query query2, IndentedWriter indentedWriter) {
        indentedWriter.print(this.toString());
    }

    public String toString() {
        if (this.pattern.indexOf(47) == -1) {
            return "/" + this.pattern + "/" + this.modifiers;
        }
        if (this.pattern.indexOf(33) == -1) {
            return "m!" + this.pattern + "!" + this.modifiers;
        }
        if (this.pattern.indexOf(37) == -1) {
            return "m%" + this.pattern + "%" + this.modifiers;
        }
        char c = '!';
        return "m" + c + this.quote(this.pattern, c) + c + this.pattern;
    }

    private String quote(String string, char c) {
        int n;
        int n2 = 0;
        while ((n = string.indexOf(c, n2)) != -1) {
            string = string.substring(0, n) + "\\" + string.substring(n);
            n2 = n + 2;
        }
        return string;
    }

    public void check() {
        if (this.pattern == null || this.mask == -1) {
            throw new ExprCheckException("NodePatternLiteral");
        }
    }
}

