/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.function;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.query.function.CastXSD;
import com.hp.hpl.jena.query.function.F_even;
import com.hp.hpl.jena.query.function.Function;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FunctionRegistry {
    static FunctionRegistry globalRegistry = null;
    Map registry = new HashMap();

    public static synchronized FunctionRegistry global() {
        if (globalRegistry == null) {
            globalRegistry = new FunctionRegistry();
            globalRegistry.loadStdDefs();
            FunctionRegistry.global().put("http://example.org/functions#even", new F_even());
        }
        return globalRegistry;
    }

    public void put(String string, Function function) {
        this.registry.put(string, function);
    }

    public Function get(String string) {
        return (Function)this.registry.get(string);
    }

    public Function remove(String string) {
        return (Function)this.registry.remove(string);
    }

    public Iterator keys() {
        return this.registry.keySet().iterator();
    }

    private void loadStdDefs() {
        this.addCast(XSDDatatype.XSDinteger);
        this.addCast(XSDDatatype.XSDdouble);
        this.addCast(XSDDatatype.XSDdateTime);
        this.addCast(XSDDatatype.XSDboolean);
        this.addCast(XSDDatatype.XSDstring);
    }

    private void addCast(XSDDatatype xSDDatatype) {
        this.put(xSDDatatype.getURI(), new CastXSD(xSDDatatype));
    }
}

