/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.junit;

import com.hp.hpl.jena.query.junit.QueryTestException;
import com.hp.hpl.jena.query.junit.TestUtils;
import com.hp.hpl.jena.query.util.QueryPrintUtils;
import com.hp.hpl.jena.query.util.QueryUtils;
import com.hp.hpl.jena.query.vocabulary.TestManifest;
import com.hp.hpl.jena.query.vocabulary.TestQuery;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.List;

class TestItem {
    Resource testResource = null;
    Resource actionResource;
    String name;
    String resultFile;
    String comment;
    List dataFiles;
    String baseURI;
    String queryFile;
    String queryFileSyntax;
    Resource queryForm;
    Resource resultForm;

    public String getName() {
        return this.name;
    }

    public String getResultFile() {
        return this.resultFile;
    }

    public String getComment() {
        return this.comment;
    }

    public List getDataFiles() {
        return this.dataFiles;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getQueryFile() {
        return this.queryFile;
    }

    public String getQueryFileSyntax() {
        return this.queryFileSyntax;
    }

    public Resource getQueryForm() {
        return this.queryForm;
    }

    public Resource getResultForm() {
        return this.resultForm;
    }

    TestItem(Resource resource, String string, String string2) {
        this.testResource = resource;
        if (!resource.hasProperty(TestManifest.action)) {
            throw new QueryTestException("TestItem with no action");
        }
        if (!resource.hasProperty(TestManifest.name)) {
            throw new QueryTestException("TestItem with no name");
        }
        this.queryFileSyntax = string;
        Resource resource2 = this._getAction();
        this.name = this._getName();
        this.resultFile = this._getResultFile();
        this.comment = this._getComment();
        this.dataFiles = this._getDataFiles();
        this.queryFile = this._getQueryFile();
        this.queryFileSyntax = this._getSyntax(resource.getModel(), this.queryFile, string);
        if (this.queryFileSyntax == null && this.queryFile != null) {
            this.queryFileSyntax = QueryUtils.guessQueryFileSyntax(this.queryFile);
        }
        this.queryForm = this._getQueryForm();
        this.resultForm = this._getResultForm();
    }

    TestItem(String string, String string2, String string3, String string4) {
        this.name = string;
        this.queryFile = string2;
        this.dataFiles = new ArrayList();
        this.dataFiles.add(string3);
        this.resultFile = string4;
        this.comment = "";
        this.queryForm = null;
        this.resultForm = null;
    }

    public Resource getResource() {
        return this.testResource;
    }

    String _getName() {
        Statement statement = this.testResource.getProperty(TestManifest.name);
        if (statement == null) {
            return "<<unset>>";
        }
        return statement.getString();
    }

    Resource _getAction() {
        if (this.actionResource == null) {
            this.actionResource = this.testResource.getProperty(TestManifest.action).getResource();
        }
        return this.actionResource;
    }

    String _getResultFile() {
        return TestUtils.getLiteralOrURI(this.testResource, TestManifest.result);
    }

    String _getComment() {
        Statement statement = this.testResource.getProperty(RDFS.comment);
        if (statement == null) {
            return null;
        }
        return statement.getString();
    }

    List _getDataFiles() {
        if (!this._getAction().isAnon()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StmtIterator stmtIterator = this._getAction().listProperties(TestQuery.data);
        while (stmtIterator.hasNext()) {
            Object object = stmtIterator.next();
            String string = ((Statement)object).getResource().getURI();
            arrayList.add(string);
        }
        stmtIterator.close();
        return arrayList;
    }

    String _getQueryFile() {
        Resource resource = this._getAction();
        if (resource.hasProperty(TestQuery.query)) {
            return TestUtils.getLiteralOrURI(resource, TestQuery.query);
        }
        if (this._getAction().isAnon()) {
            return "[]";
        }
        return this._getAction().getURI();
    }

    Resource _getQueryForm() {
        return null;
    }

    Resource _getResultForm() {
        return null;
    }

    String _getSyntax(Model model, String string, String string2) {
        Resource resource = model.createResource(string);
        if (resource.hasProperty(RDF.type)) {
            return resource.getProperty(RDF.type).getResource().getURI();
        }
        return string2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getName();
        String string2 = this.getComment();
        String string3 = QueryPrintUtils.stringForRDFNode((RDFNode)this._getAction());
        stringBuffer.append("Name: " + string);
        if (this.getComment() != null) {
            stringBuffer.append("    Comment: " + this.getComment());
        }
        return stringBuffer.toString();
    }
}

