/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.junit;

import com.hp.hpl.jena.query.junit.QueryTestException;
import com.hp.hpl.jena.query.junit.TestItem;
import com.hp.hpl.jena.query.junit.TestUtils;
import com.hp.hpl.jena.query.vocabulary.TestManifest;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestSuite;
import org.apache.commons.logging.LogFactory;

class TestManifestList {
    Model manifest = null;
    static /* synthetic */ Class class$com$hp$hpl$jena$query$junit$TestManifestList;

    public TestManifestList(String string) {
        this.manifest = FileManager.get().loadModel(string);
    }

    public TestManifestList(Model model) {
        this.manifest = model;
    }

    public Model getModel() {
        return this.manifest;
    }

    public TestIterator iterator() {
        return new TestIterator();
    }

    public void apply(ActionProc actionProc) {
        TestSuite testSuite = new TestSuite();
        TestIterator testIterator = this.iterator();
        while (testIterator.hasNext()) {
            TestItem testItem = (TestItem)testIterator.next();
            actionProc.map1(testItem);
        }
    }

    public static interface ActionProc {
        public void map1(TestItem var1);
    }

    public class TestIterator
    implements Iterator {
        List entries;
        Iterator iterator;

        TestIterator() {
            this.init();
        }

        public void init() {
            this.entries = new ArrayList();
            StmtIterator stmtIterator = TestManifestList.this.manifest.listStatements(null, RDF.type, (RDFNode)TestManifest.Manifest);
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.nextStatement();
                Resource resource = statement.getSubject();
                String string = TestUtils.getQuerySyntax(resource);
                if (!(string == null || string.equals("http://jena.hpl.hp.com/2003/07/query/RDQL") || string.equals("http://jena.hpl.hp.com/2003/07/query/ARQ") || string.equals("http://jena.hpl.hp.com/2003/07/query/SPARQL") || string.equals("http://jena.hpl.hp.com/2003/07/query/SPARQL-alt"))) {
                    throw new QueryTestException("Unknown syntax: " + string);
                }
                StmtIterator stmtIterator2 = resource.listProperties(TestManifest.entries);
                while (stmtIterator2.hasNext()) {
                    Resource resource2 = stmtIterator2.nextStatement().getResource();
                    while (!resource2.equals(RDF.nil)) {
                        Resource resource3 = resource2.getRequiredProperty(RDF.first).getResource();
                        TestItem testItem = new TestItem(resource3, string, "RDF/XML");
                        this.entries.add(testItem);
                        resource2 = resource2.getRequiredProperty(RDF.rest).getResource();
                    }
                }
                stmtIterator2.close();
            }
            stmtIterator.close();
            this.reset();
        }

        public void reset() {
            this.iterator = this.entries.iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }

        public TestItem nextItem() {
            Object e = this.iterator.next();
            if (!(e instanceof TestItem)) {
                LogFactory.getLog((Class)(class$com$hp$hpl$jena$query$junit$TestManifestList == null ? (class$com$hp$hpl$jena$query$junit$TestManifestList = TestManifestList.class$("com.hp.hpl.jena.query.junit.TestManifestList")) : class$com$hp$hpl$jena$query$junit$TestManifestList)).fatal((Object)("obj is " + e.getClass().getName()));
                return null;
            }
            return (TestItem)e;
        }

        public void remove() {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
    }
}

