/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.parser;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.parser.arq.ARQParser;
import com.hp.hpl.jena.query.parser.rdql.Q_Query;
import com.hp.hpl.jena.query.parser.rdql.RDQLParser;
import com.hp.hpl.jena.query.parser.sparql.SPARQLParser;
import com.hp.hpl.jena.query.parser.sparql_alt.ParseException;
import com.hp.hpl.jena.query.parser.sparql_alt.SPARQLaltParser;
import com.hp.hpl.jena.query.parser.sparql_alt.TokenMgrError;
import com.hp.hpl.jena.query.util.RelURI;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Parser {
    static Log log = LogFactory.getLog((Class)Parser.class);

    public static Query parseSPARQL(Query query2, String string) {
        try {
            query2.setStrict(true);
            StringReader stringReader = new StringReader(string);
            SPARQLParser sPARQLParser = new SPARQLParser(stringReader);
            sPARQLParser.setQuery(query2);
            sPARQLParser.CompilationUnit();
            query2.setSyntax("http://jena.hpl.hp.com/2003/07/query/SPARQL");
            Parser.queryStep2(query2);
            return query2;
        }
        catch (com.hp.hpl.jena.query.parser.sparql.ParseException parseException) {
            throw new QueryException(parseException.getMessage());
        }
        catch (com.hp.hpl.jena.query.parser.sparql.TokenMgrError tokenMgrError) {
            throw new QueryException(tokenMgrError.getMessage());
        }
        catch (QueryException queryException) {
            throw queryException;
        }
        catch (Throwable throwable) {
            log.warn((Object)"Unexpected throwable: ", throwable);
            throw new QueryException(throwable);
        }
    }

    public static Query parseARQ(Query query2, String string) {
        try {
            query2.setStrict(true);
            StringReader stringReader = new StringReader(string);
            ARQParser aRQParser = new ARQParser(stringReader);
            aRQParser.setQuery(query2);
            aRQParser.CompilationUnit();
            query2.setSyntax("http://jena.hpl.hp.com/2003/07/query/ARQ");
            Parser.queryStep2(query2);
            return query2;
        }
        catch (com.hp.hpl.jena.query.parser.arq.ParseException parseException) {
            throw new QueryException(parseException.getMessage());
        }
        catch (com.hp.hpl.jena.query.parser.arq.TokenMgrError tokenMgrError) {
            throw new QueryException(tokenMgrError.getMessage());
        }
        catch (QueryException queryException) {
            throw queryException;
        }
        catch (Throwable throwable) {
            log.warn((Object)"Unexpected throwable: ", throwable);
            throw new QueryException(throwable);
        }
    }

    public static Query parseSPARQLalt(Query query2, String string) {
        try {
            query2.setStrict(true);
            StringReader stringReader = new StringReader(string);
            SPARQLaltParser sPARQLaltParser = new SPARQLaltParser(stringReader);
            sPARQLaltParser.setQuery(query2);
            sPARQLaltParser.CompilationUnit();
            query2.setSyntax("http://jena.hpl.hp.com/2003/07/query/SPARQL");
            Parser.queryStep2(query2);
            return query2;
        }
        catch (ParseException parseException) {
            throw new QueryException(parseException.getMessage());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new QueryException(tokenMgrError.getMessage());
        }
        catch (QueryException queryException) {
            throw queryException;
        }
        catch (Throwable throwable) {
            log.warn((Object)"Unexpected throwable: ", throwable);
            throw new QueryException(throwable);
        }
    }

    public static Query parseN3QL(Query query2, String string) {
        throw new UnsupportedOperationException("Not implemented: parsing N3QL syntax");
    }

    public static Query parseRDQL(Query query2, String string) {
        query2.setSyntax("http://jena.hpl.hp.com/2003/07/query/RDQL");
        Q_Query q_Query = null;
        try {
            StringReader stringReader = new StringReader(string);
            RDQLParser rDQLParser = new RDQLParser(stringReader);
            rDQLParser.CompilationUnit();
            q_Query = (Q_Query)rDQLParser.top();
            q_Query.rdqlPhase2(query2);
            if (query2.getGraphURIs() != null) {
                for (int i = 0; i < query2.getGraphURIs().size(); ++i) {
                    String string2 = (String)query2.getGraphURIs().get(i);
                    string2 = RelURI.resolve(string2, query2.getBaseURI());
                    query2.getGraphURIs().set(i, string2);
                }
            }
            return query2;
        }
        catch (QueryException queryException) {
            throw queryException;
        }
        catch (com.hp.hpl.jena.query.parser.rdql.ParseException parseException) {
            throw new QueryException("Parse error: " + parseException.getMessage());
        }
        catch (Error error) {
            throw new QueryException("Parse error: " + error.getMessage());
        }
        catch (Exception exception) {
            throw new QueryException("Unexpected exception: " + exception.getMessage());
        }
    }

    private static void queryStep2(Query query2) {
        Iterator iterator;
        Set set;
        if (query2.isSelectType()) {
            if (query2.getQueryBlock() == null) {
                throw new QueryException("Missing WHERE clause in SELECT query");
            }
            if (query2.getQueryResultStar()) {
                set = query2.getQueryBlock().varsBound();
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    query2.addResultVar((String)iterator.next());
                }
            }
        }
        if (query2.isConstructType() && query2.getQueryBlock() == null) {
            throw new QueryException("Missing WHERE clause in CONSTRUCT query");
        }
        if (query2.isDescribeType() && query2.getQueryResultStar()) {
            set = query2.getQueryBlock().varsBound();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                query2.addResultVar((String)iterator.next());
            }
        }
        if (query2.isAskType() && query2.getQueryBlock() == null) {
            throw new QueryException("Missing WHERE clause in ASK query");
        }
        if (query2.getQueryBlock() != null) {
            query2.getQueryBlock().phase2(query2);
        }
    }
}

