/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.parser.arq;

import com.hp.hpl.jena.query.parser.ParserBase;
import com.hp.hpl.jena.query.parser.QNameExeception;
import com.hp.hpl.jena.query.parser.arq.ARQParserConstants;
import com.hp.hpl.jena.query.parser.arq.ParseException;
import com.hp.hpl.jena.query.parser.arq.Token;
import com.hp.hpl.jena.query.util.JenaURIException;
import com.hp.hpl.jena.query.util.RelURI;

class ARQParserBase
extends ParserBase
implements ARQParserConstants {
    ARQParserBase() {
    }

    protected String fixupURI(String string) throws ParseException {
        if (this.getQuery() == null) {
            return string;
        }
        if (this.getQuery().getBaseURI() != null) {
            try {
                string = RelURI.resolve(string, this.getQuery().getBaseURI());
            }
            catch (JenaURIException jenaURIException) {
                throw new ParseException(jenaURIException.getMessage());
            }
        }
        return string;
    }

    protected String fixupQName(Token token) {
        String string = token.image;
        String string2 = this.getQuery().expandQName(string);
        if (string2 == null) {
            String string3 = "Line " + token.beginLine + ", column " + token.beginColumn;
            throw new QNameExeception(string3 + ": Unresolved qname: " + string);
        }
        return string2;
    }

    protected String fixupPrefix(Token token) {
        String string = token.image;
        if (string.endsWith(":")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }
}

