/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.resultset;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.NodeValue;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

class BindingComparator
implements Comparator {
    List vars;

    BindingComparator(List list) {
        this.vars = list;
    }

    public int compare(Object object, Object object2) {
        Binding binding = (Binding)object;
        Binding binding2 = (Binding)object2;
        Iterator iterator = this.vars.iterator();
        while (iterator.hasNext()) {
            Node node;
            String string = (String)iterator.next();
            Node node2 = (Node)binding.get(string);
            int n = BindingComparator.compareNodes(node2, node = (Node)binding2.get(string));
            if (n == 0) continue;
            if (string.startsWith("-")) {
                n = -n;
            }
            return n;
        }
        return 0;
    }

    public static int compareNodes(Node node, Node node2) {
        if (node == null) {
            if (node2 == null) {
                return 0;
            }
            return -1;
        }
        if (node2 == null) {
            return 1;
        }
        if (node.isBlank()) {
            if (node2.isBlank()) {
                String string = node.getBlankNodeId().toString();
                String string2 = node2.getBlankNodeId().toString();
                return string.compareTo(string2);
            }
            return -1;
        }
        if (node2.isBlank()) {
            return 1;
        }
        if (node.isURI()) {
            if (node2.isURI()) {
                String string = node.getURI();
                String string3 = node2.getURI();
                return string.compareTo(string3);
            }
            return -1;
        }
        if (node2.isURI()) {
            return 1;
        }
        if (node.isLiteral() && node2.isLiteral()) {
            NodeValue nodeValue = NodeValue.makeNode(node);
            NodeValue nodeValue2 = NodeValue.makeNode(node2);
            try {
                return NodeValue.compare(nodeValue, nodeValue2);
            }
            catch (ExprEvalException exprEvalException) {
                return nodeValue.asString().compareTo(nodeValue2.asString());
            }
        }
        throw new QueryException("Compare: " + node + "  " + node2);
    }
}

