/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.resultset;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.BindingMap;
import com.hp.hpl.jena.query.core.QueryIterator;
import com.hp.hpl.jena.query.core.ResultSetStream;
import com.hp.hpl.jena.query.util.iterator.QueryIterWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ResultSetReader {
    static Log log = LogFactory.getLog((Class)ResultSetFactory.class);

    public static ResultSet fromXML(InputStream inputStream) {
        try {
            InputSource inputSource = new InputSource(inputStream);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            ResultSetXMLHandler resultSetXMLHandler = new ResultSetXMLHandler();
            xMLReader.setContentHandler(resultSetXMLHandler);
            xMLReader.parse(inputSource);
            return new ResultSetStream(resultSetXMLHandler.variables, (QueryIterator)new QueryIterWrapper(resultSetXMLHandler.results.iterator()));
        }
        catch (SAXException sAXException) {
            log.warn((Object)"Problems parsing file (SAXException)", (Throwable)sAXException);
            return null;
        }
        catch (IOException iOException) {
            log.warn((Object)"Problems parsing file (IOException)", (Throwable)iOException);
            return null;
        }
    }

    static class ResultSetXMLHandler
    implements ContentHandler {
        static final String namespace = "http://www.w3.org/2001/sw/DataAccess/rf1/result";
        static final String variableElt = "variable";
        static final String resultElt = "result";
        static final int STATE_HEADER = -99;
        static final int STATE_RESULTS = -99;
        int rowCount = 0;
        Map bNodes = new HashMap();
        String datatype = null;
        String langTag = null;
        StringBuffer lexicalForm = null;
        String varName;
        boolean inValue = false;
        List variables = new ArrayList();
        List results = new ArrayList();
        Binding binding = null;

        ResultSetXMLHandler() {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.binding != null) {
                this.varName = string2;
                if (!this.variables.contains(this.varName)) {
                    log.warn((Object)("Undeclared variable: " + this.varName));
                }
                Node node = null;
                if (attributes.getValue("bound") != null) {
                    if (attributes.getValue("bound").equals("false")) {
                        return;
                    }
                    log.warn((Object)("Only legal value of 'bound' is false: result " + this.rowCount + ", var = " + this.varName));
                    return;
                }
                if (attributes.getValue("uri") != null) {
                    node = Node.createURI((String)attributes.getValue("uri"));
                } else if (attributes.getValue("bnodeid") != null) {
                    String string4 = attributes.getValue("bnodeid");
                    if (!this.bNodes.containsKey(string4)) {
                        this.bNodes.put(string4, Node.createAnon());
                    }
                    node = (Node)this.bNodes.get(string4);
                } else if (attributes.getValue("datatype") != null) {
                    this.datatype = attributes.getValue("datatype");
                } else if (attributes.getValue("xml:lang") != null) {
                    this.langTag = attributes.getValue("xml:lang");
                } else if (attributes.getLength() != 0) {
                    log.warn((Object)("Not recognized: result " + this.rowCount + ", var = " + this.varName));
                }
                if (node != null) {
                    this.binding.add(this.varName, node);
                } else {
                    this.inValue = true;
                }
                return;
            }
            if (string.equals(namespace) && string2.equals(variableElt)) {
                String string5 = attributes.getValue("name");
                this.variables.add(string5);
                return;
            }
            if (string.equals(namespace) && string2.equals(resultElt)) {
                ++this.rowCount;
                this.binding = new BindingMap();
                this.results.add(this.binding);
                return;
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.inValue) {
                RDFDatatype rDFDatatype = null;
                if (this.datatype != null) {
                    rDFDatatype = TypeMapper.getInstance().getSafeTypeByName(this.datatype);
                }
                Node node = Node.createLiteral((String)this.lexicalForm.toString(), (String)this.langTag, (RDFDatatype)rDFDatatype);
                this.binding.add(this.varName, node);
                this.lexicalForm = null;
                this.datatype = null;
                this.langTag = null;
                this.varName = null;
                this.inValue = false;
                return;
            }
            if (string.equals(namespace) && string2.equals(resultElt)) {
                this.binding = null;
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.inValue) {
                if (this.lexicalForm == null) {
                    this.lexicalForm = new StringBuffer();
                }
                this.lexicalForm.append(cArray, n, n2);
            }
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void skippedEntity(String string) throws SAXException {
        }
    }
}

