/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.DataSet;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Constraint;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasePattern;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.ElementConstraints;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.ElementUnsaid;
import com.hp.hpl.jena.query.core.TemplateBase;
import com.hp.hpl.jena.query.core.TemplateGroup;
import com.hp.hpl.jena.query.core.TemplateTriple;
import com.hp.hpl.jena.query.serializer.FormatterBase;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.util.QueryPrintUtils;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.util.Iterator;
import java.util.ListIterator;

public class FormatterARQ
extends FormatterBase {
    static final int INDENT = 2;
    static final boolean allowDoubles = true;
    public static boolean PATTERN_MARKERS = false;
    public static boolean PATTERN_FINAL_DOT = false;
    public static boolean UNION_MARKERS = true;
    public static boolean GROUP_UNNEST_ONE = false;
    public static boolean GRAPH_FIXED_INDENT = true;
    public static boolean UNSAID_FIXED_INDENT = true;

    public void format(IndentedWriter indentedWriter, Query query2, Element element) {
        this.query = query2;
        this.writer = indentedWriter;
        element.visit(this);
    }

    public void format(IndentedWriter indentedWriter, Query query2, TemplateBase templateBase) {
        this.query = query2;
        this.writer = indentedWriter;
        templateBase.visit(this);
    }

    public static String asString(Query query2, Element element) {
        IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
        FormatterARQ formatterARQ = new FormatterARQ();
        formatterARQ.format(indentedLineBuffer.getIndentedWriter(), query2, element);
        return indentedLineBuffer.toString();
    }

    public void visit(ElementTriplePattern elementTriplePattern) {
        this.formatTriple(elementTriplePattern.getTriple());
        this.writer.print(" # $$");
        this.writer.newline();
    }

    public void visit(ElementBasePattern elementBasePattern) {
        boolean bl = true;
        if (PATTERN_MARKERS) {
            this.writer.print("{ ");
            this.writer.incIndent(2);
        }
        ListIterator listIterator = elementBasePattern.triples();
        while (listIterator.hasNext()) {
            if (!bl) {
                this.writer.print(" .");
                this.writer.newline();
            }
            Triple triple = (Triple)listIterator.next();
            this.formatTriple(triple);
            bl = false;
        }
        if (PATTERN_MARKERS) {
            this.writer.decIndent(2);
            this.writer.print(" }");
        }
    }

    public void visit(ElementBlock elementBlock) {
        if (elementBlock.getDataSet() != null) {
            DataSet dataSet = elementBlock.getDataSet();
            this.writer.print("DATASET ");
            this.writer.incIndent(2);
            Iterator iterator = dataSet.listNames();
            if (iterator.hasNext()) {
                boolean bl = false;
                while (iterator.hasNext()) {
                    if (!bl) {
                        this.writer.newline();
                    }
                    this.writer.print("FROM <");
                    String string = (String)iterator.next();
                    this.writer.print(string);
                    this.writer.print(">");
                }
            }
            this.writer.decIndent(2);
            this.writer.newline();
        }
        if (elementBlock.getQueryElement() != null) {
            this.visitAsGroup((Element)elementBlock.getQueryElement());
        }
    }

    public void visit(ElementConstraints elementConstraints) {
        boolean bl = true;
        Iterator iterator = elementConstraints.constraints();
        while (iterator.hasNext()) {
            if (!bl) {
                this.writer.print(" . ");
            }
            this.writer.print("FILTER ");
            Constraint constraint = (Constraint)iterator.next();
            constraint.format(this.query, this.writer);
            bl = false;
        }
    }

    public void visit(ElementUnion elementUnion) {
        if (elementUnion.getElements().size() == 1) {
            Element element = (Element)elementUnion.getElements().get(0);
            this.visitAsGroup(element);
            return;
        }
        if (UNION_MARKERS) {
            this.writer.print("{");
            this.writer.newline();
            this.writer.pad();
        }
        this.writer.incIndent(2);
        boolean bl = true;
        ListIterator listIterator = elementUnion.getElements().listIterator();
        while (listIterator.hasNext()) {
            if (!bl) {
                this.writer.decIndent(2);
                this.writer.newline();
                this.writer.print("UNION");
                this.writer.newline();
                this.writer.incIndent(2);
            }
            Element element = (Element)listIterator.next();
            this.visitAsGroup(element);
            bl = false;
        }
        this.writer.decIndent(2);
        if (UNION_MARKERS) {
            this.writer.newline();
            this.writer.print("}");
        }
    }

    public void visit(ElementGroup elementGroup) {
        if (GROUP_UNNEST_ONE && elementGroup.getElements().size() == 1) {
            Element element = (Element)elementGroup.getElements().get(0);
            element.visit(this);
            return;
        }
        this.writer.print("{");
        this.writer.incIndent(2);
        int n = this.writer.getRow();
        this.writer.pad();
        boolean bl = true;
        ListIterator listIterator = elementGroup.getElements().listIterator();
        while (listIterator.hasNext()) {
            if (!bl) {
                this.writer.print(" . ");
                this.writer.newline();
            }
            Element element = (Element)listIterator.next();
            element.visit(this);
            bl = false;
        }
        if (PATTERN_FINAL_DOT) {
            this.writer.print(" .");
        }
        this.writer.decIndent(2);
        int n2 = this.writer.getRow();
        if (n != n2) {
            if (!PATTERN_FINAL_DOT) {
                this.writer.print(" .");
            }
            this.writer.newline();
            this.writer.print("}");
        } else {
            this.writer.print(" }");
        }
    }

    public void visit(ElementOptional elementOptional) {
        this.writer.print("OPTIONAL");
        this.writer.incIndent(2);
        this.writer.newline();
        this.visitAsGroup(elementOptional.getElement());
        this.writer.decIndent(2);
    }

    public void visit(ElementNamedGraph elementNamedGraph) {
        String string = "GRAPH ";
        int n = string.length();
        this.writer.print(string);
        string = elementNamedGraph.getSourceNode() == null ? "*" : FormatterARQ.slotToString(this.query, elementNamedGraph.getSourceNode());
        this.writer.print(string);
        n += string.length();
        if (GRAPH_FIXED_INDENT) {
            this.writer.incIndent(2);
            this.writer.newline();
        } else {
            this.writer.print(" ");
            this.writer.incIndent(++n);
        }
        this.visitAsGroup(elementNamedGraph.getElement());
        if (GRAPH_FIXED_INDENT) {
            this.writer.decIndent(2);
        } else {
            this.writer.decIndent(n);
        }
    }

    public void visit(ElementUnsaid elementUnsaid) {
        String string = "UNSAID ";
        int n = string.length();
        this.writer.print(string);
        n += string.length();
        if (UNSAID_FIXED_INDENT) {
            this.writer.incIndent(2);
            this.writer.newline();
        } else {
            this.writer.print(" ");
            this.writer.incIndent(++n);
        }
        this.visitAsGroup(elementUnsaid.getElement());
        if (UNSAID_FIXED_INDENT) {
            this.writer.decIndent(2);
        } else {
            this.writer.decIndent(n);
        }
    }

    private void visitAsGroup(Element element) {
        boolean bl = element instanceof ElementGroup;
        if (!bl) {
            this.writer.print("{ ");
            this.writer.incIndent(2);
        }
        element.visit(this);
        if (!bl) {
            this.writer.print(" }");
            this.writer.incIndent(2);
        }
    }

    public void visit(TemplateGroup templateGroup) {
        this.writer.print("{");
        this.writer.incIndent(2);
        this.writer.pad();
        boolean bl = true;
        Iterator iterator = templateGroup.templates();
        while (iterator.hasNext()) {
            TemplateBase templateBase = (TemplateBase)iterator.next();
            templateBase.visit(this);
            this.writer.print(" .");
            this.writer.newline();
            bl = false;
        }
        this.writer.decIndent(2);
        this.writer.print("}");
        this.writer.newline();
    }

    public void visit(TemplateTriple templateTriple) {
        this.formatTriple(templateTriple.getTriple());
    }

    private void formatTriple(Triple triple) {
        this.writer.print(FormatterARQ.triplePatternToString(this.query, triple));
    }

    private static String triplePatternToString(Query query2, Triple triple) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FormatterARQ.slotToString(query2, triple.getSubject()));
        stringBuffer.append(" ");
        stringBuffer.append(FormatterARQ.slotToString(query2, triple.getPredicate()));
        stringBuffer.append(" ");
        stringBuffer.append(FormatterARQ.slotToString(query2, triple.getObject()));
        return stringBuffer.toString();
    }

    private static String slotToString(Query query2, Node node) {
        PrefixMapping prefixMapping = Query.getGlobalPrefixMap();
        if (query2 != null) {
            prefixMapping = query2.getPrefixMap();
        }
        return QueryPrintUtils.stringForNode(node, prefixMapping);
    }
}

