/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Constraint;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasePattern;
import com.hp.hpl.jena.query.core.ElementBlock;
import com.hp.hpl.jena.query.core.ElementConstraints;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.ElementNamedGraph;
import com.hp.hpl.jena.query.core.ElementOptional;
import com.hp.hpl.jena.query.core.ElementTriplePattern;
import com.hp.hpl.jena.query.core.ElementUnion;
import com.hp.hpl.jena.query.core.ElementUnsaid;
import com.hp.hpl.jena.query.core.TemplateBase;
import com.hp.hpl.jena.query.core.TemplateGroup;
import com.hp.hpl.jena.query.core.TemplateTriple;
import com.hp.hpl.jena.query.serializer.FormatterBase;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.util.QueryPrintUtils;
import java.util.Iterator;
import java.util.ListIterator;

public class FormatterPlain
extends FormatterBase {
    static final int INDENT = 2;
    static final boolean allowDoubles = true;

    public void format(IndentedWriter indentedWriter, Query query2, Element element) {
        this.query = query2;
        this.writer = indentedWriter;
        element.visit(this);
    }

    public void format(IndentedWriter indentedWriter, Query query2, TemplateBase templateBase) {
        this.query = query2;
        this.writer = indentedWriter;
        templateBase.visit(this);
    }

    public static String asString(Query query2, Element element) {
        IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
        FormatterPlain formatterPlain = new FormatterPlain();
        formatterPlain.format(indentedLineBuffer.getIndentedWriter(), query2, element);
        return indentedLineBuffer.toString();
    }

    public void visit(ElementTriplePattern elementTriplePattern) {
        this.writer.print("TriplePattern");
        this.formatTriple(elementTriplePattern.getTriple());
        this.writer.newline();
    }

    public void visit(ElementBasePattern elementBasePattern) {
        this.writer.print("BasePattern");
        this.writer.newline();
        this.writer.incIndent(2);
        boolean bl = true;
        ListIterator listIterator = elementBasePattern.triples();
        while (listIterator.hasNext()) {
            if (!bl) {
                this.writer.newline();
            }
            Triple triple = (Triple)listIterator.next();
            this.formatTriple(triple);
            bl = false;
        }
        this.writer.decIndent(2);
    }

    public void visit(ElementBlock elementBlock) {
        this.writer.print("Block");
        this.writer.incIndent(2);
        this.writer.newline();
        if (elementBlock.getDataSet() != null) {
            this.writer.print("dataset");
        }
        ((Element)elementBlock.getQueryElement()).visit(this);
        this.writer.decIndent(2);
    }

    public void visit(ElementConstraints elementConstraints) {
        this.writer.newline();
        this.writer.print("Constraint");
        this.writer.incIndent(2);
        Iterator iterator = elementConstraints.constraints();
        while (iterator.hasNext()) {
            Constraint constraint = (Constraint)iterator.next();
            constraint.format(this.query, this.writer);
            this.writer.newline();
        }
        this.writer.decIndent(2);
    }

    public void visit(ElementUnion elementUnion) {
        this.multiElement("Union", elementUnion.getElements().iterator());
    }

    public void visit(ElementGroup elementGroup) {
        this.multiElement("Group", elementGroup.getElements().iterator());
    }

    public void visit(ElementOptional elementOptional) {
        this.singleElement("Optional", elementOptional.getElement());
    }

    public void visit(ElementNamedGraph elementNamedGraph) {
        this.singleElement("Graph", elementNamedGraph.getElement());
    }

    public void visit(ElementUnsaid elementUnsaid) {
        this.singleElement("Unsaid", elementUnsaid.getElement());
    }

    private void formatTriple(Triple triple) {
        String string = FormatterPlain.triplePatternToString(this.query, triple);
        this.writer.print(string);
    }

    private static String triplePatternToString(Query query2, Triple triple) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FormatterPlain.slotToString(query2, triple.getSubject()));
        stringBuffer.append(" ");
        stringBuffer.append(FormatterPlain.slotToString(query2, triple.getPredicate()));
        stringBuffer.append(" ");
        stringBuffer.append(FormatterPlain.slotToString(query2, triple.getObject()));
        return stringBuffer.toString();
    }

    private static String slotToString(Query query2, Node node) {
        return QueryPrintUtils.stringForNode(node, query2.getPrefixMap());
    }

    private void singleElement(String string, Element element) {
        this.writer.print(string);
        this.writer.incIndent(2);
        this.writer.newline();
        element.visit(this);
        this.writer.decIndent(2);
    }

    private void multiElement(String string, Iterator iterator) {
        this.writer.print(string);
        this.writer.incIndent(2);
        this.writer.newline();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (!bl) {
                this.writer.newline();
            }
            Element element = (Element)iterator.next();
            element.visit(this);
            bl = false;
        }
        this.writer.decIndent(2);
    }

    public void visit(TemplateTriple templateTriple) {
        Triple triple = templateTriple.getTriple();
        this.formatTriple(triple);
    }

    public void visit(TemplateGroup templateGroup) {
        this.writer.print("Template Group");
        this.writer.incIndent(2);
        this.writer.newline();
        Iterator iterator = templateGroup.templates();
        while (iterator.hasNext()) {
            TemplateBase templateBase = (TemplateBase)iterator.next();
            templateBase.visit(this);
        }
        this.writer.decIndent(2);
    }
}

