/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Constraint;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementBasePattern;
import com.hp.hpl.jena.query.core.ElementConstraints;
import com.hp.hpl.jena.query.core.ElementGroup;
import com.hp.hpl.jena.query.core.TemplateBase;
import com.hp.hpl.jena.query.core.TemplateGroup;
import com.hp.hpl.jena.query.core.TemplateTriple;
import com.hp.hpl.jena.query.serializer.FormatterARQ;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.QueryPrintUtils;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.util.Iterator;
import java.util.ListIterator;

public class FormatterSPARQLalt
extends FormatterARQ {
    public static String asString(Query query2, Element element) {
        IndentedLineBuffer indentedLineBuffer = new IndentedLineBuffer();
        FormatterSPARQLalt formatterSPARQLalt = new FormatterSPARQLalt();
        formatterSPARQLalt.format(indentedLineBuffer.getIndentedWriter(), query2, element);
        return indentedLineBuffer.toString();
    }

    public void visit(ElementGroup elementGroup) {
        if (GROUP_UNNEST_ONE && elementGroup.getElements().size() == 1) {
            Element element = (Element)elementGroup.getElements().get(0);
            element.visit(this);
            return;
        }
        this.writer.print("{");
        this.writer.incIndent(2);
        int n = this.writer.getRow();
        this.writer.pad();
        boolean bl = true;
        ListIterator listIterator = elementGroup.getElements().listIterator();
        while (listIterator.hasNext()) {
            if (!bl) {
                this.writer.newline();
            }
            Element element = (Element)listIterator.next();
            element.visit(this);
            bl = false;
        }
        this.writer.decIndent(2);
        int n2 = this.writer.getRow();
        if (n != n2) {
            this.writer.newline();
            this.writer.print("}");
        } else {
            this.writer.print(" }");
        }
    }

    public void visit(ElementBasePattern elementBasePattern) {
        boolean bl = true;
        ListIterator listIterator = elementBasePattern.triples();
        while (listIterator.hasNext()) {
            if (!bl) {
                this.writer.newline();
            }
            Triple triple = (Triple)listIterator.next();
            this.formatTriple(triple);
            bl = false;
        }
    }

    public void visit(ElementConstraints elementConstraints) {
        boolean bl = true;
        Iterator iterator = elementConstraints.constraints();
        while (iterator.hasNext()) {
            if (!bl) {
                this.writer.newline();
            }
            Constraint constraint = (Constraint)iterator.next();
            this.writer.print("AND ");
            constraint.format(this.query, this.writer);
            bl = false;
        }
    }

    public void visit(TemplateTriple templateTriple) {
        this.writer.print(FormatterSPARQLalt.triplePatternToString(this.query, templateTriple.getTriple()));
    }

    public void visit(TemplateGroup templateGroup) {
        boolean bl = true;
        Iterator iterator = templateGroup.templates();
        while (iterator.hasNext()) {
            TemplateBase templateBase = (TemplateBase)iterator.next();
            templateBase.visit(this);
            this.writer.newline();
            bl = false;
        }
    }

    private void formatTriple(Triple triple) {
        this.writer.print(FormatterSPARQLalt.triplePatternToString(this.query, triple));
    }

    private static String triplePatternToString(Query query2, Triple triple) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("( ");
        stringBuffer.append(FormatterSPARQLalt.slotToString(query2, triple.getSubject()));
        stringBuffer.append(" ");
        stringBuffer.append(FormatterSPARQLalt.slotToString(query2, triple.getPredicate()));
        stringBuffer.append(" ");
        stringBuffer.append(FormatterSPARQLalt.slotToString(query2, triple.getObject()));
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    private static String slotToString(Query query2, Node node) {
        PrefixMapping prefixMapping = Query.getGlobalPrefixMap();
        if (query2 != null) {
            prefixMapping = query2.getPrefixMap();
        }
        return QueryPrintUtils.stringForNode(node, prefixMapping);
    }
}

