/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.TemplateBase;
import com.hp.hpl.jena.query.serializer.FormatterARQ;
import com.hp.hpl.jena.query.serializer.FormatterBase;
import com.hp.hpl.jena.query.serializer.FormatterPlain;
import com.hp.hpl.jena.query.serializer.FormatterSPARQLalt;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.query.util.PrefixMapping2;
import com.hp.hpl.jena.query.util.QueryPrintUtils;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Serializer {
    static final int INDENT = 4;
    private static Log log = LogFactory.getLog((Class)Serializer.class);

    public static void serialize(Query query2, OutputStream outputStream) {
        Serializer.serialize(query2, outputStream, null);
    }

    public static void serialize(Query query2, OutputStream outputStream, String string) {
        IndentedWriter indentedWriter = new IndentedWriter(outputStream);
        Serializer.serialize(query2, indentedWriter, string);
        indentedWriter.flush();
        try {
            outputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void serialize(Query query2, IndentedLineBuffer indentedLineBuffer) {
        String string = query2.getSyntax();
        if (string == null) {
            string = "http://jena.hpl.hp.com/2003/07/query/SPARQL";
        }
        Serializer.serialize(query2, indentedLineBuffer, string);
    }

    public static void serialize(Query query2, IndentedLineBuffer indentedLineBuffer, String string) {
        Serializer.serialize(query2, indentedLineBuffer.getIndentedWriter(), string);
    }

    public static void serialize(Query query2, IndentedWriter indentedWriter) {
        String string = query2.getSyntax();
        if (string == null) {
            string = "http://jena.hpl.hp.com/2003/07/query/SPARQL";
        }
        Serializer.serialize(query2, indentedWriter, string);
    }

    public static void serialize(Query query2, IndentedWriter indentedWriter, String string) {
        if (string == null) {
            string = "http://jena.hpl.hp.com/2003/07/query/SPARQL";
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/ARQ")) {
            Serializer.serializeARQ(query2, indentedWriter);
            indentedWriter.flush();
            return;
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/RDQL")) {
            Serializer.serializeRDQL(query2, indentedWriter);
            indentedWriter.flush();
            return;
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/SPARQL")) {
            Serializer.serializeSPARQL(query2, indentedWriter);
            indentedWriter.flush();
            return;
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/SPARQL-alt")) {
            Serializer.serializeSPARQL_alt(query2, indentedWriter);
            indentedWriter.flush();
            return;
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/SPARQL")) {
            Serializer.serializeSPARQL(query2, indentedWriter);
            indentedWriter.flush();
            return;
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/N3QL")) {
            Serializer.serializeN3QL(query2, indentedWriter);
            indentedWriter.flush();
            return;
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/plain")) {
            Serializer.serializePlain(query2, indentedWriter);
            return;
        }
        log.warn((Object)("Unknown syntax: " + string));
    }

    public static void serializeARQ(Query query2, IndentedWriter indentedWriter) {
        Serializer.serializeARQ(query2, indentedWriter, new FormatterARQ());
    }

    private static void serializeARQ(Query query2, IndentedWriter indentedWriter, FormatterBase formatterBase) {
        Object object;
        Iterator iterator;
        if (query2.getBaseURI() != null && query2.explicitlySetBaseURI()) {
            indentedWriter.print("BASE    ");
            indentedWriter.print("<" + query2.getBaseURI() + ">");
            indentedWriter.newline();
        }
        Map map = null;
        if (query2.getPrefixMap() instanceof PrefixMapping2) {
            iterator = (PrefixMapping2)query2.getPrefixMap();
            map = ((PrefixMapping2)((Object)iterator)).getNsPrefixMap(false);
        } else {
            map = query2.getPrefixMap().getNsPrefixMap();
        }
        if (map.size() > 0) {
            boolean bl = true;
            object = map.keySet().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                String string2 = (String)map.get(string);
                indentedWriter.print("PREFIX  ");
                indentedWriter.print(string + ": <" + string2 + ">");
                indentedWriter.newline();
            }
        }
        if (query2.isSelectType()) {
            indentedWriter.print("SELECT ");
            if (query2.isDistinct()) {
                indentedWriter.print("DISTINCT ");
            }
            indentedWriter.print(" ");
            if (query2.getQueryResultStar()) {
                indentedWriter.print("*");
            } else {
                Serializer.appendVarList(query2, indentedWriter, query2.getResultVars());
            }
            indentedWriter.newline();
        }
        if (query2.isDescribeType()) {
            indentedWriter.print("DESCRIBE ");
            if (query2.getQueryResultStar()) {
                indentedWriter.print("*");
            } else {
                Serializer.appendVarList(query2, indentedWriter, query2.getResultVars());
                Serializer.appendURIList(query2, indentedWriter, query2.getResultURIs());
            }
            indentedWriter.newline();
        }
        if (query2.isConstructType()) {
            indentedWriter.print("CONSTRUCT ");
            if (query2.getQueryResultStar()) {
                indentedWriter.print("*");
                indentedWriter.newline();
            } else {
                indentedWriter.incIndent(4);
                indentedWriter.newline();
                formatterBase.format(indentedWriter, query2, (TemplateBase)query2.getConstructTemplate());
                indentedWriter.decIndent(4);
            }
        }
        if (query2.isAskType()) {
            indentedWriter.print("ASK");
            indentedWriter.newline();
        }
        if (query2.isUnknownType()) {
            indentedWriter.print("<<UNKNOWN>>");
        }
        if (query2.getGraphURIs() != null) {
            indentedWriter.print("FROM  ");
            iterator = query2.getGraphURIs().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                indentedWriter.print(" ");
                indentedWriter.print(QueryPrintUtils.stringForURI((String)object, query2.getPrefixMap()));
            }
            indentedWriter.newline();
        }
        if (query2.getNamedGraphURIs() != null) {
            iterator = query2.getNamedGraphURIs().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                indentedWriter.print("FROM NAMED ");
                indentedWriter.print(QueryPrintUtils.stringForURI((String)object, query2.getPrefixMap()));
                indentedWriter.newline();
            }
        }
        if (query2.getQueryBlock() != null && query2.getQueryBlock().getQueryElement() != null) {
            indentedWriter.print("WHERE");
            indentedWriter.incIndent(4);
            indentedWriter.newline();
            formatterBase.format(indentedWriter, query2, query2.getQueryBlock());
            indentedWriter.decIndent(4);
            indentedWriter.newline();
        }
        if (query2.hasLimit()) {
            indentedWriter.print("LIMIT " + query2.getLimit());
            indentedWriter.newline();
        }
        indentedWriter.flush();
    }

    public static void serializeSPARQL(Query query2, IndentedWriter indentedWriter) {
        Serializer.serializeARQ(query2, indentedWriter, new FormatterARQ());
    }

    public static void serializeSPARQL_alt(Query query2, IndentedWriter indentedWriter) {
        Serializer.serializeARQ(query2, indentedWriter, new FormatterSPARQLalt());
    }

    public static void serializeRDQL(Query query2, IndentedWriter indentedWriter) {
        log.warn((Object)"# unparseRDQL: Not implemented - Native syntax instead");
        Serializer.serializeARQ(query2, indentedWriter);
    }

    public static void serializePlain(Query query2, IndentedWriter indentedWriter) {
        Serializer.serializeARQ(query2, indentedWriter, new FormatterPlain());
    }

    public static void serializeN3QL(Query query2, IndentedWriter indentedWriter) {
        throw new UnsupportedOperationException("Not implemented: Formatting a query in N3QL syntax");
    }

    static void appendVarList(Query query2, IndentedWriter indentedWriter, List list) {
        boolean bl = true;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!bl) {
                indentedWriter.print(" ");
            }
            indentedWriter.print("?");
            indentedWriter.print(string);
            bl = false;
        }
    }

    static void appendURIList(Query query2, IndentedWriter indentedWriter, List list) {
        boolean bl = true;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (!bl) {
                indentedWriter.print(" ");
            }
            indentedWriter.print(QueryPrintUtils.stringForNode(node, query2.getPrefixMap()));
            bl = false;
        }
    }
}

