/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.test;

import com.hp.hpl.jena.query.junit.TestScripts;
import com.hp.hpl.jena.rdf.model.Model;
import junit.framework.Test;
import junit.framework.TestSuite;

public class QueryScripts
extends TestScripts {
    static final String testSetNameRDQL = "RDQL - Scripts";
    static final String testSetNameARQ = "ARQ - Scripts";
    static final String testSetNameDAWG = "DAWG - Misc";
    static final String testSetNameWGApproved = "DAWG - Approved";
    static final String testSetNameWGPending = "DAWG - Pending";
    public static final String testDirRDQL = "testing/RDQL";
    public static final String testDirARQ = "testing/ARQ";
    public static final String testDirDAWG = "testing/DAWG";
    public static final String testDirWGApproved = "testing/WG-Approved";
    public static final String testDirWGPending = "testing/WG-Pending";
    public static final String controlFilenameRDQL = "testing/RDQL/manifest-rdql.n3";
    public static final String controlFilenameARQ = "testing/ARQ/manifest-arq.n3";

    public static TestSuite makeRDQLScriptTests() {
        return QueryScripts.makeTestSuite(testSetNameRDQL, controlFilenameRDQL);
    }

    public static TestSuite makeRDQLConvertedTests() {
        return QueryScripts.makeTestSuite("ARQ - RDQL", "testing/ARQ/RDQL2/manifest.n3");
    }

    public static TestSuite makeARQSyntaxTests() {
        return QueryScripts.makeTestSuite("ARQ - Syntax", "testing/ARQ/Syntax2/manifest.ttl");
    }

    public static TestSuite makeARQScriptTests() {
        TestSuite testSuite = new TestSuite(testSetNameARQ);
        testSuite.addTest((Test)QueryScripts.makeTestSuite("Basic", "testing/ARQ/Basic/manifest.n3"));
        testSuite.addTest((Test)QueryScripts.makeTestSuite("DataSet", "testing/ARQ/DataSet/manifest.n3"));
        testSuite.addTest((Test)QueryScripts.makeTestSuite("Graph", "testing/ARQ/Graph/manifest.n3"));
        testSuite.addTest((Test)QueryScripts.makeTestSuite("Union", "testing/ARQ/Union/manifest.n3"));
        testSuite.addTest((Test)QueryScripts.makeTestSuite("Unsaid", "testing/ARQ/Unsaid/manifest.n3"));
        testSuite.addTest((Test)QueryScripts.makeTestSuite("Construct", "testing/ARQ/Construct/manifest.ttl"));
        testSuite.addTest((Test)QueryScripts.makeTestSuite("Describe", "testing/ARQ/Describe/manifest.n3"));
        testSuite.addTest((Test)QueryScripts.makeTestSuite("Bound", "testing/ARQ/Bound/manifest.n3"));
        testSuite.addTest((Test)QueryScripts.makeTestSuite("Function", "testing/ARQ/Function/manifest.n3"));
        testSuite.addTest((Test)QueryScripts.makeTestSuite("Expr1", "testing/ARQ/Expr1/manifest.n3"));
        testSuite.addTest((Test)QueryScripts.makeTestSuite("Expr2", "testing/ARQ/Expr2/manifest.n3"));
        testSuite.addTest((Test)QueryScripts.makeTestSuite("ExprEquals", "testing/ARQ/ExprEquals/manifest.n3"));
        testSuite.addTest((Test)QueryScripts.makeTestSuite("ExprBuiltIns", "testing/ARQ/ExprBuiltIns/manifest.ttl"));
        return testSuite;
    }

    public static TestSuite makeDAWGScriptTests() {
        TestSuite testSuite = new TestSuite(testSetNameDAWG);
        testSuite.addTest((Test)QueryScripts.makeTestSuite("Misc", "testing/DAWG/Misc/manifest.n3"));
        testSuite.addTest((Test)QueryScripts.makeTestSuite("Syntax", "testing/DAWG/Syntax/manifest.n3"));
        testSuite.addTest((Test)QueryScripts.makeTestSuite("Regex", "testing/DAWG/regex/manifest.n3"));
        return testSuite;
    }

    public static TestSuite makeWGTestsApproved() {
        TestSuite testSuite = new TestSuite(testSetNameWGApproved);
        testSuite.addTest((Test)QueryScripts.makeTestSuite("Simple", "testing/WG-Approved/simple/manifest.n3"));
        testSuite.addTest((Test)QueryScripts.makeTestSuite("Examples", "testing/WG-Approved/examples/manifest.n3"));
        return testSuite;
    }

    public static TestSuite makeWGTestsPending() {
        TestSuite testSuite = new TestSuite(testSetNameWGPending);
        return testSuite;
    }

    public static TestSuite makeTestSuite(String string, String string2) {
        return new QueryScripts(string, string2);
    }

    public QueryScripts(String string, String string2) {
        this(string, null, string2);
    }

    QueryScripts(String string, Model model, String string2) {
        super(string);
        this.addTests(model, string2);
    }
}

