/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.test;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.core.QueryEngineUtils;
import com.hp.hpl.jena.query.core.ResultBinding;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import java.io.OutputStream;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryTestsMisc
extends TestSuite {
    static Log log = LogFactory.getLog((Class)QueryTestsMisc.class);
    static final String testSetName = "RDQL - Query - Other";
    public static String baseURI = "http://ARQ/";

    public static TestSuite suite() {
        return new QueryTestsMisc(testSetName);
    }

    private QueryTestsMisc(String string) {
        super(string);
        try {
            this.addTest((Test)new TestQueryTriplesMerge());
            this.addTest((Test)new TestQueryGetTriples());
            this.addTest((Test)new TestQueryGetTriples2());
        }
        catch (Exception exception) {
            log.warn((Object)"Problems making ARQ test");
            return;
        }
    }

    static class TestQueryGetTriples2
    extends TestQueryTriples {
        TestQueryGetTriples2() {
            super("TestQueryGetTriples2");
        }

        protected void runTest() throws Throwable {
            Model model = ModelFactory.createDefaultModel();
            String string = "SELECT * WHERE (<" + this.r.getURI() + "> ?p ?v)";
            Query query2 = QueryFactory.create(string, "http://jena.hpl.hp.com/2003/07/query/RDQL");
            QueryExecution queryExecution = QueryExecutionFactory.create(query2, this.model);
            ResultSet resultSet = queryExecution.execSelect();
            int n = 0;
            while (resultSet.hasNext()) {
                ResultBinding resultBinding = (ResultBinding)resultSet.next();
                Collection collection = QueryEngineUtils.getStatements(resultBinding, query2);
                TestQueryGetTriples2.assertTrue((String)(this.getName() + ": getTriples2(loop " + ++n + ")"), (collection.size() == 1 ? 1 : 0) != 0);
            }
            queryExecution.close();
        }
    }

    static class TestQueryGetTriples
    extends TestQueryTriples {
        TestQueryGetTriples() {
            super("TestQueryGetTriples");
        }

        protected void runTest() throws Throwable {
            Model model = ModelFactory.createDefaultModel();
            String string = "SELECT * WHERE (<" + this.r.getURI() + "> ?p ?v)";
            Query query2 = QueryFactory.create(string, "http://jena.hpl.hp.com/2003/07/query/RDQL");
            QueryExecution queryExecution = QueryExecutionFactory.create(query2, this.model);
            ResultSet resultSet = queryExecution.execSelect();
            int n = 0;
            while (resultSet.hasNext()) {
                ResultBinding resultBinding = (ResultBinding)resultSet.next();
                Collection collection = QueryEngineUtils.getStatements(resultBinding, query2);
                TestQueryGetTriples.assertTrue((String)(this.getName() + ": getTriples(loop " + ++n + ")"), (collection.size() == 1 ? 1 : 0) != 0);
            }
            queryExecution.close();
        }
    }

    static class TestQueryTriplesMerge
    extends TestQueryTriples {
        TestQueryTriplesMerge() {
            super("TestQueryTriplesMerge");
        }

        protected void runTest() throws Throwable {
            Model model = ModelFactory.createDefaultModel();
            String string = "SELECT * WHERE (<" + this.r.getURI() + "> ?p ?v)";
            Query query2 = QueryFactory.create(string, "http://jena.hpl.hp.com/2003/07/query/RDQL");
            QueryExecution queryExecution = QueryExecutionFactory.create(query2, this.model);
            ResultSet resultSet = queryExecution.execSelect();
            while (resultSet.hasNext()) {
                ResultBinding resultBinding = (ResultBinding)resultSet.next();
                QueryEngineUtils.mergeStatements(model, resultBinding, query2);
            }
            queryExecution.close();
            if (!this.model.isIsomorphicWith(model)) {
                System.out.println();
                System.out.println("====================================");
                System.out.println("Failure: " + this.getName());
                System.out.println("Source: ----------------------------");
                this.model.write((OutputStream)System.out, "N3");
                System.out.println("Merge: -----------------------------");
                model.write((OutputStream)System.out, "N3");
                System.out.println("-----------------------------------");
                TestQueryTriplesMerge.assertTrue((String)(this.getName() + ": merged results not the same as target model"), (boolean)false);
            }
        }
    }

    static abstract class TestQueryTriples
    extends TestCase {
        Model model = ModelFactory.createDefaultModel();
        Resource r = this.model.createResource(baseURI + "r");

        TestQueryTriples(String string) {
            super(string);
            this.r.addProperty(this.model.createProperty(baseURI + "p1"), "v1");
            this.r.addProperty(this.model.createProperty(baseURI + "p2"), "v2");
        }
    }
}

