/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.test;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.BindingMap;
import com.hp.hpl.jena.query.expr.Expr;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.parser.arq.ARQParser;
import com.hp.hpl.jena.query.parser.sparql.SPARQLParser;
import java.io.ByteArrayInputStream;
import junit.framework.TestCase;

public abstract class TestExpr
extends TestCase {
    public static final int NO_FAILURE = 100;
    public static final int MUST_FAIL = 200;
    public static final int MAY_FAIL = 300;
    String testName;
    String exprString;
    Query query;
    Binding binding;
    int failureMode;

    TestExpr(String string, String string2, Query query2, Binding binding, int n) {
        this.testName = string;
        String string3 = string.replace('(', '[').replace(')', ']');
        this.setName(string3);
        this.exprString = string2;
        if (query2 == null) {
            query2 = new Query();
        }
        this.query = query2;
        if (binding == null) {
            binding = new BindingMap();
        }
        this.binding = binding;
        this.failureMode = n;
    }

    protected void runTest() throws Throwable {
        Expr expr = null;
        try {
            expr = this.parse(this.exprString);
        }
        catch (Error error) {
            this.checkException(expr, null);
            return;
        }
        catch (Exception exception) {
            this.checkException(expr, exception);
            return;
        }
        this.checkExpr(expr);
        try {
            NodeValue nodeValue = expr.eval(this.binding);
            this.checkValue(expr, nodeValue);
        }
        catch (Exception exception) {
            this.checkException(expr, exception);
        }
    }

    Expr parse(String string) throws Throwable {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return this.parseARQ(byteArrayInputStream);
    }

    Expr parseARQ(ByteArrayInputStream byteArrayInputStream) throws Throwable {
        ARQParser aRQParser = new ARQParser(byteArrayInputStream);
        aRQParser.setQuery(this.query);
        return aRQParser.Expression();
    }

    Expr parseSPARQL(ByteArrayInputStream byteArrayInputStream) throws Throwable {
        SPARQLParser sPARQLParser = new SPARQLParser(byteArrayInputStream);
        sPARQLParser.setQuery(this.query);
        return sPARQLParser.Expression();
    }

    protected boolean failureCorrect() {
        return this.failureMode != 100;
    }

    protected boolean evalCorrect() {
        return this.failureMode != 200;
    }

    abstract void checkExpr(Expr var1);

    abstract void checkValue(Expr var1, NodeValue var2);

    abstract void checkException(Expr var1, Exception var2);

    public String toString() {
        return this.testName;
    }
}

