/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.test.OWLWGTester;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestTrialOWLRules
extends TestCase {
    protected String manifest;
    protected static boolean enableTracing = false;
    protected static boolean printStats = true;
    protected static Resource configuration;

    public TestTrialOWLRules(String manifest) {
        super(manifest);
        this.manifest = manifest;
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestTrialOWLRules("SymmetricProperty/Manifest001.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("FunctionalProperty/Manifest001.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("FunctionalProperty/Manifest002.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("FunctionalProperty/Manifest003.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("InverseFunctionalProperty/Manifest001.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("InverseFunctionalProperty/Manifest002.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("InverseFunctionalProperty/Manifest003.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("rdf-charmod-uris/Manifest.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("I5.5/Manifest001.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("I5.5/Manifest002.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("I5.5/Manifest003.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("I5.5/Manifest004.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("inverseOf/Manifest001.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("TransitiveProperty/Manifest001.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("equivalentClass/Manifest001.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("equivalentClass/Manifest002.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("equivalentClass/Manifest003.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("equivalentClass/Manifest005.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("equivalentProperty/Manifest001.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("equivalentProperty/Manifest002.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("equivalentProperty/Manifest003.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("I4.6/Manifest001.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("I4.6/Manifest002.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("I5.1/Manifest001.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("I5.24/Manifest001.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("I5.24/Manifest002-mod.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("equivalentProperty/Manifest006.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("intersectionOf/Manifest001.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("differentFrom/Manifest001.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("disjointWith/Manifest001.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("disjointWith/Manifest002.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("AllDifferent/Manifest001.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("allValuesFrom/Manifest001.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("allValuesFrom/Manifest002.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("someValuesFrom/Manifest002.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("maxCardinality/Manifest001.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("maxCardinality/Manifest002.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("FunctionalProperty/Manifest005-mod.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("I5.24/Manifest004-mod.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("localtests/Manifest001.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("localtests/Manifest002.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("cardinality/Manifest001-mod.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("cardinality/Manifest002-mod.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("cardinality/Manifest003-mod.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("cardinality/Manifest004-mod.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("I5.24/Manifest003-mod.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("cardinality/Manifest005-mod.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("cardinality/Manifest006-mod.rdf"));
        suite.addTest((Test)new TestTrialOWLRules("equivalentClass/Manifest004.rdf"));
        return suite;
    }

    protected void runTest() throws IOException {
        OWLWGTester tester = new OWLWGTester((ReasonerFactory)GenericRuleReasonerFactory.theInstance(), this, configuration);
        tester.runTests(this.manifest, enableTracing, printStats);
    }

    public static void main(String[] args) {
        Model premises = FileManager.get().loadModel("file:testing/wg/someValuesFrom/premises001.rdf");
        Reasoner reasoner = GenericRuleReasonerFactory.theInstance().create(configuration);
        InfModel conclusions = ModelFactory.createInfModel((Reasoner)reasoner, (Model)premises);
        System.out.println("Premises = ");
        StmtIterator i = premises.listStatements();
        while (i.hasNext()) {
            System.out.println(" - " + i.next());
        }
        i = conclusions.getResource("http://www.w3.org/2002/03owlt/someValuesFrom/premises001#i");
        Property p = conclusions.getProperty("http://www.w3.org/2002/03owlt/someValuesFrom/premises001#p");
        Resource c = conclusions.getResource("http://www.w3.org/2002/03owlt/someValuesFrom/premises001#c");
        Resource r = conclusions.getResource("http://www.w3.org/2002/03owlt/someValuesFrom/premises001#r");
        Resource v = (Resource)i.getRequiredProperty(p).getObject();
        System.out.println("Value of i.p = " + v);
        System.out.println("Types of v are: ");
        StmtIterator it2 = conclusions.listStatements(v, RDF.type, (RDFNode)null);
        while (it2.hasNext()) {
            System.out.println(" - " + it2.next());
        }
    }

    static {
        Model m = ModelFactory.createDefaultModel();
        configuration = m.createResource("http://jena.hpl.hp.com/2003/GenericRuleReasoner");
        configuration.addProperty(ReasonerVocabulary.PROPruleMode, "hybrid");
        configuration.addProperty(ReasonerVocabulary.PROPruleSet, "etc/owl-fb-test.rules");
        configuration.addProperty(ReasonerVocabulary.PROPenableOWLTranslation, true);
    }
}

