/*
 * Decompiled with CFR 0.152.
 */
package org.sercho.masp.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sercho.masp.util.NoField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GetterSetterFinder {
    private static final Map<Class<?>, Map<String, Method>> GETTERS = new HashMap();
    private static final Map<Class<?>, Map<String, Method>> SETTERS = new HashMap();
    private static final String GETTER_PREFIX = "get";
    private static final String IS_GETTER_PREFIX = "is";
    private static final String SETTER_PREFIX = "set";
    private static final Map<Class<?>, List<Field>> CLASS_FIELDS = new HashMap();
    private static final Map<Class<?>, List<Method>> GETTERS_OF_HIDDEN_FIELDS = new HashMap();

    public static Map<String, Method> getSetters(Class<?> c) {
        if (c == null) {
            return null;
        }
        Map<String, Method> setters = SETTERS.get(c);
        if (setters == null) {
            GetterSetterFinder.initMethods(c);
            return SETTERS.get(c);
        }
        return setters;
    }

    public static Map<String, Method> getGetters(Class<?> c) {
        if (c == null) {
            return null;
        }
        Map<String, Method> getters = GETTERS.get(c);
        if (getters == null) {
            GetterSetterFinder.initMethods(c);
            return GETTERS.get(c);
        }
        return getters;
    }

    private static void initMethods(Class<?> c) {
        Method[] methods;
        HashMap<String, Method> getters = new HashMap<String, Method>();
        HashMap<String, Method> setters = new HashMap<String, Method>();
        HashMap types = new HashMap();
        for (Method method : methods = c.getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getAnnotation(NoField.class) != null) continue;
            String methodName = method.getName();
            if (methodName.startsWith(GETTER_PREFIX)) {
                GetterSetterFinder.extractGetter(methodName, method, getters, setters, types);
                continue;
            }
            if (methodName.startsWith(IS_GETTER_PREFIX)) {
                GetterSetterFinder.extractBooleanGetter(methodName, method, getters, setters, types);
                continue;
            }
            if (!methodName.startsWith(SETTER_PREFIX)) continue;
            GetterSetterFinder.extractSetter(methodName, method, getters, setters, types);
        }
        Set gettersKeySet = getters.keySet();
        Set settersKeySet = setters.keySet();
        gettersKeySet.retainAll(settersKeySet);
        settersKeySet.retainAll(gettersKeySet);
        GETTERS.put(c, Collections.unmodifiableMap(getters));
        SETTERS.put(c, Collections.unmodifiableMap(setters));
    }

    private static void extractGetter(String methodName, Method method, Map<String, Method> getters, Map<String, Method> setters, Map<String, Class<?>> types) {
        if (methodName.length() <= GETTER_PREFIX.length()) {
            return;
        }
        if (method.getParameterTypes().length == 0) {
            Class<?> fieldType = types.get(methodName = methodName.substring(GETTER_PREFIX.length()));
            if (fieldType == null) {
                fieldType = method.getReturnType();
                if (fieldType == Void.TYPE) {
                    return;
                }
                types.put(methodName, fieldType);
                getters.put(methodName, method);
                return;
            }
            if (fieldType.equals(method.getReturnType())) {
                getters.put(methodName, method);
            } else {
                setters.remove(methodName);
            }
        }
    }

    private static void extractBooleanGetter(String methodName, Method method, Map<String, Method> getters, Map<String, Method> setters, Map<String, Class<?>> types) {
        if (methodName.length() <= IS_GETTER_PREFIX.length()) {
            return;
        }
        if (method.getParameterTypes().length == 0) {
            Class<?> fieldType = types.get(methodName = methodName.substring(IS_GETTER_PREFIX.length()));
            if (fieldType == null) {
                fieldType = method.getReturnType();
                if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
                    types.put(methodName, fieldType);
                    getters.put(methodName, method);
                }
                return;
            }
            if (fieldType != Boolean.TYPE && fieldType != Boolean.class) {
                return;
            }
            if (fieldType.equals(method.getReturnType())) {
                getters.put(methodName, method);
            } else {
                setters.remove(methodName);
            }
        }
    }

    private static void extractSetter(String methodName, Method method, Map<String, Method> getters, Map<String, Method> setters, Map<String, Class<?>> types) {
        if (methodName.length() <= SETTER_PREFIX.length()) {
            return;
        }
        if (method.getReturnType() != Void.TYPE) {
            return;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 1) {
            Class<?> fieldType = types.get(methodName = methodName.substring(SETTER_PREFIX.length()));
            if (fieldType == null) {
                fieldType = parameterTypes[0];
                if (fieldType == Void.TYPE) {
                    return;
                }
                types.put(methodName, fieldType);
                setters.put(methodName, method);
                return;
            }
            if (fieldType.equals(parameterTypes[0])) {
                setters.put(methodName, method);
            } else {
                getters.remove(methodName);
            }
        }
    }

    public static Map<Field, Object> getNonNullFields(Object o) {
        HashMap<Field, Object> nonNullFields = new HashMap<Field, Object>();
        Class<?> c = o.getClass();
        List<Field> allFields = GetterSetterFinder.getFields(c);
        Iterator<Field> i = allFields.iterator();
        while (i.hasNext()) {
            Field field = i.next();
            try {
                Object value = field.get(o);
                if (value == null) continue;
                nonNullFields.put(field, value);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                i.remove();
                e.printStackTrace();
            }
        }
        return nonNullFields;
    }

    public static Map<Method, Object> getNonNullGettersOfHiddenFields(Object o) {
        HashMap<Method, Object> nonNullGetters = new HashMap<Method, Object>();
        Class<?> c = o.getClass();
        Iterator<Method> i = GetterSetterFinder.getGettersOfHiddenFields(c).iterator();
        while (i.hasNext()) {
            Method getter = i.next();
            try {
                Object value = getter.invoke(o, (Object[])null);
                if (value == null) continue;
                nonNullGetters.put(getter, value);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                i.remove();
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return nonNullGetters;
    }

    public static List<Field> getFields(Class<?> c) {
        List<Field> fields = CLASS_FIELDS.get(c);
        if (fields == null) {
            fields = new LinkedList<Field>();
            for (Field field : c.getFields()) {
                if (Modifier.isStatic(field.getModifiers()) || field.getAnnotation(NoField.class) != null) continue;
                fields.add(field);
            }
            CLASS_FIELDS.put(c, fields);
        }
        return fields;
    }

    private static List<Method> getGettersOfHiddenFields(Class<?> c) {
        List<Method> getters = GETTERS_OF_HIDDEN_FIELDS.get(c);
        if (getters == null) {
            HashMap<String, Method> getterMap = new HashMap<String, Method>(GetterSetterFinder.getGetters(c));
            for (Field field : GetterSetterFinder.getFields(c)) {
                String fieldName = field.getName();
                if (getterMap.remove(fieldName) != null) continue;
                char firstChar = fieldName.charAt(0);
                getterMap.remove(Character.toUpperCase(firstChar) + fieldName.substring(1));
            }
            getters = new ArrayList(getterMap.values());
            GETTERS_OF_HIDDEN_FIELDS.put(c, getters);
        }
        return getters;
    }

    public static String toString(Object o) {
        if (o == null) {
            return "null";
        }
        StringBuffer buffer = new StringBuffer(100);
        Class<?> c = o.getClass();
        buffer.append(c.getSimpleName());
        Map<Method, Object> getters = GetterSetterFinder.getNonNullGettersOfHiddenFields(o);
        Map<Field, Object> fields = GetterSetterFinder.getNonNullFields(o);
        int count = getters.size() + fields.size();
        buffer.append('[');
        if (count == 0) {
            buffer.append(']');
            return buffer.toString();
        }
        for (Map.Entry<Method, Object> entry : getters.entrySet()) {
            String fieldName = entry.getKey().getName();
            fieldName = fieldName.startsWith(GETTER_PREFIX) ? fieldName.substring(GETTER_PREFIX.length()) : fieldName.substring(IS_GETTER_PREFIX.length());
            buffer.append(Character.toLowerCase(fieldName.charAt(0)) + fieldName.substring(1));
            buffer.append('=');
            buffer.append(entry.getValue());
            if (--count < 1) {
                buffer.append(']');
                return buffer.toString();
            }
            buffer.append(", ");
        }
        for (Map.Entry<AccessibleObject, Object> entry : fields.entrySet()) {
            buffer.append(((Field)entry.getKey()).getName());
            buffer.append('=');
            buffer.append(entry.getValue());
            if (--count < 1) {
                buffer.append(']');
                return buffer.toString();
            }
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public static void setFieldValue(Object object, String fieldName, Object newValue) {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName is null");
        }
        GetterSetterFinder.set(object, fieldName, newValue);
    }

    private static void set(Object object, String fieldName, Object newValue) {
        Map<String, Method> setters = GetterSetterFinder.getSetters(object.getClass());
        char firstChar = fieldName.charAt(0);
        String nameWithoutFirstChar = fieldName.substring(1);
        String upperCase = Character.toUpperCase(firstChar) + nameWithoutFirstChar;
        Method setter = setters.get(upperCase);
        if (setter != null) {
            try {
                setter.invoke(object, newValue);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Failed to access setter: " + setter, e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Failed to invoke setter: " + setter, e);
            }
            return;
        }
        String lowerCase = Character.toLowerCase(firstChar) + nameWithoutFirstChar;
        List<Field> fields = GetterSetterFinder.getFields(object.getClass());
        Field f = null;
        for (Field field : fields) {
            if (lowerCase.equals(field.getName())) {
                f = field;
                break;
            }
            if (!upperCase.equals(field.getName())) continue;
            f = field;
            break;
        }
        if (f == null) {
            throw new IllegalArgumentException("Failed to access field: " + fieldName + " of " + object.getClass().getName() + ": " + object);
        }
        try {
            f.set(object, newValue);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to set new value of field: " + fieldName + " of " + object.getClass().getName() + ": " + object, e);
        }
    }

    public static Object getFieldValue(Object object, String fieldName) {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName is null");
        }
        return GetterSetterFinder.get(object, fieldName);
    }

    private static Object get(Object object, String fieldName) {
        Map<String, Method> getters = GetterSetterFinder.getGetters(object.getClass());
        char firstChar = fieldName.charAt(0);
        String nameWithoutFirstChar = fieldName.substring(1);
        String upperCase = Character.toUpperCase(firstChar) + nameWithoutFirstChar;
        Method getter = getters.get(upperCase);
        if (getter != null) {
            try {
                return getter.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Failed to access getter: " + getter, e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Failed to invoke getter: " + getter, e);
            }
        }
        String lowerCase = Character.toLowerCase(firstChar) + nameWithoutFirstChar;
        List<Field> fields = GetterSetterFinder.getFields(object.getClass());
        Field f = null;
        for (Field field : fields) {
            if (lowerCase.equals(field.getName())) {
                f = field;
                break;
            }
            if (!upperCase.equals(field.getName())) continue;
            f = field;
            break;
        }
        if (f == null) {
            throw new IllegalArgumentException("Failed to access field: " + fieldName + " of " + object.getClass().getName() + ": " + object);
        }
        try {
            return f.get(object);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Failed to get value of field: " + fieldName + " of " + object.getClass().getName() + ": " + object, e);
        }
    }

    public static Class<?> getFieldType(Object object, String fieldName) {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName is null");
        }
        Map<String, Method> getters = GetterSetterFinder.getGetters(object.getClass());
        char firstChar = fieldName.charAt(0);
        String nameWithoutFirstChar = fieldName.substring(1);
        String upperCase = Character.toUpperCase(firstChar) + nameWithoutFirstChar;
        Method getter = getters.get(upperCase);
        if (getter != null) {
            return getter.getReturnType();
        }
        String lowerCase = Character.toLowerCase(firstChar) + nameWithoutFirstChar;
        List<Field> fields = GetterSetterFinder.getFields(object.getClass());
        Field f = null;
        for (Field field : fields) {
            if (lowerCase.equals(field.getName())) {
                f = field;
                break;
            }
            if (!upperCase.equals(field.getName())) continue;
            f = field;
            break;
        }
        if (f == null) {
            throw new IllegalArgumentException("Failed to access field: " + fieldName + " of " + object.getClass().getName() + ": " + object);
        }
        return f.getType();
    }

    public static <T> boolean equals(T o1, T o2) {
        Map<Method, Object> getters2;
        Map<Field, Object> fields2;
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        Map<Field, Object> fields1 = GetterSetterFinder.getNonNullFields(o1);
        if (!GetterSetterFinder.compare(fields1, fields2 = GetterSetterFinder.getNonNullFields(o2))) {
            return false;
        }
        Map<Method, Object> getters1 = GetterSetterFinder.getNonNullGettersOfHiddenFields(o1);
        if (!GetterSetterFinder.compare(getters1, getters2 = GetterSetterFinder.getNonNullGettersOfHiddenFields(o2))) {
            return false;
        }
        if (fields1.isEmpty() && getters1.isEmpty() && Comparable.class.isInstance(o1)) {
            try {
                return ((Comparable)Comparable.class.cast(o1)).compareTo(o2) == 0;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return true;
    }

    private static boolean compare(Map<?, ?> map1, Map<?, ?> map2) {
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<?, ?> entry : map1.entrySet()) {
            if (GetterSetterFinder.equals(entry.getValue(), map2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private GetterSetterFinder() {
    }
}

