/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.presentation;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.io.owl_rdf.OWLRDFParser;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLNamedObject;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.util.OWLConnection;
import org.semanticweb.owl.util.OWLManager;
import uk.ac.man.cs.img.owl.io.html.Linker;
import uk.ac.man.cs.img.owl.io.html.OntologyRenderer;

public class PresentationServlet
extends HttpServlet {
    public PresentationServlet() {
        BasicConfigurator.configure();
        System.setProperty("org.semanticweb.owl.util.OWLConnection", "org.semanticweb.owl.impl.model.OWLConnectionImpl");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doRequest(request, response);
    }

    public void doRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block23: {
            response.setContentType("text/html");
            PrintWriter out = new PrintWriter(response.getWriter());
            OWLOntology ontology = null;
            try {
                if (request.getParameter("style") != null) {
                    response.setContentType("text/plain");
                    out.println("body {");
                    out.println("font-family: arial;");
                    out.println("background-color: #EEEEEE;");
                    out.println("margin: 10 10 10 10;");
                    out.println("}");
                    out.println("a {");
                    out.println("text-decoration:none;");
                    out.println("font-weight:bold;");
                    out.println("color: #00c;");
                    out.println("}");
                    out.println("a.visited {");
                    out.println("color: #00c;");
                    out.println("}");
                    out.println("a:hover {");
                    out.println("background-color: #aaa;");
                    out.println("color: #fff;");
                    out.println("}");
                    out.println(".yes {");
                    out.println("font-weight: bold;");
                    out.println("color: green;");
                    out.println("}");
                    out.println(".no {");
                    out.println("font-weight: bold;");
                    out.println("color: red;");
                    out.println("}");
                    out.println(".collection {");
                    out.println("}");
                    out.println(".item {");
                    out.println("display: block;");
                    out.println("}");
                    out.println(".keyword {");
                    out.println("color: #060;");
                    out.println("}");
                    out.println(".object {");
                    out.println("}");
                    out.println(".faint {");
                    out.println("background-color: #FFFFFF;");
                    out.println("color: #AAAAAA;");
                    out.println("}");
                    out.println(".box {");
                    out.println("padding: 5px 5px 5px 5px;");
                    out.println("border:1px solid #888;");
                    out.println("background-color: #FFFFFF;");
                    out.println("}");
                    break block23;
                }
                if (request.getParameter("url") != null) {
                    HttpSession session = request.getSession(true);
                    try {
                        String url = request.getParameter("url");
                        URI uri = new URI(url.trim());
                        OWLConnection connection = OWLManager.getOWLConnection();
                        OWLRDFParser parser = new OWLRDFParser();
                        parser.setConnection(connection);
                        ontology = parser.parseOntology(uri);
                        session.putValue("ontology", (Object)ontology);
                        OntologyRenderer renderer = new OntologyRenderer(ontology);
                        session.putValue("renderer", (Object)renderer);
                        this.printFrame(ontology, out);
                    }
                    catch (Exception ex) {
                        out.println("Error: " + ex.getMessage());
                    }
                    break block23;
                }
                if (request.getParameter("panel") != null) {
                    HttpSession session = request.getSession(true);
                    ontology = (OWLOntology)session.getValue("ontology");
                    final OntologyRenderer renderer = (OntologyRenderer)session.getValue("renderer");
                    String panel = request.getParameter("panel");
                    if (panel.equals("overview")) {
                        this.printHeader(out);
                        out.println("<h1>Overview</h1>");
                        out.println("<div class='box'>");
                        out.println("<div class='collection'>");
                        out.println("<a class='item' href=\"Presentation?panel=object\" target=\"right\">Ontology</a>");
                        out.println("<a class='item' href=\"Presentation?panel=list&things=classes\" target=\"bottomleft\">Classes</a>");
                        out.println("<a class='item' href=\"Presentation?panel=list&things=objectProperties\" target=\"bottomleft\">Object Properties</a>");
                        out.println("<a class='item' href=\"Presentation?panel=list&things=dataProperties\" target=\"bottomleft\">Data Properties</a>");
                        out.println("<a class='item' href=\"Presentation?panel=list&things=annotationProperties\" target=\"bottomleft\">Annotation Properties</a>");
                        out.println("<a href=\"Presentation?panel=list&things=individuals\" target=\"bottomleft\">Individuals</a>");
                        out.println("</div>");
                        out.println("</div>");
                        this.printFooter(out);
                        break block23;
                    }
                    if (panel.equals("list")) {
                        this.printHeader(out);
                        String things = request.getParameter("things");
                        out.println("<div class='box'>");
                        Linker linker = new Linker(){

                            public String linkFor(OWLNamedObject ono) throws OWLException {
                                return "<a class='object' href=\"Presentation?panel=object&object=" + URLEncoder.encode(ono.getURI().toString()) + "\" target=\"right\">" + renderer.shortForm(ono.getURI()) + "</a>";
                            }
                        };
                        if (things == null || things.equals("classes")) {
                            out.println("<h1>Classes</h1>");
                            renderer.listClasses(out, linker);
                        } else if (request.getParameter("things").equals("objectProperties")) {
                            out.println("<h1>Object Properties</h1>");
                            renderer.listObjectProperties(out, linker);
                        } else if (request.getParameter("things").equals("dataProperties")) {
                            out.println("<h1>Data Properties</h1>");
                            renderer.listDataProperties(out, linker);
                        } else if (request.getParameter("things").equals("annotationProperties")) {
                            out.println("<h1>Annotation Properties</h1>");
                            renderer.listAnnotationProperties(out, linker);
                        } else if (request.getParameter("things").equals("individuals")) {
                            out.println("<h1>Individuals</h1>");
                            renderer.listIndividuals(out, linker);
                        }
                        out.println("</div>");
                        this.printFooter(out);
                        break block23;
                    }
                    if (!panel.equals("object")) break block23;
                    this.printHeader(out);
                    try {
                        if (request.getParameter("object") == null) {
                            out.println("<div class='box'>");
                            out.println("<h1>Ontology: &lt;" + ontology.getURI() + "&gt;</h1>");
                            out.println("<h2>Imports</h2>");
                            Iterator it = ontology.getIncludedOntologies().iterator();
                            while (it.hasNext()) {
                                OWLOntology imported = (OWLOntology)it.next();
                                out.println("<a target=\"_top\" href=\"Presentation?url=" + imported.getURI() + "\">&lt;" + imported.getURI() + "&gt;</a><br>");
                            }
                            renderer.writeShortNames(out);
                            out.println("</div>");
                        } else {
                            String uri = request.getParameter("object");
                            out.println("<div class='box'>");
                            Linker linker = new Linker(){

                                public String linkFor(OWLNamedObject ono) throws OWLException {
                                    return "<a class='object' href=\"Presentation?panel=object&object=" + URLEncoder.encode(ono.getURI().toString()) + "\" target=\"right\">" + renderer.shortForm(ono.getURI()) + "</a>";
                                }
                            };
                            renderer.renderURI(new URI(uri), out, linker);
                            out.println("</div>");
                        }
                    }
                    catch (URISyntaxException ex) {
                        // empty catch block
                    }
                    this.printFooter(out);
                    break block23;
                }
                this.printHeader(out);
                out.println("<h1>OWL Ontology HTML Presentation</h1>");
                out.println("<p>Paste the URL of an OWL-RDF ontology into the box below and hit return. The servlet will then return an HTML rendering of the ontology. Clicking on classes or properties will take you to the definition of the given object. Note that the rendering provides a view of the <em>local</em> assertions in the given ontology. Any assertions, definitions, axioms etc. from imported ontologies will <strong>not</strong> be shown. Classes or properties that are used from imported ontologies are, however, shown.<p>");
                out.println("<p>Or try the <a href=\"Presentation?url=http://www.w3.org/2001/sw/WebOnt/guide-src/wine\">OWL Guide ontology</a></p>");
                out.println("<hr/>");
                out.println("<form action=\"Presentation\" method=\"put\">");
                out.println("<table>");
                out.println("<tr>");
                out.println("<td><b>URL:</b></td>");
                out.println("<td>");
                out.println("<input type=\"text\" size=\"80\" name=\"url\"/></td>");
                out.println("</td>");
                out.println("</tr>");
                out.println("</table>");
                out.println("</form>");
                this.printFooter(out);
            }
            catch (OWLException e) {
                out.println("Error: " + e.getMessage());
            }
        }
    }

    protected void printHeader(PrintWriter out) {
        out.println("<html>");
        out.println("<head>");
        out.println("<link REL=\"stylesheet\" TYPE=\"text/css\" HREF=\"Presentation?style\">");
        out.println("</head>");
        out.println("<body>");
    }

    protected void printFooter(PrintWriter out) {
        out.println("</body>");
        out.println("</html>");
    }

    protected void printFrame(OWLOntology ontology, PrintWriter out) throws OWLException {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<!DOCTYPE html");
        out.println("     PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"");
        out.println("    \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        out.println("<html lang=\"en\">");
        out.println("<head>");
        out.println("<title>" + ontology.getURI() + "</title>");
        out.println("</head>");
        out.println("<frameset cols=\"20%,80%\">");
        out.println("<frameset rows=\"30%,70%\">");
        out.println("<frame src=\"Presentation?panel=overview\" name=\"topleft\">");
        out.println("<frame src=\"Presentation?panel=list\" name=\"bottomleft\">");
        out.println("</frameset>");
        out.println("<frame src=\"Presentation?panel=object\" name=\"right\">");
        out.println("</frameset>");
        out.println("</html>");
    }
}

