/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.validation;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.validation.SpeciesValidatorReporter;
import uk.ac.man.cs.img.owl.fixing.Fixer;
import uk.ac.man.cs.img.owl.validation.SpeciesValidator;

public class FixerServlet
extends HttpServlet {
    public FixerServlet() {
        BasicConfigurator.configure();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doRequest(request, response);
    }

    public void doRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html;charset=utf-8");
        PrintWriter out = new PrintWriter(response.getWriter());
        this.printHeader(out);
        boolean printAbstract = true;
        boolean printLisp = false;
        boolean printConstructs = false;
        String url = request.getParameter("url");
        if (url != null && !url.equals("")) {
            try {
                URI uri = new URI(url.trim());
                SpeciesValidator validator = new SpeciesValidator();
                SpeciesValidatorReporter reporter = new SpeciesValidatorReporter(){

                    public void message(String str) {
                    }

                    public void explain(int l, int c, String str) {
                    }

                    public void ontology(OWLOntology ontology) {
                    }

                    public void done(String level) {
                    }
                };
                validator.setReporter(reporter);
                Fixer fixer = new Fixer();
                StringWriter rw = new StringWriter();
                StringWriter mw = new StringWriter();
                PrintWriter rpw = new PrintWriter(rw);
                PrintWriter mpw = new PrintWriter(mw);
                fixer.setReportWriter(rpw);
                fixer.setMessageWriter(mpw);
                out.println("<h1>OWL Patching Report</h1>");
                out.println("URI: <a href=\"" + uri + "\">" + uri + "</a>");
                boolean done = false;
                for (int opti = 0; !done && opti < Fixer.options.length; ++opti) {
                    Object obj;
                    Iterator it;
                    Fixer.Strategy strategy = fixer.newStrategy(Fixer.options[opti]);
                    fixer.setStrategy(strategy);
                    int result = fixer.applyStrategy(uri, null);
                    if (result != 0) continue;
                    done = true;
                    out.println("<h2>Details</h2>");
                    out.println("<p>Patching was successful. Options employed were:</p>");
                    out.println("<ul>");
                    if (fixer.getStrategy().fixOthers) {
                        out.println("<li><strong>Adding type triples</strong></li>");
                    }
                    if (fixer.getStrategy().fixDC) {
                        out.println("<li><strong>Adding Annotation type triples for DC vocabulary.</strong></li>");
                    }
                    if (fixer.getStrategy().laxSchema) {
                        out.println("<li><strong>Ignoring inclusion of OWL/RDF/RDF(S) schemas.</strong></li>");
                    }
                    if (fixer.getStrategy().laxSameAs) {
                        out.println("<li><strong>Handling inappropriate <code>owl:sameAs</code> use.</strong></li>");
                    }
                    out.println("</ul>");
                    if (fixer.getFixes().isEmpty()) {
                        out.println("<p>No triples need to be added to the ontology.</p>");
                        continue;
                    }
                    out.println("Type triples that need to be added to the ontology are as follows.");
                    out.println("<ul>");
                    Set[] untyped = fixer.getUntyped();
                    if (!untyped[Fixer.CLASSES].isEmpty()) {
                        out.println("<li><strong>Classes:</strong>");
                        out.println("<ul>");
                        it = untyped[Fixer.CLASSES].iterator();
                        while (it.hasNext()) {
                            obj = it.next();
                            out.println("<li>" + obj + "</li>");
                        }
                        out.println("</ul>");
                        out.println("</li>");
                    }
                    if (!untyped[Fixer.INDIVIDUALS].isEmpty()) {
                        out.println("<li><strong>Individuals:</strong>");
                        out.println("<ul>");
                        it = untyped[Fixer.INDIVIDUALS].iterator();
                        while (it.hasNext()) {
                            obj = it.next();
                            out.println("<li>" + obj + "</li>");
                        }
                        out.println("</ul>");
                        out.println("</li>");
                    }
                    if (!untyped[Fixer.DATATYPES].isEmpty()) {
                        out.println("<li><strong>Datatypes:</strong>");
                        out.println("<ul>");
                        it = untyped[Fixer.DATATYPES].iterator();
                        while (it.hasNext()) {
                            obj = it.next();
                            out.println("<li>" + obj + "</li>");
                        }
                        out.println("</ul>");
                        out.println("</li>");
                    }
                    if (!untyped[Fixer.OBJECT_PROPERTIES].isEmpty()) {
                        out.println("<li><strong>Object Properties:</strong>");
                        out.println("<ul>");
                        it = untyped[Fixer.OBJECT_PROPERTIES].iterator();
                        while (it.hasNext()) {
                            obj = it.next();
                            out.println("<li>" + obj + "</li>");
                        }
                        out.println("</ul>");
                        out.println("</li>");
                    }
                    if (!untyped[Fixer.DATATYPE_PROPERTIES].isEmpty()) {
                        out.println("<li><strong>Datatype Properties:</strong>");
                        out.println("<ul>");
                        it = untyped[Fixer.DATATYPE_PROPERTIES].iterator();
                        while (it.hasNext()) {
                            obj = it.next();
                            out.println("<li>" + obj + "</li>");
                        }
                        out.println("</ul>");
                        out.println("</li>");
                    }
                    if (!untyped[Fixer.ANNOTATION_PROPERTIES].isEmpty()) {
                        out.println("<li><strong>Annotation Properties:</strong>");
                        out.println("<ul>");
                        it = untyped[Fixer.ANNOTATION_PROPERTIES].iterator();
                        while (it.hasNext()) {
                            obj = it.next();
                            out.println("<li>" + obj + "</li>");
                        }
                        out.println("</ul>");
                        out.println("</li>");
                    }
                    out.println("</ul>");
                    out.println("<p>RDF serialization of type triples:</p>");
                    out.println("<div class='box'>");
                    out.println("<pre>");
                    it = fixer.getFixes().iterator();
                    while (it.hasNext()) {
                        String str = (String)it.next();
                        out.print(str.replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
                    }
                    out.println("</pre>");
                    out.println("</div>");
                }
                if (!done) {
                    out.println("<h2>Details</h2>");
                    out.println("<div class='box'>");
                    out.println("<pre>");
                    out.println("Sorry. The Patcher is unable to patch this ontology.");
                    out.println("</pre>");
                    out.println("</div>");
                }
                out.println("<hr/>");
                this.printForm(out, url);
            }
            catch (OWLException e) {
                out.println("OWL Exception! " + e.getMessage());
                this.printForm(out, url);
            }
            catch (URISyntaxException e) {
                out.println("URI Syntax Exception! " + url);
                this.printForm(out, url);
            }
        } else {
            this.printInfo(out);
            this.printForm(out, "");
        }
        this.printFooter(out);
    }

    protected void printHeader(PrintWriter out) {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<!DOCTYPE html");
        out.println("     PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"");
        out.println("    \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        out.println("<html lang=\"en\">");
        out.println("<head>");
        out.println("<title>OWL Ontology Patcher</title>");
        out.println("<style type=\"text/css\">");
        out.println("body {");
        out.println("font-family: arial;");
        out.println("background-color: #EEEEEE;");
        out.println("margin: 40 40 40 40;");
        out.println("}");
        out.println(".yes {");
        out.println("font-weight: bold;");
        out.println("color: green;");
        out.println("}");
        out.println(".no {");
        out.println("font-weight: bold;");
        out.println("color: red;");
        out.println("}");
        out.println(".faint {");
        out.println("background-color: #FFFFFF;");
        out.println("color: #AAAAAA;");
        out.println("}");
        out.println(".box {");
        out.println("padding: 0px 20px 10px 20px;");
        out.println("border:1px solid #888;");
        out.println("background-color: #FFFFFF;");
        out.println("}");
        out.println(".box2 {");
        out.println("padding: 0px 20px 10px 20px;");
        out.println("border:1px solid #888;");
        out.println("background-color: #FFFF99;");
        out.println("}");
        out.println("</style>");
        out.println("</head>");
        out.println("<body>");
    }

    protected void printFooter(PrintWriter out) {
        this.printHost(out);
        out.println("</body>");
        out.println("</html>");
    }

    protected void printInfo(PrintWriter out) {
        out.println("<h1>OWL Ontology Patcher</h1>");
        out.println("<p>This service will try and produce a valid OWL DL ontology. It does");
        out.println("this by adopting a number of strategies including:</p>");
        out.println("");
        out.println("<ul>");
        out.println("");
        out.println("<li>Adding type triples where necessary.</li>");
        out.println("");
        out.println("<li>Ignoring import of the OWL,RDF or RDF(S) schema.</li>");
        out.println("");
        out.println("<li>Treating vocabulary \"misuse\" such as <code>owl:sameAs</code>");
        out.println("used for Classes or Properties.</li>");
        out.println("");
        out.println("</ul>");
        out.println("");
        out.println("<p>The service uses a number of heuristics. In");
        out.println("some situations, this could change the semantics of your ontology,");
        out.println("particularly if you are really interested in OWL Full reasoning.</p>");
    }

    protected void printForm(PrintWriter out, String uri) {
        out.println("<form action=\"Patcher\" method=\"get\">");
        out.println("<table>");
        out.println("<tr><td>");
        out.println(" <table>");
        out.println("  <tr>");
        out.println("  <td><b>URL:</b></td>");
        out.println("  <td><input type=\"text\" size=\"80\" name=\"url\" value=\"" + uri + "\"/></td>");
        out.println("  <td><input type=\"submit\" value=\" Fix \"/></td>");
        out.println("  </tr>");
        out.println(" </table>");
        out.println("</td></tr>");
        out.println("</table>");
        out.println("</form>");
    }

    protected void printHost(PrintWriter out) {
        String host;
        try {
            host = InetAddress.getLocalHost().getHostName() + " [" + InetAddress.getLocalHost().getHostAddress() + "] ";
        }
        catch (UnknownHostException e) {
            host = "unknown";
        }
        out.println("<table>");
        out.println("<tr>");
        out.println("<td><span style='font-size:xx-small;'>OWL Patcher running on " + host + " under " + this.getServletContext().getServerInfo() + "</span></td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td><span style='font-size:xx-small;'>&copy; University of Manchester, 2003, &copy; University of Karlsruhe, 2003</span></td>");
        out.println("</tr>");
        out.println("</table>");
    }

    protected void printHelp(PrintWriter out) {
    }
}

