/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.validation;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.util.OWLConnection;
import uk.ac.man.cs.img.owl.validation.OWLTestRunner;

public class ValidationTestServlet
extends HttpServlet {
    private OWLConnection connection = null;
    private OWLTestRunner runner = null;

    public ValidationTestServlet() throws ServletException {
        BasicConfigurator.configure();
        System.setProperty("org.semanticweb.owl.util.OWLConnection", "org.semanticweb.owl.impl.model.OWLConnectionImpl");
        this.runner = new OWLTestRunner();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doRequest(request, response);
    }

    public void doRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html;charset=utf-8");
        PrintWriter out = new PrintWriter(response.getWriter());
        this.printHeader(out);
        String url = request.getParameter("url");
        if (url != null && !url.equals("")) {
            try {
                URI uri = new URI(url.trim());
                out.println("<div class='box'>");
                this.runner.runTest(uri, (Writer)out);
                out.println("</div>");
                out.println("<form action=\"TestValidator\" method=\"get\">");
                out.println(" <table>");
                out.println("  <tr>");
                out.println("  <td><b>URL:</b></td>");
                out.println("  <td><input type=\"text\" size=\"80\" name=\"url\" value=\"" + uri + "\"/></td>");
                out.println("  <td><input type=\"submit\" value=\" Validate \"/></td>");
                out.println("  </tr>");
                out.println(" </table>");
                out.println("</form>");
            }
            catch (Exception e) {
                out.println("Server Exception: " + e.getMessage());
                this.printForm(out);
            }
            catch (Throwable e) {
                out.println("Server Exception: " + e.getMessage());
                this.printForm(out);
            }
        } else {
            this.printInfo(out);
            this.printForm(out);
        }
        this.printFooter(out);
    }

    protected void printHeader(PrintWriter out) {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<!DOCTYPE html");
        out.println("     PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"");
        out.println("    \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        out.println("<html lang=\"en\">");
        out.println("<head>");
        out.println("<title>OWL Validation Test Harness</title>");
        out.println("<style type=\"text/css\">");
        out.println("body {");
        out.println("font-family: arial;");
        out.println("background-color: #EEEEEE;");
        out.println("margin: 40 40 40 40;");
        out.println("}");
        out.println(".yes {");
        out.println("font-weight: bold;");
        out.println("color: green;");
        out.println("}");
        out.println(".no {");
        out.println("font-weight: bold;");
        out.println("color: red;");
        out.println("}");
        out.println(".faint {");
        out.println("background-color: #FFFFFF;");
        out.println("color: #AAAAAA;");
        out.println("}");
        out.println(".box {");
        out.println("padding: 0px 20px 10px 20px;");
        out.println("border:1px solid #888;");
        out.println("background-color: #FFFFFF;");
        out.println("}");
        out.println("</style>");
        out.println("</head>");
        out.println("<body>");
    }

    protected void printFooter(PrintWriter out) {
        this.printHost(out);
        out.println("</body>");
        out.println("</html>");
    }

    protected void printInfo(PrintWriter out) {
        out.println("<h1>OWL Validation Test Harness</h1>");
        out.println("<p>Paste the URL of an OWL test manifest box below, hit return or press the Validate button. The servlet will then attempt to validate the ontologies named in the manifest.");
        out.println("</p><p>No guarantees are provided as to the correctness of this software.</p>");
        out.println("<hr/>");
    }

    protected void printForm(PrintWriter out) {
        out.println("<form action=\"TestValidator\" method=\"get\">");
        out.println("<table>");
        out.println("<tr><td>");
        out.println(" <table>");
        out.println("  <tr>");
        out.println("  <td><b>URL:</b></td>");
        out.println("  <td><input type=\"text\" size=\"80\" name=\"url\"/></td>");
        out.println("  <td><input type=\"submit\" value=\" Validate \"/></td>");
        out.println("  </tr>");
        out.println(" </table>");
        out.println("</form>");
    }

    protected void printHost(PrintWriter out) {
        String host;
        try {
            host = InetAddress.getLocalHost().getHostName() + " [" + InetAddress.getLocalHost().getHostAddress() + "] ";
        }
        catch (UnknownHostException e) {
            host = "unknown";
        }
        out.println("<table>");
        out.println("<tr>");
        out.println("<td><span style='font-size:xx-small;'>OWL Validator running on " + host + " under " + this.getServletContext().getServerInfo() + "</span></td>");
        out.println("</tr>");
        out.println("<tr>");
        out.println("<td><span style='font-size:xx-small;'>&copy; University of Manchester, 2003, &copy; University of Karlsruhe, 2003</span></td>");
        out.println("</tr>");
        out.println("</table>");
    }

    protected void printHelp(PrintWriter out) {
    }
}

