/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.validation;

import java.net.URI;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.semanticweb.owl.impl.model.OWLOntologyImpl;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.change.AddClassAxiom;
import org.semanticweb.owl.model.change.ChangeVisitor;
import org.semanticweb.owl.validation.SpeciesValidatorReporter;
import uk.ac.man.cs.img.owl.validation.SpeciesValidator;
import uk.ac.man.cs.img.owl.validation.ValidationTest;
import uk.ac.man.cs.img.owl.validation.ValidatorLogger;

public class ClassAxiomTest
extends ValidationTest {
    private OWLEntity[] entities;
    private SpeciesValidator sv;

    public ClassAxiomTest(String testName, OWLDataFactory factory) {
        super(testName, factory);
    }

    public static Test suite(OWLDataFactory fact) {
        TestSuite suite = new TestSuite("ClassAxiom");
        suite.addTest((Test)new ClassAxiomTest("testDisjointClasses", fact));
        suite.addTest((Test)new ClassAxiomTest("testEquivalentClassesLite", fact));
        suite.addTest((Test)new ClassAxiomTest("testSubClassesLite", fact));
        suite.addTest((Test)new ClassAxiomTest("testEquivalentClassesDL", fact));
        suite.addTest((Test)new ClassAxiomTest("testSubClassesDL", fact));
        return suite;
    }

    public void testDisjointClasses() throws Throwable {
        SpeciesValidator sv = new SpeciesValidator();
        sv.setReporter((SpeciesValidatorReporter)new ValidatorLogger());
        URI uri = new URI("http://example.org/test-disj");
        OWLOntology ontology = this.factory.getOWLOntology(uri, uri);
        ClassAxiomTest.assertTrue((boolean)sv.isOWLLite(ontology));
        OWLOntologyImpl changeVisitor = (OWLOntologyImpl)ontology;
        this.addEntities(ontology, (ChangeVisitor)changeVisitor);
        HashSet<OWLClass> set = new HashSet<OWLClass>();
        set.add(this.testClasses[0]);
        set.add(this.testClasses[1]);
        OWLDisjointClassesAxiom axiom = this.factory.getOWLDisjointClassesAxiom(set);
        AddClassAxiom evt = new AddClassAxiom(ontology, (OWLClassAxiom)axiom, null);
        evt.accept((ChangeVisitor)changeVisitor);
        ClassAxiomTest.assertTrue((!sv.isOWLLite(ontology) ? 1 : 0) != 0);
    }

    public void testEquivalentClassesLite() throws Throwable {
        SpeciesValidator sv = new SpeciesValidator();
        sv.setReporter((SpeciesValidatorReporter)new ValidatorLogger());
        URI uri = new URI("http://example.org/test-eqs-lite");
        OWLOntology ontology = this.factory.getOWLOntology(uri, uri);
        ClassAxiomTest.assertTrue((boolean)sv.isOWLLite(ontology));
        OWLOntologyImpl changeVisitor = (OWLOntologyImpl)ontology;
        this.addEntities(ontology, (ChangeVisitor)changeVisitor);
        HashSet<OWLClass> set = new HashSet<OWLClass>();
        set.add(this.testClasses[0]);
        set.add(this.testClasses[1]);
        OWLEquivalentClassesAxiom axiom = this.factory.getOWLEquivalentClassesAxiom(set);
        AddClassAxiom evt = new AddClassAxiom(ontology, (OWLClassAxiom)axiom, null);
        evt.accept((ChangeVisitor)changeVisitor);
        ClassAxiomTest.assertTrue((boolean)sv.isOWLLite(ontology));
    }

    public void testEquivalentClassesDL() throws Throwable {
        SpeciesValidator sv = new SpeciesValidator();
        sv.setReporter((SpeciesValidatorReporter)new ValidatorLogger());
        URI uri = new URI("http://example.org/test-eqs-dl");
        OWLOntology ontology = this.factory.getOWLOntology(uri, uri);
        ClassAxiomTest.assertTrue((boolean)sv.isOWLLite(ontology));
        OWLOntologyImpl changeVisitor = (OWLOntologyImpl)ontology;
        this.addEntities(ontology, (ChangeVisitor)changeVisitor);
        HashSet<Object> set = new HashSet<Object>();
        set.add(this.testClasses[0]);
        set.add(this.testOr);
        OWLEquivalentClassesAxiom axiom = this.factory.getOWLEquivalentClassesAxiom(set);
        AddClassAxiom evt = new AddClassAxiom(ontology, (OWLClassAxiom)axiom, null);
        evt.accept((ChangeVisitor)changeVisitor);
        ClassAxiomTest.assertTrue((!sv.isOWLLite(ontology) ? 1 : 0) != 0);
    }

    public void testSubClassesLite() throws Throwable {
        SpeciesValidator sv = new SpeciesValidator();
        sv.setReporter((SpeciesValidatorReporter)new ValidatorLogger());
        URI uri = new URI("http://example.org/test-subclass-lite");
        OWLOntology ontology = this.factory.getOWLOntology(uri, uri);
        ClassAxiomTest.assertTrue((boolean)sv.isOWLLite(ontology));
        OWLOntologyImpl changeVisitor = (OWLOntologyImpl)ontology;
        this.addEntities(ontology, (ChangeVisitor)changeVisitor);
        OWLSubClassAxiom axiom = this.factory.getOWLSubClassAxiom((OWLDescription)this.testClasses[0], (OWLDescription)this.testClasses[1]);
        AddClassAxiom evt = new AddClassAxiom(ontology, (OWLClassAxiom)axiom, null);
        evt.accept((ChangeVisitor)changeVisitor);
        ClassAxiomTest.assertTrue((boolean)sv.isOWLLite(ontology));
    }

    public void testSubClassesDL() throws Throwable {
        SpeciesValidator sv = new SpeciesValidator();
        sv.setReporter((SpeciesValidatorReporter)new ValidatorLogger());
        URI uri = new URI("http://example.org/test-subclass-dl");
        OWLOntology ontology = this.factory.getOWLOntology(uri, uri);
        ClassAxiomTest.assertTrue((boolean)sv.isOWLLite(ontology));
        OWLOntologyImpl changeVisitor = (OWLOntologyImpl)ontology;
        this.addEntities(ontology, (ChangeVisitor)changeVisitor);
        OWLSubClassAxiom axiom = this.factory.getOWLSubClassAxiom((OWLDescription)this.testClasses[0], (OWLDescription)this.testOr);
        AddClassAxiom evt = new AddClassAxiom(ontology, (OWLClassAxiom)axiom, null);
        evt.accept((ChangeVisitor)changeVisitor);
        ClassAxiomTest.assertTrue((!sv.isOWLLite(ontology) ? 1 : 0) != 0);
    }
}

