/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.validation;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.util.OWLConnection;
import org.semanticweb.owl.util.OWLManager;
import uk.ac.man.cs.img.owl.test.OWLTest;
import uk.ac.man.cs.img.owl.test.OWLTestParser;
import uk.ac.man.cs.img.owl.validation.OWLTestForWG;

public class SpeciesValidatorWGTest {
    public static void main(String[] args) {
        BasicConfigurator.configure();
        try {
            FileWriter rdfReport = new FileWriter(args[0]);
            FileWriter textReport = new FileWriter(args[1]);
            PrintWriter pw = new PrintWriter(rdfReport);
            pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            pw.println("<rdf:RDF ");
            pw.println("   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" ");
            pw.println("   xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" ");
            pw.println("   xmlns:results=\"http://www.w3.org/2002/03owlt/resultsOntology#\" ");
            pw.println("   xmlns=\"http://www.w3.org/1999/xhtml\" ");
            pw.println("   xml:base=\"http://wonderweb.man.ac.uk/owl/\">");
            pw.println("   <rdf:Description rdf:about=\"#wonderweb\">");
            pw.println("      <rdfs:label>WonderWeb</rdfs:label>");
            pw.println("      <rdfs:comment rdf:parseType=\"Literal\">");
            pw.println("      The WonderWeb <a href=\"http://wonderweb.man.ac.uk/owl\">OWL API</a> provides a high-level view on an OWL ontology based on the abstract syntax. Ontologies are parsed from XML-RDF, during which conditions for DL species are checked. The dats structure produced is then checked for expressivity to determine if it is DL/Lite.");
            pw.println("      </rdfs:comment>");
            pw.println("   </rdf:Description>");
            PrintWriter tpw = new PrintWriter(textReport);
            tpw.println("<html><pre>");
            OWLConnection connection = OWLManager.getOWLConnection();
            OWLDataFactory fact = connection.getDataFactory();
            Object testManifests = null;
            OWLTestParser parser = new OWLTestParser();
            URL testManifestsURL = ClassLoader.getSystemResource(System.getProperty("tests.manifests"));
            BufferedReader br = new BufferedReader(new InputStreamReader(testManifestsURL.openStream()));
            String f = null;
            while ((f = br.readLine()) != null) {
                if (f.startsWith("#")) continue;
                OWLTest test = parser.parseTest(new URI(f));
                OWLTestForWG otfwg = new OWLTestForWG(connection, test, rdfReport, textReport, args[2]);
                otfwg.runTest();
            }
            pw.println("</rdf:RDF>");
            tpw.println("</pre></html>");
            ((Writer)rdfReport).close();
            ((Writer)textReport).close();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

