/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.validation;

import java.net.URI;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.semanticweb.owl.impl.model.OWLOntologyImpl;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.change.AddSuperClass;
import org.semanticweb.owl.model.change.AddSuperProperty;
import org.semanticweb.owl.model.change.ChangeVisitor;
import org.semanticweb.owl.model.change.SetFunctional;
import org.semanticweb.owl.model.change.SetTransitive;
import org.semanticweb.owl.validation.SpeciesValidatorReporter;
import uk.ac.man.cs.img.owl.validation.SpeciesValidator;
import uk.ac.man.cs.img.owl.validation.ValidationTest;
import uk.ac.man.cs.img.owl.validation.ValidatorLogger;

public class TransitiveSideConditionsTest
extends ValidationTest {
    private OWLEntity[] entities;
    private SpeciesValidator sv;

    public TransitiveSideConditionsTest(String testName, OWLDataFactory factory) {
        super(testName, factory);
    }

    public static Test suite(OWLDataFactory fact) {
        TestSuite suite = new TestSuite("ClassAxiom");
        suite.addTest((Test)new TransitiveSideConditionsTest("testTransitive", fact));
        return suite;
    }

    public void testTransitive() throws Throwable {
        SpeciesValidator sv = new SpeciesValidator();
        sv.setReporter((SpeciesValidatorReporter)new ValidatorLogger());
        URI uri = new URI("http://example.org/test-trans");
        OWLOntology ontology = this.factory.getOWLOntology(uri, uri);
        TransitiveSideConditionsTest.assertTrue((boolean)sv.isOWLLite(ontology));
        OWLOntologyImpl changeVisitor = (OWLOntologyImpl)ontology;
        this.addEntities(ontology, (ChangeVisitor)changeVisitor);
        OWLObjectCardinalityRestriction desc = this.factory.getOWLObjectCardinalityAtMostRestriction(this.testObjectProperties[0], 1);
        AddSuperClass evt = new AddSuperClass(ontology, this.testClasses[0], (OWLDescription)desc, null);
        evt.accept((ChangeVisitor)changeVisitor);
        TransitiveSideConditionsTest.assertTrue((boolean)sv.isOWLLite(ontology));
        evt = new SetTransitive(ontology, this.testObjectProperties[0], true, null);
        evt.accept((ChangeVisitor)changeVisitor);
        TransitiveSideConditionsTest.assertTrue((String)"Transitive side conditions violated but still DL!", (!sv.isOWLDL(ontology) ? 1 : 0) != 0);
    }

    public void testTransitiveHard() throws Throwable {
        SpeciesValidator sv = new SpeciesValidator();
        sv.setReporter((SpeciesValidatorReporter)new ValidatorLogger());
        URI uri = new URI("http://example.org/test-trans-hard");
        OWLOntology ontology = this.factory.getOWLOntology(uri, uri);
        TransitiveSideConditionsTest.assertTrue((boolean)sv.isOWLLite(ontology));
        OWLOntologyImpl changeVisitor = (OWLOntologyImpl)ontology;
        this.addEntities(ontology, (ChangeVisitor)changeVisitor);
        SetFunctional evt = new SetFunctional(ontology, (OWLProperty)this.testObjectProperties[0], true, null);
        evt.accept((ChangeVisitor)changeVisitor);
        evt = new AddSuperProperty(ontology, (OWLProperty)this.testObjectProperties[1], (OWLProperty)this.testObjectProperties[0], null);
        evt.accept((ChangeVisitor)changeVisitor);
        TransitiveSideConditionsTest.assertTrue((boolean)sv.isOWLLite(ontology));
        evt = new SetTransitive(ontology, this.testObjectProperties[1], true, null);
        evt.accept((ChangeVisitor)changeVisitor);
        TransitiveSideConditionsTest.assertTrue((String)"Transitive side conditions violated but still DL!", (!sv.isOWLDL(ontology) ? 1 : 0) != 0);
    }
}

