/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.validation;

import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import uk.ac.man.cs.img.owl.test.OWLTest;
import uk.ac.man.cs.img.owl.test.OWLTestParser;

public class ValidateTests {
    public static void main(String[] args) {
        boolean manifests = false;
        boolean validate = false;
        if (args.length != 3) {
            System.err.println("Usage: validate-tests (-m|-v) base url");
            System.exit(1);
        }
        if (args[0].equals("-m")) {
            manifests = true;
        } else if (args[0].equals("-v")) {
            validate = true;
        }
        try {
            HashMap allDocs = new HashMap();
            String base = args[1];
            URI baseURI = new URI(base);
            URL url = new URL(args[2]);
            ZipInputStream zis = new ZipInputStream(url.openStream());
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                String name = ze.getName();
                if (!name.matches(".*Manifest.*rdf")) continue;
                if (manifests) {
                    System.out.println(base + "/" + name);
                }
                OWLTestParser otp = new OWLTestParser();
                URI manifestURI = new URI(base + "/" + name);
                OWLTest test = otp.parseTest(manifestURI);
                allDocs.putAll(test.getDocumentLevels());
            }
            if (validate) {
                System.out.println(allDocs.size() + " Files");
                System.out.println("========================");
                Iterator it = allDocs.keySet().iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    System.out.println(" " + key + ":" + allDocs.get(key));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

