/*
 * Decompiled with CFR 0.152.
 */
package pellet;

import com.clarkparsia.explanation.BlackBoxExplanation;
import com.clarkparsia.explanation.ExplanationGenerator;
import com.clarkparsia.explanation.GlassBoxExplanation;
import com.clarkparsia.explanation.HSTExplanationGenerator;
import com.clarkparsia.explanation.SatisfiabilityConverter;
import com.clarkparsia.explanation.TransactionAwareSingleExpGen;
import com.clarkparsia.explanation.io.ExplanationRenderer;
import com.clarkparsia.explanation.io.manchester.ManchesterSyntaxExplanationRenderer;
import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.owlapi.OntologyUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.owlapi.OWLAPILoader;
import org.mindswap.pellet.owlapi.PelletReasonerFactory;
import org.mindswap.pellet.owlapi.Reasoner;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;
import org.mindswap.pellet.utils.progress.ConsoleProgressMonitor;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.semanticweb.owl.inference.OWLClassReasoner;
import org.semanticweb.owl.inference.OWLReasonerFactory;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import pellet.PelletCmdApp;
import pellet.PelletCmdException;
import pellet.PelletCmdOption;
import pellet.PelletCmdOptionArg;
import pellet.PelletCmdOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PelletExplain
extends PelletCmdApp {
    private SatisfiabilityConverter converter;
    private int errorExpCount = 0;
    private ExplanationGenerator expGen;
    private OWLDataFactory factory;
    private DateFormat formatter = new SimpleDateFormat("mm:ss");
    private OWLAPILoader loader;
    private OWLOntologyManager manager;
    private int maxExplanations = 1;
    private ProgressMonitor monitor;
    private int multiAxiomExpCount = 0;
    private int multipleExpCount = 0;
    private OWLOntology ontology;
    private Reasoner reasoner;
    private ExplanationRenderer renderer = new ManchesterSyntaxExplanationRenderer();
    private TransactionAwareSingleExpGen singleExpGen;
    private OWLEntity name1;
    private OWLEntity name2;
    private Writer writer = new PrintWriter(System.out);
    private Timers timers = new Timers();
    private static final Logger log = Logger.getLogger(PelletExplain.class.getName());

    public PelletExplain(String[] args) {
        super(args);
        GlassBoxExplanation.setup();
        this.loader = (OWLAPILoader)this.getLoader("OWLAPI");
        this.manager = this.loader.getManager();
        this.factory = this.manager.getOWLDataFactory();
        this.reasoner = this.loader.getReasoner();
        this.converter = new SatisfiabilityConverter(this.factory);
        this.loadOntology();
        this.loadReasoner();
        this.loadNames();
        this.loadMethod();
        this.loadOutput();
        this.loadMax();
        this.loadVerbose();
    }

    public static void main(String[] args) throws Exception {
        PelletExplain app = new PelletExplain(args);
        app.run();
    }

    @Override
    public String getAppId() {
        return "PelletExplain: Explains one or more inferences in a given ontology";
    }

    @Override
    public String getAppCmd() {
        return "pellet explain " + this.getMandatoryOptions() + "[options] <file URI>...\n\n" + "C, D, and i can be URIs or local names\n" + "The options --unsat, --all-unsat, --inconsistent,\n" + "--subclass, --hierarchy, and --instance are mutually exclusive";
    }

    @Override
    public PelletCmdOptions getOptions() {
        PelletCmdOptions options = new PelletCmdOptions();
        PelletCmdOption option = new PelletCmdOption("unsat");
        option.setType("C");
        option.setDescription("Explain why the given class is unsatisfiable");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("all-unsat");
        option.setDescription("Explain all unsatisfiable classes");
        option.setDefaultValue(false);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.NONE);
        options.add(option);
        option = new PelletCmdOption("inconsistent");
        option.setDescription("Explain why the ontology is inconsistent");
        option.setDefaultValue(false);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.NONE);
        options.add(option);
        option = new PelletCmdOption("hierarchy");
        option.setDescription("Print all explanations for the class hierarchy");
        option.setDefaultValue(false);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.NONE);
        options.add(option);
        option = new PelletCmdOption("subclass");
        option.setDescription("Explain why C is a subclass of D");
        option.setType("C,D");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("instance");
        option.setDescription("Explain why i is an instance of C");
        option.setType("i,C");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("method");
        option.setShortOption("m");
        option.setType("glass | black");
        option.setDescription("Method that will be used to generate explanations");
        option.setDefaultValue("glass");
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("max");
        option.setShortOption("x");
        option.setType("positive integer");
        option.setDescription("Maximum number of generated explanations for each inference");
        option.setDefaultValue(1);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.REQUIRED);
        options.add(option);
        option = new PelletCmdOption("verbose");
        option.setShortOption("v");
        option.setDescription("Print detailed messages about the progress");
        option.setDefaultValue(false);
        option.setIsMandatory(false);
        option.setArg(PelletCmdOptionArg.NONE);
        options.add(option);
        return options;
    }

    @Override
    public void run() {
        HSTExplanationGenerator hst = new HSTExplanationGenerator(this.singleExpGen);
        hst.setReasonerFactory((OWLReasonerFactory)new PelletReasonerFactory());
        hst.setReasoner((OWLClassReasoner)this.reasoner);
        hst.setOntology(this.ontology);
        this.expGen = hst;
        try {
            this.renderer.startRendering(this.writer);
            if (this.name1 == null) {
                log.fine("Explain all the subclass relations in the ontology");
                this.explainClassHierarchy();
            } else if (this.name2 == null) {
                if (((OWLDescription)this.name1).isOWLNothing()) {
                    log.fine("Explain all the unsatisfiable classes");
                    this.explainUnsatisfiableClasses();
                } else {
                    log.fine("Explain unsatisfiability of " + this.name1);
                    this.explainUnsatisfiableClass((OWLClass)this.name1);
                }
            } else if (this.name1.isOWLClass() && this.name2.isOWLClass()) {
                log.fine("Explain subclass relation between " + this.name1 + " and " + this.name2);
                this.explainSubClass((OWLClass)this.name1, (OWLClass)this.name2);
            } else if (this.name1.isOWLIndividual() && this.name2.isOWLClass()) {
                log.fine("Explain instance relation between " + this.name1 + " and " + this.name2);
                this.explainInstance((OWLIndividual)this.name1, (OWLClass)this.name2);
            }
            this.renderer.endRendering();
            log.fine("Used options         : " + Arrays.toString(this.args));
            this.printStatistics();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (OWLException e) {
            throw new RuntimeException(e);
        }
    }

    private void explainAxiom(OWLAxiom axiom) throws OWLException {
        int expSize;
        Timer timer = this.timers.startTimer("explain");
        OWLDescription unsatClass = this.converter.convert(axiom);
        Set explanations = this.expGen.getExplanations(unsatClass, this.maxExplanations);
        timer.stop();
        if (timer.getCount() % 10L == 0L) {
            // empty if block
        }
        if ((expSize = explanations.size()) == 0) {
            ++this.errorExpCount;
        } else if (expSize == 1) {
            if (((Set)explanations.iterator().next()).size() > 1) {
                ++this.multiAxiomExpCount;
            }
        } else {
            ++this.multipleExpCount;
        }
        try {
            this.renderer.render(axiom, explanations);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Error rendering explanation", e);
        }
    }

    public void explainClassHierarchy() throws OWLException {
        HashSet<OWLClass> visited = new HashSet<OWLClass>();
        log.fine("Classification started");
        Timer timer = this.timers.startTimer("classification");
        this.reasoner.classify();
        timer.stop();
        log.fine("Classification finished in: " + this.formatter.format(timer.getLast()));
        log.fine("Realization started");
        timer = this.timers.startTimer("realize");
        this.reasoner.realise();
        timer.stop();
        log.fine("Realization finished in: " + this.formatter.format(timer.getLast()));
        this.monitor = new ConsoleProgressMonitor();
        this.monitor.setProgressTitle("Explaining");
        this.monitor.setProgressLength(this.reasoner.getClasses().size());
        this.monitor.taskStarted();
        Set bottoms = this.reasoner.getEquivalentClasses((OWLDescription)OWL.Nothing);
        this.explainClassHierarchy(OWL.Nothing, bottoms, visited);
        Set tops = this.reasoner.getEquivalentClasses((OWLDescription)OWL.Thing);
        this.explainClassHierarchy(OWL.Thing, tops, visited);
        this.monitor.taskFinished();
    }

    public void explainEquivalentClass(OWLClass c1, OWLClass c2) throws OWLException {
        if (c1.equals(c2)) {
            return;
        }
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((OWLDescription)c1, (OWLDescription)c2);
        this.explainAxiom((OWLAxiom)axiom);
    }

    public void explainInstance(OWLIndividual ind, OWLClass c) throws OWLException {
        if (c.isOWLThing()) {
            return;
        }
        OWLClassAssertionAxiom axiom = OWL.classAssertion((OWLIndividual)ind, (OWLDescription)c);
        this.explainAxiom((OWLAxiom)axiom);
    }

    public void explainSubClass(OWLClass sub, OWLClass sup) throws OWLException {
        if (sub.equals(sup)) {
            return;
        }
        if (sub.isOWLNothing()) {
            return;
        }
        if (sup.isOWLThing()) {
            return;
        }
        OWLSubClassAxiom axiom = OWL.subClassOf((OWLDescription)sub, (OWLDescription)sup);
        this.explainAxiom((OWLAxiom)axiom);
    }

    public void explainUnsatisfiableClasses() throws OWLException {
        for (OWLClass cls : this.reasoner.getClasses()) {
            if (cls.isOWLNothing() || this.reasoner.isSatisfiable((OWLDescription)cls)) continue;
            this.explainUnsatisfiableClass(cls);
        }
    }

    public void explainUnsatisfiableClass(OWLClass cls) throws OWLException {
        this.explainSubClass(cls, OWL.Nothing);
    }

    private void explainClassHierarchy(OWLClass cls, Set<OWLClass> eqClasses, Set<OWLClass> visited) throws OWLException {
        if (visited.contains(cls)) {
            return;
        }
        visited.add(cls);
        visited.addAll(eqClasses);
        for (OWLClass eqClass : eqClasses) {
            this.monitor.incrementProgress();
            this.explainEquivalentClass(cls, eqClass);
        }
        for (OWLIndividual ind : this.reasoner.getIndividuals((OWLDescription)cls, true)) {
            this.explainInstance(ind, cls);
        }
        Set subClasses = this.reasoner.getSubClasses((OWLDescription)cls);
        HashMap<OWLClass, Set> subClassEqs = new HashMap<OWLClass, Set>();
        for (Set set : subClasses) {
            if (set.contains(OWL.Nothing)) continue;
            OWLClass subClass = (OWLClass)set.iterator().next();
            subClassEqs.put(subClass, set);
            this.explainSubClass(subClass, cls);
        }
        for (Map.Entry entry : subClassEqs.entrySet()) {
            this.explainClassHierarchy((OWLClass)entry.getKey(), (Set)entry.getValue(), visited);
        }
    }

    private void loadMethod() {
        String method = this.options.getOption("method").getValueAsString();
        if (method.equalsIgnoreCase("black")) {
            this.singleExpGen = new BlackBoxExplanation(this.manager);
        } else if (method.equalsIgnoreCase("glass")) {
            this.singleExpGen = new GlassBoxExplanation(this.manager);
        } else {
            throw new PelletCmdException("Unrecognized method: " + method);
        }
    }

    private void loadOutput() {
        this.renderer = new ManchesterSyntaxExplanationRenderer();
        this.writer = new OutputStreamWriter(System.out);
    }

    private void loadMax() {
        this.maxExplanations = this.options.getOption("max").getValueAsInteger();
    }

    private void loadVerbose() {
        if (this.options.getOption("verbose").getValueAsBoolean().booleanValue()) {
            log.setLevel(Level.FINE);
        } else {
            log.setLevel(Level.OFF);
        }
    }

    private void loadOntology() {
        this.getKB();
        try {
            Set ontologies = this.loader.getOntologies();
            if (ontologies.size() == 1) {
                this.ontology = (OWLOntology)ontologies.iterator().next();
            } else {
                this.ontology = this.manager.createOntology(Collections.emptySet());
                HashSet<OWLImportsDeclaration> importDeclarations = new HashSet<OWLImportsDeclaration>();
                for (OWLOntology ont : ontologies) {
                    importDeclarations.add(this.factory.getOWLImportsDeclarationAxiom(this.ontology, ont.getURI()));
                }
                this.manager.addAxioms(this.ontology, importDeclarations);
            }
        }
        catch (OWLException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadReasoner() {
        log.fine("Loading the ontology to the reasoner");
        Timer timer = this.timers.startTimer("loadToReasoner");
        this.loader.load();
        timer.stop();
        this.reasoner = this.loader.getReasoner();
        log.fine(timer.toString());
    }

    private void loadNames() {
        String instance;
        String subclass;
        String unsatisfiable;
        PelletCmdOption option = this.options.getOption("hierarchy");
        if (option != null && option.getValueAsBoolean().booleanValue()) {
            this.name1 = null;
            this.name2 = null;
            return;
        }
        option = this.options.getOption("all-unsat");
        if (option != null && option.getValueAsBoolean().booleanValue()) {
            this.name1 = OWL.Nothing;
            return;
        }
        option = this.options.getOption("inconsistent");
        if (option != null && option.getValueAsBoolean().booleanValue()) {
            this.name1 = OWL.Thing;
            return;
        }
        option = this.options.getOption("unsat");
        if (option != null && (unsatisfiable = option.getValueAsString()) != null) {
            this.name1 = OntologyUtils.findEntity((String)unsatisfiable, (Set)this.loader.getOntologies());
            if (this.name1 == null) {
                throw new PelletCmdException("Undefined entity: " + unsatisfiable);
            }
            return;
        }
        option = this.options.getOption("subclass");
        if (option != null && (subclass = option.getValueAsString()) != null) {
            String[] names = subclass.split(",");
            if (names.length != 2) {
                throw new PelletCmdException("Invalid format for subclass option: " + subclass);
            }
            this.name1 = OntologyUtils.findEntity((String)names[0], (Set)this.loader.getOntologies());
            this.name2 = OntologyUtils.findEntity((String)names[1], (Set)this.loader.getOntologies());
            if (this.name1 == null) {
                throw new PelletCmdException("Undefined entity: " + names[0]);
            }
            if (this.name2 == null) {
                throw new PelletCmdException("Undefined entity: " + names[1]);
            }
            return;
        }
        option = this.options.getOption("instance");
        if (option != null && (instance = option.getValueAsString()) != null) {
            String[] names = instance.split(",");
            if (names.length != 2) {
                throw new PelletCmdException("Invalid format for instance option: " + instance);
            }
            this.name1 = OntologyUtils.findEntity((String)names[0], (Set)this.loader.getOntologies());
            this.name2 = OntologyUtils.findEntity((String)names[1], (Set)this.loader.getOntologies());
            if (this.name1 == null) {
                throw new PelletCmdException("Undefined entity: " + names[0]);
            }
            if (this.name2 == null) {
                throw new PelletCmdException("Undefined entity: " + names[1]);
            }
            return;
        }
        this.name1 = OWL.Thing;
    }

    private void printStatistics() throws OWLException {
        if (!log.isLoggable(Level.FINE)) {
            return;
        }
        Timer timer = this.timers.getTimer("explain");
        if (timer != null) {
            log.fine("Subclass relations   : " + timer.getCount());
            log.fine("Multiple explanations: " + this.multipleExpCount);
            log.fine("Single explanation     ");
            log.fine(" with multiple axioms: " + this.multiAxiomExpCount);
            log.fine("Error explaining     : " + this.errorExpCount);
            log.fine("Total time spent     : " + this.formatter.format(timer.getTotal()));
            log.fine("Average time         : " + timer.getAverage() + "ms");
        }
        log.finer(this.timers.toString());
    }
}

