/*
 * Decompiled with CFR 0.152.
 */
package org.sercho.masp.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectiveTestCase<T>
extends TestCase {
    protected final T testObject;
    private final Class<?> testInterface;
    private final Set<Class<? extends RuntimeException>> allowedExceptions = new HashSet<Class<? extends RuntimeException>>();
    private final boolean constructorsTest;

    private static <T> List<T> asList(T[] array) {
        return array == null ? Collections.emptyList() : Arrays.asList(array);
    }

    protected ReflectiveTestCase(T object) {
        this(object, null, IllegalArgumentException.class, true);
    }

    protected ReflectiveTestCase(T object, boolean testConstructors) {
        this(object, null, IllegalArgumentException.class, testConstructors);
    }

    protected ReflectiveTestCase(T object, Class<? super T> testClass) {
        this((T)object, testClass, (Class<RuntimeException>)IllegalArgumentException.class, true);
    }

    protected ReflectiveTestCase(T object, Class<? super T> testClass, boolean testConstructors) {
        this((T)object, testClass, (Class<RuntimeException>)IllegalArgumentException.class, testConstructors);
    }

    protected ReflectiveTestCase(T object, Class<? super T> testClass, Class<? extends RuntimeException> ... allowedUncheckedExceptions) {
        this((T)object, testClass, (Collection<Class<RuntimeException>>)ReflectiveTestCase.asList(allowedUncheckedExceptions), true);
    }

    protected ReflectiveTestCase(T object, Class<? super T> testClass, Class<? extends RuntimeException> allowedUncheckedException, boolean testConstructors) {
        this((T)object, testClass, (Collection<Class<RuntimeException>>)Collections.singleton(allowedUncheckedException), testConstructors);
    }

    protected ReflectiveTestCase(T object, Class<? super T> testClass, Collection<Class<? extends RuntimeException>> allowedUncheckedExceptions, boolean testConstructors) {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        this.constructorsTest = testConstructors;
        if (allowedUncheckedExceptions != null) {
            this.allowedExceptions.addAll(allowedUncheckedExceptions);
        }
        this.testInterface = testClass == null ? object.getClass() : testClass;
        this.testObject = object;
    }

    private boolean isAllowed(Throwable t) {
        for (Class<? extends RuntimeException> c : this.allowedExceptions) {
            if (!c.isInstance(t)) continue;
            return true;
        }
        return false;
    }

    public final void testNullParametersInMethods() {
        for (Method method : this.testInterface.getDeclaredMethods()) {
            this.testNullParametersInMethod(method);
        }
    }

    public final void testNullParametersInConstructors() {
        if (this.constructorsTest) {
            for (Constructor<?> constructor : this.testObject.getClass().getConstructors()) {
                this.testNullParametersInConstructor(constructor);
            }
        }
    }

    private void testNullParametersInMethod(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return;
        }
        try {
            method.invoke(this.testObject, new Object[method.getParameterTypes().length]);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (IllegalAccessException e) {
            return;
        }
        catch (InvocationTargetException e) {
            Class<?>[] exceptionTypes;
            Throwable t = e.getTargetException();
            if (this.isAllowed(t)) {
                return;
            }
            for (Class<?> exceptionClass : exceptionTypes = method.getExceptionTypes()) {
                if (!exceptionClass.isInstance(t)) continue;
                return;
            }
            ReflectiveTestCase.fail((String)(this.testObject.getClass().getName() + "." + method.getName() + " thrown undeclared " + t.getClass().getName() + " when called with null parameters."));
        }
    }

    private void testNullParametersInConstructor(Constructor<T> constructor) {
        try {
            constructor.newInstance(new Object[constructor.getParameterTypes().length]);
        }
        catch (IllegalArgumentException e1) {
            return;
        }
        catch (InstantiationException e1) {
            return;
        }
        catch (IllegalAccessException e1) {
            return;
        }
        catch (InvocationTargetException e) {
            Class<?>[] exceptionTypes;
            Throwable t = e.getTargetException();
            if (this.isAllowed(t)) {
                return;
            }
            for (Class<?> exceptionClass : exceptionTypes = constructor.getExceptionTypes()) {
                if (!exceptionClass.isInstance(t)) continue;
                return;
            }
            ReflectiveTestCase.fail((String)(this.testObject.getClass().getName() + "'s constructor '" + constructor.toGenericString() + "' thrown undeclared " + t.getClass().getName() + " when called with null parameters."));
        }
    }

    protected final void testValidParameters(String methodName, Object[] parameters, Object expectedResult) {
        this.testValidParameters(this.getMethodByName(methodName), parameters, expectedResult);
    }

    protected final void testValidParameters(Method method, Object[] parameters, Object expectedResult) {
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        if (!method.getDeclaringClass().equals(this.testInterface)) {
            throw new IllegalArgumentException("method is not declared in the interface under test");
        }
        try {
            this.assertEqualResults(expectedResult, method.invoke(this.testObject, parameters));
        }
        catch (IllegalArgumentException e) {
            ReflectiveTestCase.fail((String)(method.getName() + " thrown " + e.getClass().getName() + " for valid parameters, message: " + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            ReflectiveTestCase.fail((String)(method.getName() + " thrown " + e.getClass().getName() + " for valid parameters, message: " + e.getMessage()));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            ReflectiveTestCase.fail((String)(method.getName() + " thrown " + t.getClass().getName() + " for valid parameters, message: " + t.getMessage()));
        }
    }

    protected void assertEqualResults(Object expectedResult, Object createdResult) {
    }

    protected final Method getMethodByName(String name) {
        if (name == null) {
            return null;
        }
        for (Method method : this.testInterface.getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }
}

