/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation.test;

import com.clarkparsia.explanation.test.JenaExplanationTest;
import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.owlapi.SWRL;
import com.clarkparsia.owlapi.XSD;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mindswap.pellet.utils.SetUtils;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.SWRLAtom;
import org.semanticweb.owl.model.SWRLAtomDObject;
import org.semanticweb.owl.model.SWRLAtomDVariable;
import org.semanticweb.owl.model.SWRLAtomIObject;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.vocab.SWRLBuiltInsVocabulary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExplanationTest {
    static final String BASEPATH = "file:data/";
    static final OWLOntologyManager manager = OWL.manager;
    static final URI ontologyURI = URI.create("http://www.example.org/test#");
    protected boolean classify;
    private OWLClass A;
    private OWLClass B;
    private OWLClass C;
    private OWLClass D;
    private OWLClass E;
    private OWLClass F;
    private OWLObjectProperty p;
    private OWLObjectProperty q;
    private OWLObjectProperty r;
    private OWLDataProperty dp;
    private OWLDataProperty dq;
    private OWLDataProperty dr;
    private OWLIndividual a;
    private OWLIndividual b;
    private OWLIndividual c;
    private OWLIndividual anon1;
    private SWRLAtomIVariable x;
    private SWRLAtomIVariable y;
    private SWRLAtomDVariable dx;

    public AbstractExplanationTest(boolean classify) {
        this.classify = classify;
    }

    @Before
    public void createEntities() {
        this.A = OWL.Class((String)(ontologyURI + "A"));
        this.B = OWL.Class((String)(ontologyURI + "B"));
        this.C = OWL.Class((String)(ontologyURI + "C"));
        this.D = OWL.Class((String)(ontologyURI + "D"));
        this.E = OWL.Class((String)(ontologyURI + "E"));
        this.F = OWL.Class((String)(ontologyURI + "F"));
        this.p = OWL.ObjectProperty((String)(ontologyURI + "p"));
        this.q = OWL.ObjectProperty((String)(ontologyURI + "q"));
        this.r = OWL.ObjectProperty((String)(ontologyURI + "r"));
        this.dp = OWL.DataProperty((String)(ontologyURI + "dp"));
        this.dq = OWL.DataProperty((String)(ontologyURI + "dq"));
        this.dr = OWL.DataProperty((String)(ontologyURI + "dr"));
        this.a = OWL.Individual((String)(ontologyURI + "a"));
        this.b = OWL.Individual((String)(ontologyURI + "b"));
        this.c = OWL.Individual((String)(ontologyURI + "c"));
        this.anon1 = OWL.AnonymousIndividual((String)"anon1");
        this.x = SWRL.iVariable((String)(ontologyURI + "x"));
        this.y = SWRL.iVariable((String)(ontologyURI + "y"));
        this.dx = SWRL.dVariable((String)(ontologyURI + "dx"));
    }

    public void testExplanations(OWLAxiom axiom, int max, OWLAxiom ... explanations) throws Exception {
        this.testExplanations(axiom, max, new OWLAxiom[][]{explanations});
    }

    public void testExplanations(OWLAxiom axiom, int max, OWLAxiom[] ... explanations) throws Exception {
        HashSet<Set<OWLAxiom>> explanationSet = new HashSet<Set<OWLAxiom>>();
        for (Object[] objectArray : explanations) {
            explanationSet.add(SetUtils.create((Object[])objectArray));
        }
        this.testExplanations(axiom, max, explanationSet);
    }

    public abstract void testExplanations(OWLAxiom var1, int var2, Set<Set<OWLAxiom>> var3) throws Exception;

    public abstract void setupGenerators(Collection<OWLAxiom> var1) throws Exception;

    @After
    public void after() throws OWLOntologyCreationException {
        manager.removeOntology(ontologyURI);
    }

    @Test
    public void annotationOnlyEntity() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.equivalentClasses((OWLDescription)this.A, (OWLDescription)OWL.Thing), OWL.comment((OWLEntity)this.B, (String)"Annotation only class")};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.A), 0, axioms[0]);
    }

    @Test
    public void annotationOnlyDuringMUPSEntity() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.Thing), OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.A), OWL.comment((OWLEntity)this.B, (String)"Annotation only class")};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.A), 0, axioms[1]);
    }

    @Test
    public void anonymousIndividualPropertyAssertion() throws Exception {
        Assume.assumeTrue((!(this instanceof JenaExplanationTest) ? 1 : 0) != 0);
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.anon1), OWL.classAssertion((OWLIndividual)this.anon1, (OWLDescription)this.A), OWL.subClassOf((OWLDescription)OWL.some((OWLObjectPropertyExpression)this.p, (OWLDescription)this.A), (OWLDescription)this.B)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.B), 0, axioms);
    }

    @Test
    public void declarationOnlyEntity() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.equivalentClasses((OWLDescription)this.A, (OWLDescription)OWL.Thing), OWL.declaration((OWLEntity)this.B)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.A), 0, axioms[0]);
    }

    @Test
    public void declarationOnlyIrrelevantEntity() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.A), OWL.declaration((OWLEntity)this.p)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.subClassOf((OWLDescription)OWL.and((OWLDescription[])new OWLDescription[]{this.B, OWL.some((OWLObjectPropertyExpression)this.p, (OWLDescription)OWL.Thing)}), (OWLDescription)this.A), 0, axioms[0]);
    }

    @Test
    public void disjointRange() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.some((OWLObjectPropertyExpression)this.p, (OWLDescription)this.B)), OWL.range((OWLObjectPropertyExpression)this.p, (OWLDescription)this.C), OWL.disjointClasses((OWLDescription)this.B, (OWLDescription)this.C)};
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((OWLDescription)this.A, (OWLDescription)OWL.Nothing);
        OWLAxiom[] explanation = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.some((OWLObjectPropertyExpression)this.p, (OWLDescription)this.B)), OWL.range((OWLObjectPropertyExpression)this.p, (OWLDescription)this.C), OWL.disjointClasses((OWLDescription)this.B, (OWLDescription)this.C)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)axiom, 0, explanation);
    }

    @Test
    public void disjointRangeSuper() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.some((OWLObjectPropertyExpression)this.p, (OWLDescription)this.B)), OWL.range((OWLObjectPropertyExpression)this.p, (OWLDescription)this.C), OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.D), OWL.disjointClasses((OWLDescription)this.D, (OWLDescription)this.C), OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.E), OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.F)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.disjointClasses((OWLDescription)this.B, (OWLDescription)this.C), 0, axioms[2], axioms[3]);
        this.testExplanations((OWLAxiom)OWL.equivalentClasses((OWLDescription)this.A, (OWLDescription)OWL.Nothing), 0, axioms[0], axioms[1], axioms[2], axioms[3]);
    }

    @Test
    public void disjointSupers() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.C), OWL.disjointClasses((OWLDescription)this.B, (OWLDescription)this.C)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.equivalentClasses((OWLDescription)this.A, (OWLDescription)OWL.Nothing), 0, axioms);
    }

    @Test
    public void koalaHardWorkingDomain() throws Exception {
        String ns = "http://protege.stanford.edu/plugins/owl/owl-library/koala.owl#";
        OWLOntology ontology = manager.loadOntologyFromPhysicalURI(URI.create("file:test/data/modularity/koala.owl"));
        OWLClass animal = OWL.Class((String)(ns + "Animal"));
        OWLClass person = OWL.Class((String)(ns + "Person"));
        OWLDataProperty hardWorking = OWL.DataProperty((String)(ns + "isHardWorking"));
        this.setupGenerators(ontology.getAxioms());
        this.testExplanations((OWLAxiom)OWL.domain((OWLDataPropertyExpression)hardWorking, (OWLDescription)animal), 0, new OWLAxiom[]{OWL.subClassOf((OWLDescription)person, (OWLDescription)animal), OWL.domain((OWLDataPropertyExpression)hardWorking, (OWLDescription)person)});
    }

    @Test
    public void multipleEquivalentClasses() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.equivalentClasses((OWLDescription)this.A, (OWLDescription)this.C), OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.D), OWL.subClassOf((OWLDescription)this.D, (OWLDescription)this.E), OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.E), OWL.equivalentClasses((OWLDescription)this.A, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.all((OWLObjectPropertyExpression)this.p, (OWLDescription)this.A))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.subClassOf((OWLDescription)this.C, (OWLDescription)this.D), 0, axioms[0], axioms[1]);
        this.testExplanations((OWLAxiom)OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.D), 0, axioms[1]);
        this.testExplanations((OWLAxiom)OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.D), 0, axioms[1], axioms[4]);
    }

    @Test
    public void ruleTest1() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), OWL.classAssertion((OWLIndividual)this.b, (OWLDescription)this.B), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.A, (SWRLAtomIObject)this.x)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.B, (SWRLAtomIObject)this.x)})), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.B, (SWRLAtomIObject)this.x), SWRL.propertyAtom((OWLObjectPropertyExpression)this.p, (SWRLAtomIObject)this.x, (SWRLAtomIObject)this.y), SWRL.classAtom((OWLDescription)this.B, (SWRLAtomIObject)this.y)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.C, (SWRLAtomIObject)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), 0, axioms[0]);
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.B), 0, axioms[0], axioms[3]);
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.C), 1, axioms);
    }

    @Test
    public void ruleTest1b() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), OWL.classAssertion((OWLIndividual)this.b, (OWLDescription)this.B), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), SWRL.rule((String)(ontologyURI + "rule1"), (boolean)true, (Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.A, (SWRLAtomIObject)this.x)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.B, (SWRLAtomIObject)this.x)})), SWRL.rule((String)(ontologyURI + "rule2"), (Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.B, (SWRLAtomIObject)this.x), SWRL.propertyAtom((OWLObjectPropertyExpression)this.p, (SWRLAtomIObject)this.x, (SWRLAtomIObject)this.y), SWRL.classAtom((OWLDescription)this.B, (SWRLAtomIObject)this.y)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.C, (SWRLAtomIObject)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), 0, axioms[0]);
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.B), 0, axioms[0], axioms[3]);
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.C), 1, axioms);
    }

    @Test
    public void ruleTest2() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subPropertyOf((OWLObjectPropertyExpression)this.q, (OWLObjectPropertyExpression)this.p), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.q, (OWLIndividual)this.b), OWL.classAssertion((OWLIndividual)this.b, (OWLDescription)this.B), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.propertyAtom((OWLObjectPropertyExpression)this.p, (SWRLAtomIObject)this.x, (SWRLAtomIObject)this.y), SWRL.classAtom((OWLDescription)this.B, (SWRLAtomIObject)this.y)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.A, (SWRLAtomIObject)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), 1, axioms);
    }

    @Test
    public void ruleTest3() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.inverseProperties((OWLObjectPropertyExpression)this.q, (OWLObjectPropertyExpression)this.p), OWL.propertyAssertion((OWLIndividual)this.b, (OWLObjectPropertyExpression)this.q, (OWLIndividual)this.a), OWL.classAssertion((OWLIndividual)this.b, (OWLDescription)this.B), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.propertyAtom((OWLObjectPropertyExpression)this.p, (SWRLAtomIObject)this.x, (SWRLAtomIObject)this.y), SWRL.classAtom((OWLDescription)this.B, (SWRLAtomIObject)this.y)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.A, (SWRLAtomIObject)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), 1, axioms);
    }

    @Test
    public void ruleTest4() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.A, (SWRLAtomIObject)this.x)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.B, (SWRLAtomIObject)this.x), SWRL.classAtom((OWLDescription)this.C, (SWRLAtomIObject)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.B), 1, axioms);
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.C), 1, axioms);
    }

    @Test
    public void ruleTest5() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.propertyAtom((OWLObjectPropertyExpression)this.p, (SWRLAtomIObject)this.x, (SWRLAtomIObject)this.y)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.A, (SWRLAtomIObject)this.x), SWRL.classAtom((OWLDescription)this.B, (SWRLAtomIObject)this.y)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), 1, axioms);
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.b, (OWLDescription)this.B), 1, axioms);
    }

    @Test
    public void ruleTest6() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), OWL.classAssertion((OWLIndividual)this.b, (OWLDescription)this.B), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)OWL.some((OWLObjectPropertyExpression)this.p, (OWLDescription)this.B), (SWRLAtomIObject)this.x)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.C, (SWRLAtomIObject)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.C), 1, axioms);
    }

    @Test
    public void ruleBuiltinTest1() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dp, (OWLConstant)OWL.constant((int)9)), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.A, (SWRLAtomIObject)this.x), SWRL.propertyAtom((OWLDataPropertyExpression)this.dp, (SWRLAtomIObject)this.x, (SWRLAtomDObject)this.dx), SWRL.lessThan((SWRLAtomDObject)this.dx, (SWRLAtomDObject)SWRL.constant((int)10))}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.B, (SWRLAtomIObject)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.B), 0, axioms);
    }

    @Test
    public void ruleBuiltinTest2() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dp, (OWLConstant)OWL.constant((int)9)), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.A, (SWRLAtomIObject)this.x), SWRL.propertyAtom((OWLDataPropertyExpression)this.dp, (SWRLAtomIObject)this.x, (SWRLAtomDObject)this.dx), SWRL.greaterThan((SWRLAtomDObject)this.dx, (SWRLAtomDObject)SWRL.constant((int)5)), SWRL.lessThan((SWRLAtomDObject)this.dx, (SWRLAtomDObject)SWRL.constant((int)10))}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLDescription)this.B, (SWRLAtomIObject)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.B), 0, axioms);
    }

    @Test
    public void ruleBuiltinTest3() throws Exception {
        SWRLAtomDVariable y = SWRL.dVariable((String)(ontologyURI + "year"));
        SWRLAtomDVariable m = SWRL.dVariable((String)(ontologyURI + "month"));
        SWRLAtomDVariable d = SWRL.dVariable((String)(ontologyURI + "day"));
        OWLDataProperty year = OWL.DataProperty((String)(ontologyURI + "year"));
        OWLDataProperty month = OWL.DataProperty((String)(ontologyURI + "month"));
        OWLDataProperty day = OWL.DataProperty((String)(ontologyURI + "day"));
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dp, (OWLConstant)OWL.constant((String)"2009-01-02", (OWLDataType)XSD.DATE)), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.propertyAtom((OWLDataPropertyExpression)this.dp, (SWRLAtomIObject)this.x, (SWRLAtomDObject)this.dx), SWRL.builtIn((SWRLBuiltInsVocabulary)SWRLBuiltInsVocabulary.DATE, (SWRLAtomDObject[])new SWRLAtomDObject[]{this.dx, y, m, d})}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.propertyAtom((OWLDataPropertyExpression)year, (SWRLAtomIObject)this.x, (SWRLAtomDObject)y), SWRL.propertyAtom((OWLDataPropertyExpression)month, (SWRLAtomIObject)this.x, (SWRLAtomDObject)m), SWRL.propertyAtom((OWLDataPropertyExpression)day, (SWRLAtomIObject)this.x, (SWRLAtomDObject)d)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)year, (OWLConstant)OWL.constant((int)2009)), 1, axioms[0], axioms[1]);
    }

    @Test
    public void userDefinedDatatype1() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dp, (OWLConstant)OWL.constant((int)9)), OWL.equivalentClasses((OWLDescription)this.B, (OWLDescription)OWL.and((OWLDescription[])new OWLDescription[]{this.A, OWL.some((OWLDataPropertyExpression)this.dp, (OWLDataRange)OWL.restrict((OWLDataType)XSD.INTEGER, (OWLDataRangeFacetRestriction[])new OWLDataRangeFacetRestriction[]{OWL.maxExclusive((int)10)}))}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.B), 0, axioms);
    }

    @Test
    public void userDefinedDatatype2() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.and((OWLDescription[])new OWLDescription[]{OWL.max((OWLDataPropertyExpression)this.dp, (int)1), OWL.some((OWLDataPropertyExpression)this.dp, (OWLDataRange)OWL.restrict((OWLDataType)XSD.INTEGER, (OWLDataRangeFacetRestriction[])new OWLDataRangeFacetRestriction[]{OWL.minExclusive((int)10)}))})), OWL.equivalentClasses((OWLDescription)this.B, (OWLDescription)OWL.and((OWLDescription[])new OWLDescription[]{OWL.min((OWLDataPropertyExpression)this.dp, (int)1), OWL.all((OWLDataPropertyExpression)this.dp, (OWLDataRange)OWL.restrict((OWLDataType)XSD.INTEGER, (OWLDataRangeFacetRestriction[])new OWLDataRangeFacetRestriction[]{OWL.minExclusive((int)5)}))}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.B), 0, axioms);
    }

    @Test
    public void transitiveProperty() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.transitive((OWLObjectPropertyExpression)this.p), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), OWL.propertyAssertion((OWLIndividual)this.b, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.c), OWL.equivalentClasses((OWLDescription)this.A, (OWLDescription)OWL.value((OWLObjectPropertyExpression)this.p, (OWLIndividual)this.c))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.b, (OWLDescription)this.A), 0, axioms[2], axioms[3]);
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), 0, axioms);
    }

    @Test
    public void propertyChain1() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subPropertyOf((OWLObjectPropertyExpression[])new OWLObjectProperty[]{this.p, this.q}, (OWLObjectPropertyExpression)this.r), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), OWL.propertyAssertion((OWLIndividual)this.b, (OWLObjectPropertyExpression)this.q, (OWLIndividual)this.c)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), 0, axioms[1]);
        this.testExplanations((OWLAxiom)OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.r, (OWLIndividual)this.c), 0, axioms);
    }

    @Test
    public void propertyChain2() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subPropertyOf((OWLObjectPropertyExpression[])new OWLObjectProperty[]{this.p, this.q}, (OWLObjectPropertyExpression)this.r), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), OWL.propertyAssertion((OWLIndividual)this.b, (OWLObjectPropertyExpression)this.q, (OWLIndividual)this.c), OWL.equivalentClasses((OWLDescription)this.A, (OWLDescription)OWL.some((OWLObjectPropertyExpression)this.r, (OWLDescription)OWL.Thing))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), 0, axioms);
    }

    @Test
    public void inferredSubProperty() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subPropertyOf((OWLObjectPropertyExpression)this.p, (OWLObjectPropertyExpression)this.r), OWL.subPropertyOf((OWLObjectPropertyExpression)this.r, (OWLObjectPropertyExpression)this.q), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.r, (OWLIndividual)this.b), 0, axioms[0], axioms[2]);
        this.testExplanations((OWLAxiom)OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.q, (OWLIndividual)this.b), 0, axioms);
    }

    @Test
    public void multipleDatatypeRange() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.range((OWLDataPropertyExpression)this.dp, (OWLDataRange)XSD.BYTE), OWL.range((OWLDataPropertyExpression)this.dp, (OWLDataRange)XSD.NON_POSITIVE_INTEGER), OWL.range((OWLDataPropertyExpression)this.dp, (OWLDataRange)XSD.NON_NEGATIVE_INTEGER), OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.min((OWLDataPropertyExpression)this.dp, (int)1)), OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dp, (OWLConstant)OWL.constant((int)0)), 0, axioms[1], axioms[2], axioms[3], axioms[4]);
    }

    @Test
    public void subPropertiesOfFunctionalDataProperty() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.functional((OWLDataPropertyExpression)this.dp), OWL.subPropertyOf((OWLDataPropertyExpression)this.dq, (OWLDataPropertyExpression)this.dp), OWL.subPropertyOf((OWLDataPropertyExpression)this.dr, (OWLDataPropertyExpression)this.dp), OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dq, (OWLConstant)OWL.constant((int)1)), OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)OWL.some((OWLDataPropertyExpression)this.dr, (OWLDataRange)XSD.INTEGER))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dp, (OWLConstant)OWL.constant((int)1)), 0, axioms[1], axioms[3]);
        this.testExplanations((OWLAxiom)OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dr, (OWLConstant)OWL.constant((int)1)), 0, axioms);
    }

    @Test
    public void simpleSubClass() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.B, (OWLDescription)this.C), OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.all((OWLObjectPropertyExpression)this.p, (OWLDescription)this.B))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.C), 0, axioms[0], axioms[1]);
    }

    @Test
    public void simpleType() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.A), OWL.subClassOf((OWLDescription)this.A, (OWLDescription)this.B), OWL.subClassOf((OWLDescription)this.A, (OWLDescription)OWL.all((OWLObjectPropertyExpression)this.p, (OWLDescription)this.B))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLDescription)this.B), 0, axioms[0], axioms[1]);
    }

    @Test
    public void simplePropertyAssertion() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), 0, axioms);
    }

    @Test
    public void subPropertyAssertion() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), OWL.subPropertyOf((OWLObjectPropertyExpression)this.p, (OWLObjectPropertyExpression)this.q)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.q, (OWLIndividual)this.b), 0, axioms);
    }
}

