/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation.test;

import com.clarkparsia.explanation.PelletExplanation;
import com.clarkparsia.owlapi.OWL;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;

public class ExplainationInconsistent {
    @Test
    public void testExplain() throws Exception {
        OWLClass A = OWL.Class((String)"A");
        OWLClass B = OWL.Class((String)"B");
        OWLClass C = OWL.Class((String)"C");
        OWLIndividual i = OWL.Individual((String)"i");
        OWLIndividual j = OWL.Individual((String)"j");
        HashSet<Object> axioms = new HashSet<Object>();
        axioms.add(OWL.disjointClasses((OWLDescription)A, (OWLDescription)B));
        axioms.add(OWL.equivalentClasses((OWLDescription)C, (OWLDescription)OWL.Nothing));
        axioms.add(OWL.classAssertion((OWLIndividual)i, (OWLDescription)A));
        axioms.add(OWL.classAssertion((OWLIndividual)i, (OWLDescription)B));
        axioms.add(OWL.classAssertion((OWLIndividual)j, (OWLDescription)C));
        PelletOptions.USE_TRACING = true;
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ontology = manager.createOntology(axioms);
        Reasoner reasoner = new Reasoner(manager);
        reasoner.loadOntology(ontology);
        PelletExplanation explain = new PelletExplanation(reasoner);
        Set actual = explain.getInconsistencyExplanations();
        HashSet<Object> f = new HashSet<Object>();
        f.add(OWL.classAssertion((OWLIndividual)i, (OWLDescription)B));
        f.add(OWL.classAssertion((OWLIndividual)i, (OWLDescription)A));
        f.add(OWL.disjointClasses((OWLDescription)A, (OWLDescription)B));
        HashSet<Object> s = new HashSet<Object>();
        s.add(OWL.equivalentClasses((OWLDescription)C, (OWLDescription)OWL.Nothing));
        s.add(OWL.classAssertion((OWLIndividual)j, (OWLDescription)C));
        HashSet<HashSet<Object>> expected = new HashSet<HashSet<Object>>();
        expected.add(f);
        expected.add(s);
        Assert.assertEquals(expected, (Object)actual);
    }
}

