/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation.test;

import com.clarkparsia.explanation.ExplanationGenerator;
import com.clarkparsia.explanation.SatisfiabilityConverter;
import com.clarkparsia.explanation.io.ConciseExplanationRenderer;
import com.clarkparsia.owlapi.OntologyUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplanationTester {
    private static final Logger log = Logger.getLogger(ExplanationTester.class.getName());
    private SatisfiabilityConverter converter;
    private ConciseExplanationRenderer renderer;
    private ExplanationGenerator expGen;
    private int axiomCount = 0;

    public ExplanationTester(ExplanationGenerator expGen) {
        this.expGen = expGen;
        this.converter = new SatisfiabilityConverter(OntologyUtils.getOWLOntologyManager().getOWLDataFactory());
        this.renderer = new ConciseExplanationRenderer();
    }

    public void testExplanations(OWLAxiom axiom, int max, Set<Set<OWLAxiom>> expectedExplanations) throws Exception {
        OWLDescription unsatClass = this.converter.convert(axiom);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Axiom " + ++this.axiomCount + ": " + axiom + " Expecting " + expectedExplanations.size() + " explanations");
        }
        Set generatedExplanations = this.expGen.getExplanations(unsatClass, max);
        HashSet<Set<OWLAxiom>> notFoundExplanations = new HashSet<Set<OWLAxiom>>(expectedExplanations);
        if (log.isLoggable(Level.FINER)) {
            StringWriter sw = new StringWriter();
            this.renderer.startRendering((Writer)sw);
            this.renderer.render(axiom, expectedExplanations);
            this.renderer.endRendering();
            log.finer("Expected:\n" + sw);
        }
        Assert.assertNotNull((String)("Axiom " + axiom + " not entailed"), (Object)generatedExplanations);
        HashSet<Set> unexpectedExplanations = new HashSet<Set>();
        for (Set explanation : generatedExplanations) {
            if (notFoundExplanations.remove(explanation)) continue;
            unexpectedExplanations.add(explanation);
        }
        if (!notFoundExplanations.isEmpty() || !unexpectedExplanations.isEmpty()) {
            StringWriter sw = new StringWriter();
            ConciseExplanationRenderer renderer = new ConciseExplanationRenderer();
            renderer.startRendering((Writer)sw);
            sw.getBuffer().append("\nExpected:\n");
            renderer.render(axiom, expectedExplanations);
            if (!notFoundExplanations.isEmpty()) {
                sw.getBuffer().append("Not Found:\n");
                renderer.render(axiom, notFoundExplanations);
            }
            if (!unexpectedExplanations.isEmpty()) {
                sw.getBuffer().append("Unexpected:\n");
                renderer.render(axiom, unexpectedExplanations);
            }
            renderer.endRendering();
            log.severe("Error in explanation: " + sw);
            Assert.fail((String)"Error in explanation, see the log file for details");
        }
    }
}

