/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation.test;

import com.clarkparsia.explanation.BlackBoxExplanation;
import com.clarkparsia.explanation.ExplanationGenerator;
import com.clarkparsia.explanation.GlassBoxExplanation;
import com.clarkparsia.explanation.HSTExplanationGenerator;
import com.clarkparsia.explanation.SatisfiabilityConverter;
import com.clarkparsia.explanation.TransactionAwareSingleExpGen;
import com.clarkparsia.explanation.io.ConciseExplanationRenderer;
import com.clarkparsia.explanation.test.AbstractExplanationTest;
import com.clarkparsia.explanation.test.JenaExplanationTest;
import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.owlapi.OntologyUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.owlapi.PelletReasonerFactory;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.inference.OWLClassReasoner;
import org.semanticweb.owl.inference.OWLReasonerFactory;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class OWLAPIExplanationTest
extends AbstractExplanationTest {
    private static final Logger log = Logger.getLogger(JenaExplanationTest.class.getName());
    private Reasoner reasoner;
    private Class<? extends TransactionAwareSingleExpGen> expGenClass;
    private SatisfiabilityConverter converter;
    private ConciseExplanationRenderer renderer;
    private ExplanationGenerator expGen;
    private int axiomCount = 0;

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.add(new Object[]{GlassBoxExplanation.class, false});
        parameters.add(new Object[]{GlassBoxExplanation.class, true});
        parameters.add(new Object[]{BlackBoxExplanation.class, false});
        parameters.add(new Object[]{BlackBoxExplanation.class, true});
        return parameters;
    }

    public OWLAPIExplanationTest(Class<? extends TransactionAwareSingleExpGen> expGenClass, boolean classify) {
        super(classify);
        this.expGenClass = expGenClass;
    }

    @Override
    public void setupGenerators(Collection<OWLAxiom> ontologyAxioms) throws Exception {
        this.converter = new SatisfiabilityConverter(OWL.factory);
        this.renderer = new ConciseExplanationRenderer();
        OWLOntology ontology = manager.createOntology(ontologyURI);
        OntologyUtils.addAxioms((OWLOntology)ontology, ontologyAxioms);
        PelletReasonerFactory pelletFactory = new PelletReasonerFactory();
        TransactionAwareSingleExpGen singleExpGen = this.expGenClass.getConstructor(OWLOntologyManager.class).newInstance(manager);
        this.reasoner = pelletFactory.createReasoner(manager);
        this.reasoner.loadOntology(ontology);
        HSTExplanationGenerator hst = new HSTExplanationGenerator(singleExpGen);
        hst.setReasonerFactory((OWLReasonerFactory)pelletFactory);
        hst.setReasoner((OWLClassReasoner)this.reasoner);
        hst.setOntology(ontology);
        this.expGen = hst;
        KnowledgeBase kb = this.reasoner.getKB();
        if (this.classify) {
            kb.setDoExplanation(true);
            kb.ensureConsistency();
            kb.setDoExplanation(false);
            kb.realize();
        }
    }

    @Override
    public void testExplanations(OWLAxiom axiom, int max, Set<Set<OWLAxiom>> expectedExplanations) throws Exception {
        OWLDescription unsatClass = this.converter.convert(axiom);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Axiom " + ++this.axiomCount + ": " + axiom + " Expecting " + expectedExplanations.size() + " explanations");
        }
        Set generatedExplanations = this.expGen.getExplanations(unsatClass, max);
        HashSet<Set<OWLAxiom>> notFoundExplanations = new HashSet<Set<OWLAxiom>>(expectedExplanations);
        if (log.isLoggable(Level.FINER)) {
            StringWriter sw = new StringWriter();
            this.renderer.startRendering((Writer)sw);
            this.renderer.render(axiom, expectedExplanations);
            this.renderer.endRendering();
            log.finer("Expected:\n" + sw);
        }
        Assert.assertNotNull((String)("Axiom " + axiom + " not entailed"), (Object)generatedExplanations);
        HashSet<Set> unexpectedExplanations = new HashSet<Set>();
        for (Set explanation : generatedExplanations) {
            if (notFoundExplanations.remove(explanation)) continue;
            unexpectedExplanations.add(explanation);
        }
        if (!notFoundExplanations.isEmpty() || !unexpectedExplanations.isEmpty()) {
            StringWriter sw = new StringWriter();
            ConciseExplanationRenderer renderer = new ConciseExplanationRenderer();
            renderer.startRendering((Writer)sw);
            sw.getBuffer().append("\nExpected:\n");
            renderer.render(axiom, expectedExplanations);
            if (!notFoundExplanations.isEmpty()) {
                sw.getBuffer().append("Not Found:\n");
                renderer.render(axiom, notFoundExplanations);
            }
            if (!unexpectedExplanations.isEmpty()) {
                sw.getBuffer().append("Unexpected:\n");
                renderer.render(axiom, unexpectedExplanations);
            }
            renderer.endRendering();
            log.severe("Error in explanation: " + sw);
            Assert.fail((String)"Error in explanation, see the log file for details");
        }
    }

    public static void main(String[] args) throws Exception {
        GlassBoxExplanation.log.setLevel(Level.FINER);
        ABox.log.setLevel(Level.FINER);
        OWLAPIExplanationTest test = new OWLAPIExplanationTest(GlassBoxExplanation.class, true);
        test.createEntities();
        test.multipleDatatypeRange();
    }
}

