/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.test;

import com.clarkparsia.modularity.ModularityUtils;
import com.clarkparsia.modularity.test.AbstractModularityTest;
import com.clarkparsia.modularity.test.TestUtils;
import com.clarkparsia.owlapi.OWL;
import com.clarkparsia.owlapi.OntologyUtils;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.junit.Ignore;
import org.junit.Test;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import uk.ac.manchester.cs.owl.modularity.ModuleType;
import uk.ac.manchester.cs.owl.modularity.SyntacticLocalityModuleExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RandomizedModularityTest
extends AbstractModularityTest {
    private String path;

    public RandomizedModularityTest(String path) {
        this.path = path;
        if (!new File(path).exists()) {
            throw new RuntimeException("Path to data files is not correct: " + path);
        }
    }

    private void modularityTest(String file) throws OWLException {
        OWLOntology ontology = OntologyUtils.loadOntology((String)("file:" + file), (boolean)false);
        HashSet<OWLEntity> signature = new HashSet<OWLEntity>();
        signature.addAll(TestUtils.selectRandomElements(ontology.getReferencedClasses(), 5));
        this.modularityTest(ontology, signature);
    }

    private void modularityTest(OWLOntology ontology, Set<OWLEntity> signature) throws OWLException {
        this.modularityTest(ontology, signature, ModuleType.BOT);
        this.modularityTest(ontology, signature, ModuleType.TOP);
        this.modularityTest(ontology, signature, ModuleType.BOT_OF_TOP);
        this.modularityTest(ontology, signature, ModuleType.TOP_OF_BOT);
    }

    private void modularityTest(OWLOntology ontology, Set<OWLEntity> signature, ModuleType moduleType) throws OWLException {
        Set computed = ModularityUtils.extractModule((OWLOntology)ontology, signature, (ModuleType)moduleType);
        SyntacticLocalityModuleExtractor segmenter = new SyntacticLocalityModuleExtractor(manager, ontology, moduleType);
        Set expected = segmenter.extract(signature);
        for (OWLEntity entity : signature) {
            OWLDeclarationAxiom declaration = OWL.declaration((OWLEntity)entity);
            computed.remove(declaration);
            computed.remove(declaration);
        }
        TestUtils.assertToStringEquals("Modules diff for " + signature, expected.toArray(new OWLAxiom[0]), computed.toArray(new OWLAxiom[0]));
    }

    @Test
    public void galenModularityTest() throws OWLException {
        this.modularityTest(this.path + "galen.owl");
    }

    @Test
    public void koalaModularityTest() throws OWLException {
        this.modularityTest(this.path + "koala.owl");
    }

    @Test
    public void sumoModularityTest() throws OWLException {
        this.modularityTest(this.path + "SUMO.owl");
    }

    @Test
    public void sweetModularityTest() throws OWLException {
        this.modularityTest(this.path + "SWEET.owl");
    }

    @Test
    @Ignore(value="See ticket #166")
    public void wineModularityTest() throws OWLException {
        this.modularityTest(this.path + "wine.owl");
    }
}

