/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.HashSet;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;

public class TestKnowledgeBase {
    @BeforeClass
    public static void setUp() {
        PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING = false;
    }

    @AfterClass
    public static void tearDown() {
        PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING = true;
    }

    public static Test suite() {
        return new JUnit4TestAdapter(TestKnowledgeBase.class);
    }

    @org.junit.Test
    public void testGetInstances1() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl i = TermFactory.term((String)"i");
        kb.addClass(C);
        kb.addIndividual(i);
        kb.addType(i, C);
        HashSet<ATermAppl> expected = new HashSet<ATermAppl>();
        expected.add(i);
        Set actual = kb.getInstances(C);
        Assert.assertEquals(expected, (Object)actual);
    }

    @org.junit.Test
    public void testGetInstances2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl j = TermFactory.term((String)"j");
        kb.addClass(C);
        kb.addIndividual(i);
        kb.addIndividual(j);
        kb.addType(i, C);
        kb.addType(j, C);
        HashSet<ATermAppl> expected = new HashSet<ATermAppl>();
        expected.add(i);
        expected.add(j);
        Set actual = kb.getInstances(C);
        Assert.assertEquals(expected, (Object)actual);
    }

    @org.junit.Test
    public void testGetInstances3() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl j = TermFactory.term((String)"j");
        kb.addClass(C);
        kb.addClass(D);
        kb.addIndividual(i);
        kb.addIndividual(j);
        kb.addSubClass(C, D);
        kb.addType(i, C);
        kb.addType(j, D);
        HashSet<ATermAppl> expectedD = new HashSet<ATermAppl>();
        expectedD.add(i);
        expectedD.add(j);
        Set actualD = kb.getInstances(D);
        Assert.assertEquals(expectedD, (Object)actualD);
        HashSet<ATermAppl> expectedC = new HashSet<ATermAppl>();
        expectedC.add(i);
        Set actualC = kb.getInstances(C);
        Assert.assertEquals(expectedC, (Object)actualC);
    }

    @org.junit.Test
    public void testGetInstances4() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl j = TermFactory.term((String)"j");
        kb.addClass(C);
        kb.addClass(D);
        kb.addIndividual(i);
        kb.addIndividual(j);
        kb.addSubClass(C, D);
        kb.addType(i, C);
        kb.addType(j, D);
        HashSet<ATermAppl> expectedD = new HashSet<ATermAppl>();
        expectedD.add(j);
        Set actualD = kb.getInstances(D, true);
        Assert.assertEquals(expectedD, (Object)actualD);
        HashSet<ATermAppl> expectedC = new HashSet<ATermAppl>();
        expectedC.add(i);
        Set actualC = kb.getInstances(C, true);
        Assert.assertEquals(expectedC, (Object)actualC);
    }

    @org.junit.Test
    public void testGetInstances5() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl j = TermFactory.term((String)"j");
        ATermAppl CaD = TermFactory.and((ATermAppl)C, (ATermAppl)D);
        kb.addClass(C);
        kb.addClass(D);
        kb.addIndividual(i);
        kb.addIndividual(j);
        kb.addType(i, C);
        kb.addType(j, D);
        HashSet expected = new HashSet();
        Set actual = kb.getInstances(CaD);
        Assert.assertEquals(expected, (Object)actual);
    }

    @org.junit.Test
    public void testGetInstances6() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl j = TermFactory.term((String)"j");
        ATermAppl CoD = TermFactory.or((ATermAppl)C, (ATermAppl)D);
        kb.addClass(C);
        kb.addClass(D);
        kb.addIndividual(i);
        kb.addIndividual(j);
        kb.addType(i, C);
        kb.addType(j, D);
        HashSet<ATermAppl> expected = new HashSet<ATermAppl>();
        expected.add(i);
        expected.add(j);
        Set actual = kb.getInstances(CoD);
        Assert.assertEquals(expected, (Object)actual);
    }

    @org.junit.Test
    public void testGetInstances7() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl j = TermFactory.term((String)"j");
        ATermAppl CaD = TermFactory.and((ATermAppl)C, (ATermAppl)D);
        kb.addClass(C);
        kb.addClass(D);
        kb.addIndividual(i);
        kb.addIndividual(j);
        kb.addType(i, C);
        kb.addType(i, D);
        kb.addType(j, D);
        HashSet<ATermAppl> expected = new HashSet<ATermAppl>();
        expected.add(i);
        Set actual = kb.getInstances(CaD);
        Assert.assertEquals(expected, (Object)actual);
    }

    @org.junit.Test
    public void testGetInstances8() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl E = TermFactory.term((String)"E");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl D = TermFactory.some((ATermAppl)p, (ATermAppl)E);
        ATermAppl i = TermFactory.term((String)"i");
        kb.addClass(C);
        kb.addClass(E);
        kb.addObjectProperty((ATerm)p);
        kb.addSubClass(D, C);
        kb.addIndividual(i);
        kb.addType(i, C);
        HashSet expected = new HashSet();
        Set actual = kb.getInstances(D, true);
        Assert.assertEquals(expected, (Object)actual);
    }

    @org.junit.Test
    public void testGetInstances9() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl E = TermFactory.term((String)"E");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl D = TermFactory.some((ATermAppl)p, (ATermAppl)E);
        ATermAppl i = TermFactory.term((String)"i");
        kb.addClass(C);
        kb.addClass(E);
        kb.addObjectProperty((ATerm)p);
        kb.addSubClass(D, C);
        kb.addIndividual(i);
        kb.addType(i, D);
        HashSet<ATermAppl> expected = new HashSet<ATermAppl>();
        expected.add(i);
        Set actual = kb.getInstances(D, true);
        Assert.assertEquals(expected, (Object)actual);
    }

    @org.junit.Test
    public void testGetInstances10() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl j = TermFactory.term((String)"j");
        ATermAppl CoD = TermFactory.or((ATermAppl)C, (ATermAppl)D);
        kb.addClass(C);
        kb.addClass(D);
        kb.addIndividual(i);
        kb.addIndividual(j);
        kb.addType(i, C);
        kb.addType(j, D);
        HashSet expected = new HashSet();
        Set actual = kb.getInstances(CoD, true);
        Assert.assertEquals(expected, (Object)actual);
    }

    @org.junit.Test
    public void testGetInstances11() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl j = TermFactory.term((String)"j");
        ATermAppl CaD = TermFactory.and((ATermAppl)C, (ATermAppl)D);
        kb.addClass(C);
        kb.addClass(D);
        kb.addIndividual(i);
        kb.addIndividual(j);
        kb.addType(i, C);
        kb.addType(i, D);
        kb.addType(j, D);
        HashSet<ATermAppl> expected = new HashSet<ATermAppl>();
        expected.add(i);
        Set actual = kb.getInstances(CaD, true);
        Assert.assertEquals(expected, (Object)actual);
    }
}

