/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.query;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.jena.JenaIOUtils;
import com.clarkparsia.pellet.sparqldl.jena.SparqlDLResultSet;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.test.query.SparqlDawgTester;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingBase;
import com.hp.hpl.jena.sparql.util.ResultSetUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.utils.PermutationGenerator;
import org.mindswap.pellet.utils.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparqlDLDawgTester
implements SparqlDawgTester {
    private static final Logger log = Logger.getLogger(SparqlDLDawgTester.class.getName());
    private String queryURI = "";
    private Set<String> graphURIs = new HashSet<String>();
    private Set<String> namedGraphURIs = new HashSet<String>();
    private OntModel model = null;
    private Query query = null;
    private String resultURI = null;
    private boolean allOrderings;
    private boolean writeResults = true;
    private boolean noCheck;

    public SparqlDLDawgTester(boolean allOrderings, boolean noCheck) {
        this.allOrderings = allOrderings;
        this.noCheck = noCheck;
    }

    @Override
    public void setDatasetURIs(Set<String> graphURIs, Set<String> namedGraphURIs) {
        if (((Object)this.graphURIs).equals(graphURIs) && ((Object)this.namedGraphURIs).equals(namedGraphURIs)) {
            return;
        }
        this.graphURIs = graphURIs;
        this.namedGraphURIs = namedGraphURIs;
        this.model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        for (String dataURI : graphURIs) {
            this.model.read(dataURI, null, JenaIOUtils.fileType((String)dataURI).jenaName());
        }
        this.model.prepare();
    }

    @Override
    public void setQueryURI(String queryURI) {
        if (this.queryURI.equals(queryURI)) {
            return;
        }
        this.queryURI = queryURI;
        com.hp.hpl.jena.query.Query query = QueryFactory.read((String)queryURI);
        this.query = QueryEngine.getParser().parse(query.toString(Syntax.syntaxSPARQL), ((PelletInfGraph)this.model.getGraph()).getKB());
    }

    @Override
    public void setResult(String resultURI) {
        this.resultURI = resultURI;
        if (resultURI == null) {
            this.noCheck = true;
        }
    }

    @Override
    public boolean isParsable() {
        try {
            QueryEngine.getParser().parse((InputStream)new FileInputStream(this.queryURI.substring(5)), new KnowledgeBase());
            return true;
        }
        catch (Exception e) {
            log.log(Level.INFO, e.getMessage(), e);
            return false;
        }
    }

    @Override
    public boolean isCorrectlyEvaluated() {
        try {
            boolean ok = true;
            if (this.query.getDistVars().isEmpty()) {
                Boolean expected = null;
                if (!this.noCheck) {
                    expected = JenaIOUtils.parseAskResult((String)this.resultURI);
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Expected=" + expected);
                    }
                }
                if (this.allOrderings) {
                    PermutationGenerator g = new PermutationGenerator(this.query.getAtoms().size());
                    while (g.hasMore()) {
                        ok &= this.runSingleAskTest(this.query.reorder(g.getNext()), expected);
                    }
                } else {
                    ok = this.runSingleAskTest(this.query, expected);
                }
                return ok;
            }
            ResultSetRewindable expected = null;
            if (!this.noCheck) {
                expected = ResultSetFactory.makeRewindable((ResultSet)JenaIOUtils.parseResultSet((String)this.resultURI));
                List expectedList = ResultSetFormatter.toList((ResultSet)expected);
                if (expected.size() > 10) {
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "Expected=" + expectedList.subList(0, 9) + " ... " + expectedList.size());
                    }
                } else if (log.isLoggable(Level.INFO)) {
                    log.info("Expected=" + expectedList);
                }
            }
            if (this.allOrderings) {
                PermutationGenerator g = new PermutationGenerator(this.query.getAtoms().size());
                while (g.hasMore()) {
                    ok &= this.runSingleSelectTest(this.query.reorder(g.getNext()), expected);
                }
            } else {
                ok = this.runSingleSelectTest(this.query, expected);
            }
            return ok;
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    private QueryResult runSingleTest(Query query) {
        Timer t = new Timer("Single query execution");
        t.start();
        QueryResult bindings = QueryEngine.exec((Query)query);
        log.info("Execution time=" + t.getElapsed());
        t.stop();
        log.info("Result size = " + bindings.size());
        return bindings;
    }

    private final boolean runSingleAskTest(Query query, Boolean expected) {
        QueryResult bindings = this.runSingleTest(query);
        boolean ok = true;
        if (!this.noCheck) {
            Boolean real = !bindings.isEmpty();
            log.log(Level.INFO, "real=" + real + ", exp=" + expected);
            ok = real == null && expected == null || real != null && real.equals(expected);
        }
        return ok;
    }

    private final boolean runSingleSelectTest(Query query, ResultSetRewindable expected) {
        QueryResult bindings = this.runSingleTest(query);
        boolean ok = true;
        if (!this.noCheck) {
            ResultSetRewindable real = this.realResultsHandler(bindings);
            real.reset();
            expected.reset();
            ok &= ResultSetUtils.equals((ResultSet)real, (ResultSet)expected);
            if (this.writeResults) {
                real.reset();
                expected.reset();
                try {
                    real.reset();
                    ResultSetFormatter.out((OutputStream)new FileOutputStream("real"), (ResultSet)real);
                    ResultSetFormatter.out((OutputStream)new FileOutputStream("real-expected"), (ResultSet)new DifferenceResultSet((ResultSet)real, (ResultSet)expected));
                    ResultSetFormatter.out((OutputStream)new FileOutputStream("expected-real"), (ResultSet)new DifferenceResultSet((ResultSet)expected, (ResultSet)real));
                }
                catch (FileNotFoundException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        return ok;
    }

    private void writeResults(List<ATermAppl> resultVars, Collection<ResultBinding> bindingCollection, FileWriter fwre) throws IOException {
        for (ATermAppl var : resultVars) {
            fwre.write(var.getName() + "\t");
        }
        for (ResultBinding b : bindingCollection) {
            for (ATermAppl var : resultVars) {
                fwre.write(b.getValue(var) + "\t");
            }
            fwre.write("\n");
        }
    }

    private final ResultSetRewindable realResultsHandler(QueryResult bindings) {
        ResultSetRewindable real = ResultSetFactory.makeRewindable((ResultSet)new SparqlDLResultSet(bindings, this.model.getRawModel()));
        List realList = ResultSetFormatter.toList((ResultSet)real);
        if (realList.size() > 10) {
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "Real=" + realList.subList(0, 9) + " ... " + realList.size());
            }
        } else if (log.isLoggable(Level.INFO)) {
            log.info("Real=" + realList);
        }
        real.reset();
        return real;
    }

    @Override
    public boolean isApplicable(String uri) {
        return !uri.startsWith("http://www.w3.org/2001/sw/DataAccess/tests/data-r2/syntax-sparql1/manifest#") && !uri.startsWith("http://www.w3.org/2001/sw/DataAccess/tests/data-r2/syntax-sparql2/manifest#") && !uri.startsWith("http://www.w3.org/2001/sw/DataAccess/tests/data-r2/syntax-sparql3/manifest#") && !uri.startsWith("http://www.w3.org/2001/sw/DataAccess/tests/data-r2/syntax-sparql4/manifest#");
    }

    @Override
    public String getName() {
        return "SparqlDLDawgTester";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DifferenceResultSet
    implements ResultSet {
        private final List<Binding> solutions = new ArrayList<Binding>();
        private final List<String> vars;
        private int index;

        public DifferenceResultSet(ResultSet rs1, ResultSet rs2) {
            this.vars = rs1.getResultVars();
            this.index = 0;
            ResultSetRewindable real = ResultSetFactory.makeRewindable((ResultSet)rs1);
            ResultSetRewindable expected = ResultSetFactory.makeRewindable((ResultSet)rs2);
            real.reset();
            while (real.hasNext()) {
                Binding b1 = real.nextBinding();
                expected.reset();
                boolean toAdd = true;
                while (expected.hasNext()) {
                    Binding b2 = expected.nextBinding();
                    if (!BindingBase.equals((Binding)b1, (Binding)b2)) continue;
                    toAdd = false;
                    break;
                }
                if (!toAdd) continue;
                this.solutions.add(b1);
            }
        }

        public List<String> getResultVars() {
            return this.vars;
        }

        public int getRowNumber() {
            return this.index;
        }

        public boolean hasNext() {
            return this.index < this.solutions.size();
        }

        public QuerySolution next() {
            throw new UnsupportedOperationException("Next is not supported.");
        }

        public Binding nextBinding() {
            return this.solutions.get(this.index++);
        }

        public QuerySolution nextSolution() {
            throw new UnsupportedOperationException("Next solution is not supported.");
        }

        public void remove() {
            throw new UnsupportedOperationException("Removal is not supported.");
        }

        public Model getResourceModel() {
            return null;
        }
    }
}

