/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.query;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryAtomFactory;
import com.clarkparsia.pellet.sparqldl.model.QueryImpl;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import org.junit.Before;
import org.junit.Test;
import org.mindswap.pellet.KnowledgeBase;

public class TestMiscQueries {
    private KnowledgeBase kb;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestMiscQueries.class);
    }

    @Before
    public void setUp() {
        this.kb = new KnowledgeBase();
    }

    private ATermAppl[] select(ATermAppl ... vars) {
        return vars;
    }

    private QueryAtom[] where(QueryAtom ... atoms) {
        return atoms;
    }

    private Query query(ATermAppl[] vars, QueryAtom[] atoms) {
        QueryImpl q = new QueryImpl(this.kb, true);
        for (ATermAppl aTermAppl : vars) {
            q.addResultVar(aTermAppl);
        }
        for (ATermAppl aTermAppl : atoms) {
            q.add((QueryAtom)aTermAppl);
        }
        for (ATermAppl var : q.getUndistVars()) {
            q.addDistVar(var, Query.VarType.INDIVIDUAL);
        }
        return q;
    }

    private static void testQuery(Query query, ATermAppl[] ... values) {
        List resultVars = query.getResultVars();
        HashMap<List<Object>, Integer> answers = new HashMap<List<Object>, Integer>();
        for (int i = 0; i < values.length; ++i) {
            List<ATermAppl> answer = Arrays.asList(values[i]);
            Integer count = (Integer)answers.get(answer);
            if (count == null) {
                answers.put(answer, 1);
                continue;
            }
            answers.put(answer, count + 1);
        }
        QueryResult result = QueryEngine.exec((Query)query);
        for (ResultBinding binding : result) {
            ArrayList<ATermAppl> list = new ArrayList<ATermAppl>(resultVars.size());
            for (ATermAppl var : resultVars) {
                list.add(binding.getValue(var));
            }
            Integer count = (Integer)answers.get(list);
            if (count == null) {
                Assert.fail((String)("Unexpected binding in the result: " + list));
                continue;
            }
            if (count == 1) {
                answers.remove(list);
                continue;
            }
            answers.put(list, count - 1);
        }
        Assert.assertTrue((String)("Unfound bindings: " + answers.keySet()), (boolean)answers.isEmpty());
    }

    @Test
    public void domainQuery1() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl r = TermFactory.term((String)"r");
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addObjectProperty((ATerm)q);
        this.kb.addDatatypeProperty((ATerm)r);
        this.kb.addSubProperty((ATerm)q, p);
        this.kb.addDomain((ATerm)p, C);
        ATermAppl pv = TermFactory.var((String)"pv");
        ATermAppl cv = TermFactory.var((String)"cv");
        Query query = this.query(this.select(pv, cv), this.where(QueryAtomFactory.DomainAtom((ATermAppl)pv, (ATermAppl)cv)));
        TestMiscQueries.testQuery(query, {p, TermFactory.TOP}, {q, TermFactory.TOP}, {r, TermFactory.TOP}, {TermFactory.TOP_OBJECT_PROPERTY, TermFactory.TOP}, {TermFactory.TOP_DATA_PROPERTY, TermFactory.TOP}, {TermFactory.BOTTOM_OBJECT_PROPERTY, TermFactory.TOP}, {TermFactory.BOTTOM_DATA_PROPERTY, TermFactory.TOP}, {TermFactory.BOTTOM_DATA_PROPERTY, TermFactory.BOTTOM}, {TermFactory.BOTTOM_OBJECT_PROPERTY, TermFactory.BOTTOM}, {p, C}, {q, C}, {TermFactory.BOTTOM_DATA_PROPERTY, C}, {TermFactory.BOTTOM_OBJECT_PROPERTY, C}, {TermFactory.BOTTOM_DATA_PROPERTY, D}, {TermFactory.BOTTOM_OBJECT_PROPERTY, D});
    }

    @Test
    public void domainQuery2() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl r = TermFactory.term((String)"r");
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addObjectProperty((ATerm)q);
        this.kb.addDatatypeProperty((ATerm)r);
        this.kb.addSubProperty((ATerm)q, p);
        this.kb.addDomain((ATerm)p, C);
        ATermAppl pv = TermFactory.var((String)"pv");
        ATermAppl cv = TermFactory.var((String)"cv");
        Query query = this.query(this.select(cv), this.where(QueryAtomFactory.DomainAtom((ATermAppl)q, (ATermAppl)cv)));
        TestMiscQueries.testQuery(query, {TermFactory.TOP}, {C});
    }

    @Test
    public void domainQuery3() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl r = TermFactory.term((String)"r");
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addObjectProperty((ATerm)q);
        this.kb.addDatatypeProperty((ATerm)r);
        this.kb.addSubProperty((ATerm)q, p);
        this.kb.addDomain((ATerm)p, C);
        ATermAppl pv = TermFactory.var((String)"pv");
        ATermAppl cv = TermFactory.var((String)"cv");
        Query query = this.query(this.select(pv), this.where(QueryAtomFactory.DomainAtom((ATermAppl)pv, (ATermAppl)C)));
        TestMiscQueries.testQuery(query, {p}, {q}, {TermFactory.BOTTOM_OBJECT_PROPERTY}, {TermFactory.BOTTOM_DATA_PROPERTY});
    }

    @Test
    public void rangeQuery1() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl r = TermFactory.term((String)"r");
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addObjectProperty((ATerm)q);
        this.kb.addDatatypeProperty((ATerm)r);
        this.kb.addSubProperty((ATerm)q, p);
        this.kb.addRange((ATerm)p, C);
        ATermAppl pv = TermFactory.var((String)"pv");
        ATermAppl cv = TermFactory.var((String)"cv");
        Query query = this.query(this.select(pv, cv), this.where(QueryAtomFactory.RangeAtom((ATermAppl)pv, (ATermAppl)cv), QueryAtomFactory.ObjectPropertyAtom((ATermAppl)pv)));
        TestMiscQueries.testQuery(query, {p, TermFactory.TOP}, {q, TermFactory.TOP}, {TermFactory.TOP_OBJECT_PROPERTY, TermFactory.TOP}, {TermFactory.BOTTOM_OBJECT_PROPERTY, TermFactory.TOP}, {TermFactory.BOTTOM_OBJECT_PROPERTY, TermFactory.BOTTOM}, {p, C}, {q, C}, {TermFactory.BOTTOM_OBJECT_PROPERTY, C}, {TermFactory.BOTTOM_OBJECT_PROPERTY, D});
    }

    @Test
    public void rangeQuery2() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl r = TermFactory.term((String)"r");
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addObjectProperty((ATerm)q);
        this.kb.addDatatypeProperty((ATerm)r);
        this.kb.addSubProperty((ATerm)q, p);
        this.kb.addRange((ATerm)p, C);
        ATermAppl pv = TermFactory.var((String)"pv");
        ATermAppl cv = TermFactory.var((String)"cv");
        Query query = this.query(this.select(cv), this.where(QueryAtomFactory.RangeAtom((ATermAppl)q, (ATermAppl)cv)));
        TestMiscQueries.testQuery(query, {TermFactory.TOP}, {C});
    }
}

