/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.transtree;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.owlapi.OntologyUtils;
import java.util.Set;
import org.junit.Test;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.owlapi.OWLAPILoader;
import org.mindswap.pellet.taxonomy.POTaxonomyBuilder;
import org.mindswap.pellet.taxonomy.SubsumptionComparator;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.printer.ClassTreePrinter;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.PartialOrderComparator;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLObjectProperty;

public class TransTreeTest {
    @Test
    public void testDiscoveryOntology() {
        this.testProperty("test/data/trans-tree-tests/discovery.owl", "http://purl.org/vocab/relationship/ancestorOf");
    }

    private void testProperty(String ontologyURI, String propertyURI) {
        OWLAPILoader loader = new OWLAPILoader();
        KnowledgeBase kb = loader.createKB(new String[]{ontologyURI});
        OWLEntity entity = OntologyUtils.findEntity((String)propertyURI, (Set)loader.getOntologies());
        if (entity == null) {
            throw new IllegalArgumentException("Property not found: " + propertyURI);
        }
        if (!(entity instanceof OWLObjectProperty)) {
            throw new IllegalArgumentException("Not an object property: " + propertyURI);
        }
        if (!((OWLObjectProperty)entity).isTransitive(loader.getOntologies())) {
            throw new IllegalArgumentException("Not a transitive property: " + propertyURI);
        }
        ATermAppl p = ATermUtils.makeTermAppl((String)entity.getURI().toString());
        POTaxonomyBuilder builder = null;
        builder = new POTaxonomyBuilder(kb, (PartialOrderComparator)new PartClassesComparator(kb, p));
        builder.classify();
        Taxonomy taxonomy = builder.getTaxonomy();
        ClassTreePrinter printer = new ClassTreePrinter();
        printer.print(taxonomy);
    }

    private static class PartIndividualsComparator
    extends SubsumptionComparator {
        private ATermAppl p;

        public PartIndividualsComparator(KnowledgeBase kb, ATermAppl p) {
            super(kb);
            this.p = p;
        }

        protected boolean isSubsumedBy(ATermAppl a, ATermAppl b) {
            return this.kb.hasPropertyValue(a, this.p, b);
        }
    }

    private static class PartClassesComparator
    extends SubsumptionComparator {
        private ATermAppl p;

        public PartClassesComparator(KnowledgeBase kb, ATermAppl p) {
            super(kb);
            this.p = p;
        }

        protected boolean isSubsumedBy(ATermAppl a, ATermAppl b) {
            ATermAppl someB = ATermUtils.makeSomeValues((ATerm)this.p, (ATerm)b);
            return this.kb.isSubClassOf(a, someB);
        }
    }
}

