/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.model;

import com.clarkparsia.pellint.lintpattern.LintPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.OntologyLints;
import com.clarkparsia.pellint.test.PellintTestCase;
import com.clarkparsia.pellint.test.lintpattern.MockLintPattern;
import com.clarkparsia.pellint.test.model.MockLint;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.owl.model.OWLOntologyChangeException;

public class OntologyLintsTest
extends PellintTestCase {
    @Test
    public void testSize() {
        OntologyLints ontologyLints = new OntologyLints(this.m_Ontology);
        Assert.assertSame((Object)this.m_Ontology, (Object)ontologyLints.getOntology());
        Assert.assertTrue((boolean)ontologyLints.isEmpty());
        Assert.assertEquals((long)0L, (long)ontologyLints.size());
        MockLint lint = new MockLint();
        MockLintPattern pattern1 = new MockLintPattern(false);
        ontologyLints.addLint((LintPattern)pattern1, (Lint)lint);
        Assert.assertFalse((boolean)ontologyLints.isEmpty());
        Assert.assertEquals((long)1L, (long)ontologyLints.size());
        MockLintPattern pattern2 = new MockLintPattern(true);
        List<Lint> lints = Arrays.asList(new Lint[]{new MockLint(), new MockLint(), new MockLint()});
        ontologyLints.addLints((LintPattern)pattern2, lints);
        Assert.assertFalse((boolean)ontologyLints.isEmpty());
        Assert.assertEquals((long)(1 + lints.size()), (long)ontologyLints.size());
    }

    @Test
    public void testApplyFix() throws OWLOntologyChangeException {
        OntologyLints ontologyLints = new OntologyLints(this.m_Ontology);
        MockLint unfixableLint = new MockLint();
        MockLintPattern unfixablePattern = new MockLintPattern(false);
        ontologyLints.addLint((LintPattern)unfixablePattern, (Lint)unfixableLint);
        MockLintPattern fixablePattern = new MockLintPattern(true);
        List<Lint> lints = Arrays.asList(new Lint[]{new MockLint(), new MockLint(), new MockLint()});
        ontologyLints.addLints((LintPattern)fixablePattern, lints);
        Assert.assertEquals(Collections.singleton(unfixableLint), (Object)ontologyLints.applyFix(this.m_Manager));
    }
}

