/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.rdfxml;

import com.clarkparsia.pellint.rdfxml.RDFModel;
import com.clarkparsia.pellint.util.CollectionUtil;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RDFModelTest {
    private RDFModel m_Model;
    private RDFNode[] m_BNodes;
    private Resource[] m_Names;
    private Property[] m_Predicates;
    private Literal[] m_Literals;
    private Statement[] m_Statements;
    private String[] m_Comments;
    private Map<String, String> m_Namespaces;

    @Before
    public void setUp() throws Exception {
        int i;
        Model model = ModelFactory.createDefaultModel();
        this.m_Model = new RDFModel();
        this.m_BNodes = new RDFNode[5];
        for (i = 0; i < this.m_BNodes.length; ++i) {
            this.m_BNodes[i] = model.createResource(AnonId.create());
        }
        this.m_Names = new Resource[5];
        for (i = 0; i < this.m_Names.length; ++i) {
            this.m_Names[i] = model.createResource("tag:clarkparsia.com,2008:pellint:test:name#" + i);
        }
        this.m_Predicates = new Property[5];
        for (i = 0; i < this.m_Predicates.length; ++i) {
            this.m_Predicates[i] = model.createProperty("tag:clarkparsia.com,2008:pellint:test:pred#" + i);
        }
        this.m_Literals = new Literal[5];
        for (i = 0; i < this.m_Literals.length; ++i) {
            this.m_Literals[i] = ResourceFactory.createPlainLiteral((String)("lit" + i));
        }
        this.m_Statements = new Statement[]{model.createStatement(this.m_Names[0], this.m_Predicates[0], this.m_BNodes[0]), model.createStatement(this.m_Names[0], this.m_Predicates[0], (RDFNode)this.m_Names[1]), model.createStatement(this.m_Names[0], this.m_Predicates[0], (RDFNode)this.m_Literals[0]), model.createStatement(this.m_Names[1], this.m_Predicates[1], (RDFNode)this.m_Names[0]), model.createStatement(this.m_Names[1], this.m_Predicates[1], this.m_BNodes[1]), model.createStatement(this.m_Names[2], this.m_Predicates[2], (RDFNode)this.m_Names[3]), model.createStatement(this.m_Names[2], this.m_Predicates[3], (RDFNode)this.m_Names[0])};
        for (i = 0; i < this.m_Statements.length; ++i) {
            this.m_Model.addStatement(this.m_Statements[i]);
        }
        this.m_Comments = new String[]{"comment1"};
        for (i = 0; i < this.m_Comments.length; ++i) {
            this.m_Model.addComment(this.m_Comments[i]);
        }
        this.m_Namespaces = CollectionUtil.makeMap();
        this.m_Namespaces.put("ns1", "tag:clarkparsia.com,2008");
        for (Map.Entry<String, String> entry : this.m_Namespaces.entrySet()) {
            this.m_Model.addNamespace(entry.getKey(), entry.getValue());
        }
    }

    @Test
    public void testComments() {
        Assert.assertEquals(Arrays.asList(this.m_Comments), (Object)this.m_Model.getComments());
    }

    @Test
    public void testNamespaces() {
        Assert.assertEquals(this.m_Namespaces, (Object)this.m_Model.getNamespaces());
    }

    @Test
    public void testContains() {
        Resource newBNode = ResourceFactory.createResource((String)AnonId.create().getLabelString());
        Assert.assertFalse((boolean)this.m_Model.containsStatement(newBNode, this.m_Predicates[0], (RDFNode)newBNode));
        for (int i = 0; i < this.m_Statements.length; ++i) {
            Assert.assertTrue((boolean)this.m_Model.containsStatement(this.m_Statements[i].getSubject(), this.m_Statements[i].getPredicate(), this.m_Statements[i].getObject()));
        }
    }

    @Test
    public void testGetStatementsByObject() {
        Collection statements = null;
        statements = this.m_Model.getStatementsByObject(this.m_BNodes[2]);
        Assert.assertTrue((boolean)statements.isEmpty());
        statements = this.m_Model.getStatementsByObject(this.m_BNodes[0]);
        Assert.assertEquals((long)1L, (long)statements.size());
        Assert.assertTrue((boolean)statements.contains(this.m_Statements[0]));
        statements = this.m_Model.getStatementsByObject((RDFNode)this.m_Literals[0]);
        Assert.assertEquals((long)1L, (long)statements.size());
        Assert.assertTrue((boolean)statements.contains(this.m_Statements[2]));
        statements = this.m_Model.getStatementsByObject((RDFNode)this.m_Names[0]);
        Assert.assertEquals((long)2L, (long)statements.size());
        Assert.assertTrue((boolean)statements.contains(this.m_Statements[3]));
        Assert.assertTrue((boolean)statements.contains(this.m_Statements[6]));
    }

    @Test
    public void testGetStatementsByPredicate() {
        Collection statements = null;
        statements = this.m_Model.getStatementsByPredicate(this.m_Predicates[4]);
        Assert.assertTrue((boolean)statements.isEmpty());
        statements = this.m_Model.getStatementsByPredicate(this.m_Predicates[0]);
        Assert.assertEquals((long)3L, (long)statements.size());
        Assert.assertTrue((boolean)statements.contains(this.m_Statements[0]));
        Assert.assertTrue((boolean)statements.contains(this.m_Statements[1]));
        Assert.assertTrue((boolean)statements.contains(this.m_Statements[2]));
        statements = this.m_Model.getStatementsByPredicate(this.m_Predicates[3]);
        Assert.assertEquals((long)1L, (long)statements.size());
        Assert.assertTrue((boolean)statements.contains(this.m_Statements[6]));
    }

    @Test
    public void testGetValues() {
        Collection values = null;
        values = this.m_Model.getValues(this.m_Names[3], this.m_Predicates[3]);
        Assert.assertTrue((boolean)values.isEmpty());
        values = this.m_Model.getValues(this.m_Names[2], this.m_Predicates[4]);
        Assert.assertTrue((boolean)values.isEmpty());
        values = this.m_Model.getValues(this.m_Names[0], this.m_Predicates[0]);
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertTrue((boolean)values.contains(this.m_BNodes[0]));
        Assert.assertTrue((boolean)values.contains(this.m_Names[1]));
        Assert.assertTrue((boolean)values.contains(this.m_Literals[0]));
    }

    @Test
    public void testGetUniqueObject() {
        Assert.assertNull((Object)this.m_Model.getUniqueObject(this.m_Names[3], this.m_Predicates[3]));
        Assert.assertEquals((Object)this.m_Names[3], (Object)this.m_Model.getUniqueObject(this.m_Names[2], this.m_Predicates[2]));
    }

    @Test
    public void testAddModel() {
        RDFModel newModel = new RDFModel();
        newModel.add(this.m_Model);
        this.m_Model = newModel;
        this.testComments();
        this.testNamespaces();
        this.testContains();
        this.testGetStatementsByObject();
        this.testGetStatementsByPredicate();
        this.testGetValues();
        this.testGetUniqueObject();
    }

    @Test
    public void testAddWithBNodes() {
        Model model = ModelFactory.createDefaultModel();
        Resource newBNode = ResourceFactory.createResource((String)AnonId.create().getLabelString());
        int oldSize = this.m_Model.getStatements().size();
        List<Statement> statements = Arrays.asList(model.createStatement((Resource)this.m_BNodes[0], this.m_Predicates[0], this.m_BNodes[1]), model.createStatement(newBNode, this.m_Predicates[0], this.m_BNodes[0]), model.createStatement((Resource)this.m_BNodes[0], this.m_Predicates[0], (RDFNode)newBNode));
        this.m_Model.addAllStatementsWithExistingBNodesOnly(statements);
        Assert.assertEquals((long)(oldSize + 3), (long)this.m_Model.getStatements().size());
    }
}

