/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.TermFactory;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.test.PelletTestSuite;

public class DisjointPropertyTests {
    public static String base = "file:" + PelletTestSuite.base + "misc/";
    private KnowledgeBase kb = null;
    private ATermAppl a = TermFactory.term((String)"a");
    private ATermAppl b = TermFactory.term((String)"b");
    private ATermAppl c = TermFactory.term((String)"c");
    private ATermAppl p = TermFactory.term((String)"p");
    private ATermAppl q = TermFactory.term((String)"q");

    public static void main(String[] args) {
        TestRunner.run((Test)DisjointPropertyTests.suite());
    }

    public static Test suite() {
        return new JUnit4TestAdapter(DisjointPropertyTests.class);
    }

    @Before
    public void before() {
        this.kb = new KnowledgeBase();
        this.kb.addObjectProperty((ATerm)this.p);
        this.kb.addObjectProperty((ATerm)this.q);
        this.kb.addIndividual(this.a);
        this.kb.addIndividual(this.b);
        this.kb.addIndividual(this.c);
        this.kb.addDisjointProperty(this.p, this.q);
    }

    @org.junit.Test
    public void simpleInconcistency() {
        this.kb.addPropertyValue(this.p, this.a, this.b);
        this.kb.addPropertyValue(this.q, this.a, this.b);
        Assert.assertFalse((boolean)this.kb.isConsistent());
    }

    @org.junit.Test
    public void subPropertyInconcistency() {
        ATermAppl subP = TermFactory.term((String)"subP");
        this.kb.addObjectProperty((ATerm)subP);
        this.kb.addSubProperty((ATerm)subP, this.p);
        this.kb.addPropertyValue(subP, this.a, this.b);
        this.kb.addPropertyValue(this.q, this.a, this.b);
        Assert.assertFalse((boolean)this.kb.isConsistent());
    }

    @org.junit.Test
    public void superPropertyConcistency() {
        ATermAppl supP = TermFactory.term((String)"supP");
        this.kb.addObjectProperty((ATerm)supP);
        this.kb.addSubProperty((ATerm)this.p, supP);
        this.kb.addPropertyValue(supP, this.a, this.b);
        this.kb.addPropertyValue(this.q, this.b, this.b);
        Assert.assertTrue((boolean)this.kb.isConsistent());
    }

    @org.junit.Test
    public void invPropertyInconcistency() {
        ATermAppl invP = TermFactory.term((String)"invP");
        this.kb.addObjectProperty((ATerm)invP);
        this.kb.addInverseProperty(invP, this.p);
        this.kb.addPropertyValue(invP, this.b, this.a);
        this.kb.addPropertyValue(this.q, this.a, this.b);
        Assert.assertFalse((boolean)this.kb.isConsistent());
    }

    @org.junit.Test
    public void differentFromSubjects() {
        this.kb.addPropertyValue(this.p, this.a, this.c);
        this.kb.addPropertyValue(this.q, this.b, this.c);
        Assert.assertTrue((boolean)this.kb.isDifferentFrom(this.a, this.b));
    }

    @org.junit.Test
    public void differentFromObjects() {
        this.kb.addPropertyValue(this.p, this.a, this.b);
        this.kb.addPropertyValue(this.q, this.a, this.c);
        Assert.assertTrue((boolean)this.kb.isDifferentFrom(this.b, this.c));
    }
}

