/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecutionFactory;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import org.junit.Assert;
import org.junit.Test;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.owlapi.Reasoner;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;

public class TestAnnotations {
    private static final String DATA1_RDF = "file:test/data/annotations/data1.rdf";
    private static final String DATA1_TTL = "file:test/data/annotations/data1.ttl";
    private static final String QUERY1_RQ = "file:test/data/annotations/query1.rq";

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestAnnotations.class);
    }

    @Test
    public void addAnnotation1() {
        PelletOptions.USE_ANNOTATION_SUPPORT = true;
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl s = ATermUtils.makeTermAppl((String)"i");
        ATermAppl p = ATermUtils.makeTermAppl((String)"p");
        ATermAppl o = ATermUtils.makePlainLiteral((String)"o");
        kb.addIndividual(s);
        kb.addAnnotationProperty(p);
        Assert.assertTrue((boolean)kb.addAnnotation(s, p, o));
        Assert.assertTrue((boolean)kb.isIndividual((ATerm)s));
        Assert.assertTrue((boolean)kb.isAnnotationProperty((ATerm)p));
        Assert.assertFalse((boolean)kb.isIndividual((ATerm)o));
    }

    @Test
    public void addAnnotation2() {
        PelletOptions.USE_ANNOTATION_SUPPORT = true;
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl s = ATermUtils.makeTermAppl((String)"i");
        ATermAppl p = ATermUtils.makeTermAppl((String)"p");
        ATermAppl o = ATermUtils.makeTermAppl((String)"j");
        kb.addIndividual(s);
        kb.addIndividual(o);
        kb.addAnnotationProperty(p);
        Assert.assertTrue((boolean)kb.addAnnotation(s, p, o));
        Assert.assertTrue((boolean)kb.isIndividual((ATerm)s));
        Assert.assertTrue((boolean)kb.isAnnotationProperty((ATerm)p));
        Assert.assertTrue((boolean)kb.isIndividual((ATerm)o));
    }

    @Test
    public void addAnnotation3() {
        PelletOptions.USE_ANNOTATION_SUPPORT = true;
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl s = ATermUtils.makeTermAppl((String)"i");
        ATermAppl p = ATermUtils.makeTermAppl((String)"p");
        ATermAppl o = ATermUtils.makeBnode((String)"b");
        kb.addIndividual(s);
        kb.addAnnotationProperty(p);
        Assert.assertTrue((boolean)kb.addAnnotation(s, p, o));
        Assert.assertTrue((boolean)kb.isIndividual((ATerm)s));
        Assert.assertTrue((boolean)kb.isAnnotationProperty((ATerm)p));
        Assert.assertFalse((boolean)kb.isIndividual((ATerm)o));
    }

    @Test
    public void addAnnotations() {
        PelletOptions.USE_ANNOTATION_SUPPORT = true;
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl s = ATermUtils.makeTermAppl((String)"i");
        ATermAppl p = ATermUtils.makeTermAppl((String)"p");
        ATermAppl o1 = ATermUtils.makePlainLiteral((String)"o1");
        ATermAppl o2 = ATermUtils.makePlainLiteral((String)"o2");
        kb.addIndividual(s);
        kb.addAnnotationProperty(p);
        Assert.assertTrue((boolean)kb.addAnnotation(s, p, o1));
        Assert.assertTrue((boolean)kb.addAnnotation(s, p, o2));
        Assert.assertTrue((boolean)kb.isIndividual((ATerm)s));
        Assert.assertTrue((boolean)kb.isAnnotationProperty((ATerm)p));
        Assert.assertFalse((boolean)kb.isIndividual((ATerm)o1));
        Assert.assertFalse((boolean)kb.isIndividual((ATerm)o2));
    }

    @Test
    public void getAnnotations1() {
        PelletOptions.USE_ANNOTATION_SUPPORT = true;
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl s = ATermUtils.makeTermAppl((String)"i");
        ATermAppl p = ATermUtils.makeTermAppl((String)"p");
        ATermAppl o = ATermUtils.makeTermAppl((String)"j");
        kb.addIndividual(s);
        kb.addAnnotationProperty(p);
        Assert.assertTrue((boolean)kb.addAnnotation(s, p, o));
        Set actual = kb.getAnnotations(s, p);
        HashSet<ATermAppl> expected = new HashSet<ATermAppl>();
        expected.add(o);
        Assert.assertEquals(expected, (Object)actual);
        actual = kb.getAnnotations(null, p);
        Assert.assertNull((Object)actual);
        actual = kb.getAnnotations(s, null);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void getAnnotations2() {
        PelletOptions.USE_ANNOTATION_SUPPORT = true;
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl s = ATermUtils.makeTermAppl((String)"i");
        ATermAppl p = ATermUtils.makeTermAppl((String)"p");
        ATermAppl o1 = ATermUtils.makeTermAppl((String)"j1");
        ATermAppl o2 = ATermUtils.makeTermAppl((String)"j2");
        kb.addIndividual(s);
        kb.addAnnotationProperty(p);
        Assert.assertTrue((boolean)kb.addAnnotation(s, p, o1));
        Assert.assertTrue((boolean)kb.addAnnotation(s, p, o2));
        Set actual = kb.getAnnotations(s, p);
        HashSet<ATermAppl> expected = new HashSet<ATermAppl>();
        expected.add(o1);
        expected.add(o2);
        Assert.assertEquals(expected, (Object)actual);
        actual = kb.getAnnotations(null, p);
        Assert.assertNull((Object)actual);
        actual = kb.getAnnotations(s, null);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void getAnnotations3() {
        PelletOptions.USE_ANNOTATION_SUPPORT = true;
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl s1 = ATermUtils.makeTermAppl((String)"s1");
        ATermAppl p1 = ATermUtils.makeTermAppl((String)"p1");
        ATermAppl o1 = ATermUtils.makeTermAppl((String)"o1");
        ATermAppl s2 = ATermUtils.makeTermAppl((String)"s2");
        ATermAppl p2 = ATermUtils.makeTermAppl((String)"p2");
        ATermAppl o2 = ATermUtils.makeTermAppl((String)"o2");
        ATermAppl o3 = ATermUtils.makeTermAppl((String)"o3");
        kb.addIndividual(s1);
        kb.addIndividual(s2);
        kb.addAnnotationProperty(p1);
        kb.addAnnotationProperty(p2);
        Assert.assertTrue((boolean)kb.addAnnotation(s1, p1, o1));
        Assert.assertTrue((boolean)kb.addAnnotation(s1, p2, o2));
        Assert.assertTrue((boolean)kb.addAnnotation(s2, p2, o3));
        Set actual = kb.getAnnotations(s1, p1);
        HashSet<ATermAppl> expected = new HashSet<ATermAppl>();
        expected.add(o1);
        Assert.assertEquals(expected, (Object)actual);
        actual = kb.getAnnotations(null, p2);
        Assert.assertNull((Object)actual);
        actual = kb.getAnnotations(s1, null);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void getAnnotations4() {
        PelletOptions.USE_ANNOTATION_SUPPORT = true;
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl s = ATermUtils.makeTermAppl((String)"s");
        ATermAppl p = ATermUtils.makeTermAppl((String)"p");
        ATermAppl o = ATermUtils.makeTermAppl((String)"o");
        kb.addIndividual(s);
        kb.addAnnotationProperty(p);
        Assert.assertTrue((boolean)kb.addAnnotation(s, p, o));
        Set actual = kb.getAnnotationProperties();
        HashSet<ATermAppl> expected = new HashSet<ATermAppl>();
        expected.add(p);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void getAnnotations5() {
        PelletOptions.USE_ANNOTATION_SUPPORT = true;
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl s = ATermUtils.makeTermAppl((String)"s");
        ATermAppl p = ATermUtils.makeTermAppl((String)"p");
        ATermAppl o = ATermUtils.makeTermAppl((String)"o");
        kb.addIndividual(s);
        kb.addAnnotationProperty(p);
        Assert.assertTrue((boolean)kb.addAnnotation(s, p, o));
        Set actual = kb.getProperties();
        HashSet<ATermAppl> expected = new HashSet<ATermAppl>();
        expected.add(p);
        expected.add(ATermUtils.TOP_OBJECT_PROPERTY);
        expected.add(ATermUtils.BOTTOM_OBJECT_PROPERTY);
        expected.add(ATermUtils.TOP_DATA_PROPERTY);
        expected.add(ATermUtils.BOTTOM_DATA_PROPERTY);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void getAnnotations6() {
        PelletOptions.USE_ANNOTATION_SUPPORT = true;
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl s = ATermUtils.makeTermAppl((String)"s");
        ATermAppl p = ATermUtils.makeTermAppl((String)"p");
        ATermAppl o = ATermUtils.makeTermAppl((String)"o");
        kb.addIndividual(s);
        kb.addAnnotationProperty(p);
        Assert.assertTrue((boolean)kb.addAnnotation(s, p, o));
        Set actual = kb.getIndividualsWithAnnotation(p, o);
        HashSet<ATermAppl> expected = new HashSet<ATermAppl>();
        expected.add(s);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testJenaLoader1() {
        PelletOptions.USE_ANNOTATION_SUPPORT = true;
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        Resource s = ResourceFactory.createResource((String)"i");
        Property p = RDFS.label;
        Literal o = ResourceFactory.createPlainLiteral((String)"o");
        model.add(s, p, (RDFNode)o);
        model.prepare();
        ATermAppl st = ATermUtils.makeTermAppl((String)"i");
        ATermAppl pt = ATermUtils.makeTermAppl((String)RDFS.label.getURI());
        ATermAppl ot = ATermUtils.makePlainLiteral((String)"o");
        KnowledgeBase kb = ((PelletInfGraph)model.getGraph()).getKB();
        Set actual = kb.getAnnotations(st, pt);
        HashSet<ATermAppl> expected = new HashSet<ATermAppl>();
        expected.add(ot);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testJenaLoader2() {
        PelletOptions.USE_ANNOTATION_SUPPORT = true;
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        Resource s1 = ResourceFactory.createResource((String)"i");
        Property p1 = RDFS.label;
        Literal o1 = ResourceFactory.createPlainLiteral((String)"o1");
        Property p2 = RDFS.comment;
        Literal o2 = ResourceFactory.createPlainLiteral((String)"o2");
        model.add(s1, p1, (RDFNode)o1);
        model.add(s1, p2, (RDFNode)o2);
        model.prepare();
        ATermAppl st = ATermUtils.makeTermAppl((String)"i");
        KnowledgeBase kb = ((PelletInfGraph)model.getGraph()).getKB();
        Set actual = kb.getAnnotations(st, null);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testJenaLoader3() {
        PelletOptions.USE_ANNOTATION_SUPPORT = true;
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(DATA1_TTL, "N3");
        model.prepare();
        ATermAppl i = ATermUtils.makeTermAppl((String)"http://example.org#i");
        ATermAppl label = ATermUtils.makeTermAppl((String)RDFS.label.getURI());
        ATermAppl o1 = ATermUtils.makePlainLiteral((String)"o1");
        KnowledgeBase kb = ((PelletInfGraph)model.getGraph()).getKB();
        Set actual = kb.getAnnotations(i, label);
        HashSet<ATermAppl> expected = new HashSet<ATermAppl>();
        expected.add(o1);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testOWLAPILoader() throws OWLOntologyCreationException {
        PelletOptions.USE_ANNOTATION_SUPPORT = true;
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ontology = manager.loadOntology(URI.create(DATA1_RDF));
        Reasoner reasoner = new Reasoner(manager);
        reasoner.loadOntology(ontology);
        KnowledgeBase kb = reasoner.getKB();
        ATermAppl i = ATermUtils.makeTermAppl((String)"http://example.org#i");
        ATermAppl label = ATermUtils.makeTermAppl((String)RDFS.label.getURI());
        ATermAppl o1 = ATermUtils.makePlainLiteral((String)"o1");
        Set actual = kb.getAnnotations(i, label);
        HashSet<ATermAppl> expected = new HashSet<ATermAppl>();
        expected.add(o1);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testCombinedQueryEngine() {
        PelletOptions.USE_ANNOTATION_SUPPORT = true;
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(DATA1_RDF);
        Query query = QueryFactory.read((String)QUERY1_RQ);
        QueryExecution qe = SparqlDLExecutionFactory.create((Query)query, (Model)model);
        ResultSet rs = qe.execSelect();
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            Resource s = qs.getResource("s");
            Literal o = qs.getLiteral("o");
            Assert.assertEquals((Object)"http://example.org#i", (Object)s.getURI());
            Assert.assertEquals((Object)"o2", (Object)o.getLexicalForm());
        }
    }
}

