/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.utils.TermFactory;
import com.hp.hpl.jena.vocabulary.XSD;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.datatypes.XSDInteger;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.utils.ATermUtils;

public class TracingTests {
    private ATermAppl bob = ATermUtils.makeTermAppl((String)"Bob");
    private ATermAppl robert = ATermUtils.makeTermAppl((String)"Robert");
    private ATermAppl mary = ATermUtils.makeTermAppl((String)"Mary");
    private ATermAppl victor = ATermUtils.makeTermAppl((String)"Victor");
    private ATermAppl email = ATermUtils.makeTermAppl((String)"MaryAndBob@example.com");
    private ATermAppl mbox = ATermUtils.makeTermAppl((String)"mbox");
    private ATermAppl relative = ATermUtils.makeTermAppl((String)"relative");
    private ATermAppl sibling = ATermUtils.makeTermAppl((String)"sibling");
    private ATermAppl person = ATermUtils.makeTermAppl((String)"person");
    private ATermAppl human = ATermUtils.makeTermAppl((String)"human");
    private ATermAppl ssn = ATermUtils.makeTermAppl((String)"ssn");
    private KnowledgeBase kb;
    private boolean old_USE_TRACING;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TracingTests.class);
    }

    @Before
    public void setUp() {
        this.old_USE_TRACING = PelletOptions.USE_TRACING;
        PelletOptions.USE_TRACING = true;
        this.kb = new KnowledgeBase();
        this.kb.setDoExplanation(true);
    }

    @After
    public void tearDown() {
        PelletOptions.USE_TRACING = this.old_USE_TRACING;
    }

    @Test
    public void testAsymmetric() {
        this.kb.addObjectProperty((ATerm)this.mbox);
        this.kb.addAsymmetricProperty(this.mbox);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.email);
        this.kb.addPropertyValue(this.mbox, this.robert, this.email);
        this.kb.addPropertyValue(this.mbox, this.email, this.robert);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeAsymmetric((ATerm)this.mbox), ATermUtils.makePropAtom((ATermAppl)this.mbox, (ATermAppl)this.robert, (ATermAppl)this.email), ATermUtils.makePropAtom((ATermAppl)this.mbox, (ATermAppl)this.email, (ATermAppl)this.robert)});
    }

    @Ignore(value="Known to fail, see ticket #47")
    @Test
    public void testBottomSatisfiable() {
        this.kb.addClass(this.human);
        Assert.assertFalse((boolean)this.kb.isSatisfiable(ATermUtils.makeAnd((ATerm)ATermUtils.makeNot((ATerm)this.human), (ATerm)ATermUtils.BOTTOM)));
        Set explanation = this.kb.getExplanationSet();
    }

    @Test
    public void testCourse() {
        ATermAppl Course = TermFactory.term((String)"Person");
        ATermAppl Person = TermFactory.term((String)"Course");
        ATermAppl Man = TermFactory.term((String)"Man");
        ATermAppl Woman = TermFactory.term((String)"Woman");
        ATermAppl isTaughtBy = TermFactory.term((String)"isTaughtBy");
        ATermAppl M1 = TermFactory.term((String)"M1");
        ATermAppl W1 = TermFactory.term((String)"W1");
        ATermAppl C1 = TermFactory.term((String)"C1");
        ATermAppl P1 = TermFactory.term((String)"P1");
        ATermAppl C2 = TermFactory.term((String)"C2");
        this.kb.addClass(Course);
        this.kb.addClass(Person);
        this.kb.addClass(Man);
        this.kb.addClass(Woman);
        this.kb.addDisjointClass(Man, Woman);
        this.kb.addObjectProperty((ATerm)isTaughtBy);
        this.kb.addFunctionalProperty(isTaughtBy);
        this.kb.addIndividual(C1);
        this.kb.addIndividual(P1);
        this.kb.addIndividual(M1);
        this.kb.addIndividual(M1);
        this.kb.addIndividual(W1);
        this.kb.addIndividual(C2);
        this.kb.addType(C1, Course);
        this.kb.addPropertyValue(isTaughtBy, C1, M1);
        this.kb.addPropertyValue(isTaughtBy, C1, P1);
        this.kb.addType(C2, Course);
        this.kb.addPropertyValue(isTaughtBy, C2, W1);
        this.kb.addPropertyValue(isTaughtBy, C2, P1);
        this.kb.addType(M1, Man);
        this.kb.addType(W1, Woman);
        this.kb.addType(P1, Person);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        Assert.assertTrue((boolean)explanation.remove(ATermUtils.makeTypeAtom((ATermAppl)M1, (ATermAppl)Man)));
        Assert.assertTrue((boolean)explanation.remove(ATermUtils.makePropAtom((ATermAppl)isTaughtBy, (ATermAppl)C1, (ATermAppl)M1)));
        Assert.assertTrue((boolean)explanation.remove(ATermUtils.makePropAtom((ATermAppl)isTaughtBy, (ATermAppl)C1, (ATermAppl)P1)));
        Assert.assertTrue((boolean)explanation.remove(ATermUtils.makeTypeAtom((ATermAppl)W1, (ATermAppl)Woman)));
        Assert.assertTrue((boolean)explanation.remove(ATermUtils.makePropAtom((ATermAppl)isTaughtBy, (ATermAppl)C2, (ATermAppl)W1)));
        Assert.assertTrue((boolean)explanation.remove(ATermUtils.makePropAtom((ATermAppl)isTaughtBy, (ATermAppl)C2, (ATermAppl)P1)));
        Assert.assertTrue((boolean)explanation.remove(ATermUtils.makeFunctional((ATerm)isTaughtBy)));
        Assert.assertTrue((boolean)explanation.remove(ATermUtils.makeDisjoint((ATerm)Man, (ATerm)Woman)));
        Assert.assertTrue((explanation.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDatatypeStatement() {
        this.kb.addDatatypeProperty((ATerm)this.ssn);
        this.kb.addIndividual(this.robert);
        ATermAppl ssn1 = ATermUtils.makeTypedLiteral((String)"bob", (String)XSD.nonNegativeInteger.toString());
        this.kb.addPropertyValue(this.ssn, this.robert, ssn1);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        Assert.assertTrue((boolean)explanation.contains(ATermUtils.makePropAtom((ATermAppl)this.ssn, (ATermAppl)this.robert, (ATermAppl)ssn1)));
    }

    @Test
    public void testDisjunction() {
        ATermAppl name = ATermUtils.makeTermAppl((String)"name");
        ATermAppl hasName = ATermUtils.makeTermAppl((String)"hasName");
        ATermAppl nameOf = ATermUtils.makeTermAppl((String)"nameOf");
        ATermAppl dog = ATermUtils.makeTermAppl((String)"dog");
        ATermAppl ownsAnimal = ATermUtils.makeTermAppl((String)"ownsAnimal");
        ATermAppl notPerson = ATermUtils.negate((ATermAppl)this.person);
        ATermAppl animal = ATermUtils.makeTermAppl((String)"animal");
        this.kb.addClass(notPerson);
        this.kb.addClass(this.person);
        this.kb.addClass(dog);
        this.kb.addClass(name);
        this.kb.addObjectProperty((ATerm)ownsAnimal);
        this.kb.addObjectProperty((ATerm)hasName);
        this.kb.addObjectProperty((ATerm)nameOf);
        this.kb.addInverseProperty(hasName, nameOf);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addIndividual(this.mary);
        this.kb.addPropertyValue(ownsAnimal, this.robert, this.victor);
        this.kb.addPropertyValue(ownsAnimal, this.mary, this.victor);
        ATermAppl existsHasName = ATermUtils.makeSomeValues((ATerm)hasName, (ATerm)name);
        this.kb.addClass(existsHasName);
        this.kb.addSubClass(dog, existsHasName);
        ATermAppl onlyOwnsDogs = ATermUtils.makeAllValues((ATerm)ownsAnimal, (ATerm)dog);
        ATermAppl allNameOfDog = ATermUtils.makeAllValues((ATerm)nameOf, (ATerm)dog);
        this.kb.addClass(allNameOfDog);
        this.kb.addSubClass(name, allNameOfDog);
        ATermAppl notPersonOronlyOwnsDog = ATermUtils.makeOr((ATermAppl)notPerson, (ATermAppl)onlyOwnsDogs);
        this.kb.addSubClass(animal, notPersonOronlyOwnsDog);
        this.kb.addType(this.robert, notPersonOronlyOwnsDog);
        this.kb.addType(this.robert, this.person);
        this.kb.addType(this.mary, notPersonOronlyOwnsDog);
        this.kb.addType(this.mary, this.person);
        this.kb.isConsistent();
        Assert.assertTrue((this.kb.getABox().getIndividual((ATerm)this.victor).getDepends((ATerm)dog).getExplain().size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testDomain() {
        ATermAppl notPerson = ATermUtils.makeNot((ATerm)this.person);
        this.kb.addClass(this.person);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addDomain((ATerm)this.sibling, this.person);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addType(this.robert, notPerson);
        this.kb.addPropertyValue(this.sibling, this.robert, this.victor);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeDomain((ATerm)this.sibling, (ATerm)this.person), ATermUtils.makeTypeAtom((ATermAppl)this.robert, (ATermAppl)notPerson), ATermUtils.makePropAtom((ATermAppl)this.sibling, (ATermAppl)this.robert, (ATermAppl)this.victor)});
    }

    @Test
    public void testDomainRangeInverse() {
        ATermAppl notPerson = ATermUtils.makeNot((ATerm)this.person);
        ATermAppl dog = ATermUtils.makeTermAppl((String)"dog");
        this.kb.addClass(dog);
        this.kb.addClass(this.person);
        this.kb.addEquivalentClass(dog, notPerson);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addDomain((ATerm)this.sibling, this.person);
        this.kb.addRange((ATerm)this.sibling, notPerson);
        this.kb.addInverseProperty(this.sibling, this.sibling);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addPropertyValue(this.sibling, this.robert, this.victor);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeDomain((ATerm)this.sibling, (ATerm)this.person), ATermUtils.makeRange((ATerm)this.sibling, (ATerm)notPerson), ATermUtils.makeInvProp((ATerm)this.sibling, (ATerm)this.sibling), ATermUtils.makePropAtom((ATermAppl)this.sibling, (ATermAppl)this.robert, (ATermAppl)this.victor)});
    }

    @Test
    public void testDomainRangeSymmetric() {
        ATermAppl notPerson = ATermUtils.makeNot((ATerm)this.person);
        ATermAppl dog = ATermUtils.makeTermAppl((String)"dog");
        this.kb.addClass(dog);
        this.kb.addClass(this.person);
        this.kb.addEquivalentClass(dog, notPerson);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addDomain((ATerm)this.sibling, this.person);
        this.kb.addRange((ATerm)this.sibling, notPerson);
        this.kb.addSymmetricProperty(this.sibling);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addPropertyValue(this.sibling, this.robert, this.victor);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeDomain((ATerm)this.sibling, (ATerm)this.person), ATermUtils.makeRange((ATerm)this.sibling, (ATerm)notPerson), ATermUtils.makeSymmetric((ATerm)this.sibling), ATermUtils.makePropAtom((ATermAppl)this.sibling, (ATermAppl)this.robert, (ATermAppl)this.victor)});
    }

    @Test
    public void testEquivalentClass() {
        this.kb.addClass(this.person);
        this.kb.addClass(this.human);
        this.kb.addSubClass(this.human, this.person);
        this.kb.addSubClass(this.person, this.human);
        Assert.assertTrue((boolean)this.kb.isEquivalentClass(this.human, this.person));
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeSub((ATerm)this.human, (ATerm)this.person), ATermUtils.makeSub((ATerm)this.person, (ATerm)this.human)});
    }

    @Test
    public void testFunctionalDataProp2() {
        this.kb.addDatatypeProperty((ATerm)this.ssn);
        this.kb.addFunctionalProperty(this.ssn);
        this.kb.addIndividual(this.robert);
        ATermAppl ssn1 = ATermUtils.makePlainLiteral((String)"012345678");
        ATermAppl ssn2 = ATermUtils.makePlainLiteral((String)"123456789");
        this.kb.addPropertyValue(this.ssn, this.robert, ssn1);
        this.kb.addPropertyValue(this.ssn, this.robert, ssn2);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makePropAtom((ATermAppl)this.ssn, (ATermAppl)this.robert, (ATermAppl)ssn1), ATermUtils.makePropAtom((ATermAppl)this.ssn, (ATermAppl)this.robert, (ATermAppl)ssn2), ATermUtils.makeFunctional((ATerm)this.ssn)});
        Assert.assertTrue((explanation.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testFunctionalDataProp1() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = XSDInteger.instance.getName();
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.typedLiteral((String)"012345678", (String)XSDInteger.instance.getURI());
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addDatatypeProperty((ATerm)p);
        this.kb.addIndividual(a);
        this.kb.addEquivalentClass(C, TermFactory.all((ATermAppl)p, (ATermAppl)D));
        this.kb.addFunctionalProperty(p);
        this.kb.addPropertyValue(p, a, b);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(a, C));
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeEqClasses((ATerm)C, (ATerm)TermFactory.all((ATermAppl)p, (ATermAppl)D)), ATermUtils.makeFunctional((ATerm)p), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)a, (ATermAppl)b)});
    }

    @Test
    public void testFunctionalObjectProp1() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addEquivalentClass(C, TermFactory.all((ATermAppl)p, (ATermAppl)D));
        this.kb.addFunctionalProperty(p);
        this.kb.addPropertyValue(p, a, b);
        this.kb.addType(b, D);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(a, C));
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeEqClasses((ATerm)C, (ATerm)TermFactory.all((ATermAppl)p, (ATermAppl)D)), ATermUtils.makeFunctional((ATerm)p), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)a, (ATermAppl)b), ATermUtils.makeTypeAtom((ATermAppl)b, (ATermAppl)D)});
    }

    @Test
    public void testInverseFunctionalDataProp() {
        ATermList different = ATermUtils.makeList((ATerm)this.robert).insert((ATerm)this.mary);
        System.out.println("Different: " + different);
        this.kb.addObjectProperty((ATerm)this.mbox);
        this.kb.addInverseFunctionalProperty((ATerm)this.mbox);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.email);
        this.kb.addAllDifferent(different);
        this.kb.addPropertyValue(this.mbox, this.robert, this.email);
        this.kb.addPropertyValue(this.mbox, this.mary, this.email);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makePropAtom((ATermAppl)this.mbox, (ATermAppl)this.robert, (ATermAppl)this.email), ATermUtils.makePropAtom((ATermAppl)this.mbox, (ATermAppl)this.mary, (ATermAppl)this.email), ATermUtils.makeInverseFunctional((ATerm)this.mbox), ATermUtils.makeAllDifferent((ATermList)different)});
    }

    @Test
    public void testIrreflexive() {
        this.kb.addObjectProperty((ATerm)this.mbox);
        this.kb.addIrreflexiveProperty(this.mbox);
        this.kb.addIndividual(this.robert);
        this.kb.addPropertyValue(this.mbox, this.robert, this.robert);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeIrreflexive((ATerm)this.mbox), ATermUtils.makePropAtom((ATermAppl)this.mbox, (ATermAppl)this.robert, (ATermAppl)this.robert)});
    }

    @Test
    public void testMaxOneDataProp() {
        this.kb.addClass(this.person);
        this.kb.addDatatypeProperty((ATerm)this.ssn);
        ATermAppl max1ssn = ATermUtils.makeMax((ATerm)this.ssn, (int)1, (ATerm)ATermUtils.TOP_LIT);
        this.kb.addSubClass(this.person, max1ssn);
        this.kb.addSubClass(this.person, ATermUtils.makeMin((ATerm)this.ssn, (int)1, (ATerm)ATermUtils.TOP_LIT));
        this.kb.addIndividual(this.robert);
        this.kb.addType(this.robert, this.person);
        ATermAppl ssn1 = ATermUtils.makePlainLiteral((String)"012345678");
        ATermAppl ssn2 = ATermUtils.makePlainLiteral((String)"123456789");
        this.kb.addPropertyValue(this.ssn, this.robert, ssn1);
        this.kb.addPropertyValue(this.ssn, this.robert, ssn2);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makePropAtom((ATermAppl)this.ssn, (ATermAppl)this.robert, (ATermAppl)ssn1), ATermUtils.makePropAtom((ATermAppl)this.ssn, (ATermAppl)this.robert, (ATermAppl)ssn2), ATermUtils.makeSub((ATerm)this.person, (ATerm)max1ssn), ATermUtils.makeTypeAtom((ATermAppl)this.robert, (ATermAppl)this.person)});
    }

    @Test
    public void testRange() {
        ATermAppl notPerson = ATermUtils.makeNot((ATerm)this.person);
        this.kb.addClass(this.person);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addRange((ATerm)this.sibling, this.person);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.victor);
        this.kb.addType(this.victor, notPerson);
        this.kb.addPropertyValue(this.sibling, this.robert, this.victor);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeRange((ATerm)this.sibling, (ATerm)this.person), ATermUtils.makeTypeAtom((ATermAppl)this.victor, (ATermAppl)notPerson), ATermUtils.makePropAtom((ATermAppl)this.sibling, (ATermAppl)this.robert, (ATermAppl)this.victor)});
    }

    @Test
    public void testReflexive() {
        ATermAppl notPerson = ATermUtils.makeNot((ATerm)this.person);
        ATermAppl bobsType = ATermUtils.makeAllValues((ATerm)this.relative, (ATerm)notPerson);
        this.kb.addClass(this.person);
        this.kb.addObjectProperty((ATerm)this.relative);
        this.kb.addReflexiveProperty(this.relative);
        this.kb.addIndividual(this.robert);
        this.kb.addType(this.robert, this.person);
        this.kb.addType(this.robert, bobsType);
        this.kb.addIndividual(this.victor);
        this.kb.addType(this.victor, notPerson);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeReflexive((ATerm)this.relative), ATermUtils.makeTypeAtom((ATermAppl)this.robert, (ATermAppl)this.person), ATermUtils.makeTypeAtom((ATermAppl)this.robert, (ATermAppl)bobsType)});
    }

    @Test
    public void testSameAllDifferent() {
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.bob);
        this.kb.addIndividual(this.mary);
        ATermList list = ATermUtils.makeList((ATerm)this.robert);
        list = ATermUtils.makeList((ATerm)this.bob, (ATermList)list);
        list = ATermUtils.makeList((ATerm)this.mary, (ATermList)list);
        this.kb.addAllDifferent(list);
        this.kb.addSame(this.robert, this.bob);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        Assert.assertTrue((boolean)explanation.contains(ATermUtils.makeSameAs((ATerm)this.robert, (ATerm)this.bob)));
        Assert.assertTrue((boolean)explanation.contains(ATermUtils.makeAllDifferent((ATermList)list)));
        Assert.assertTrue((explanation.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testSameDifferent() {
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.bob);
        this.kb.addSame(this.robert, this.bob);
        this.kb.addDifferent(this.robert, this.bob);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        Assert.assertTrue((boolean)explanation.contains(ATermUtils.makeSameAs((ATerm)this.robert, (ATerm)this.bob)));
        Assert.assertTrue((boolean)explanation.contains(ATermUtils.makeDifferent((ATerm)this.robert, (ATerm)this.bob)));
        Assert.assertTrue((explanation.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testSubProp1() {
        ATermAppl noRelatives = ATermUtils.makeMax((ATerm)this.relative, (int)0, (ATerm)ATermUtils.TOP);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.bob);
        this.kb.addObjectProperty((ATerm)this.relative);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addSubProperty((ATerm)this.sibling, this.relative);
        this.kb.addType(this.bob, noRelatives);
        this.kb.addPropertyValue(this.sibling, this.bob, this.mary);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeSubProp((ATerm)this.sibling, (ATerm)this.relative), ATermUtils.makePropAtom((ATermAppl)this.sibling, (ATermAppl)this.bob, (ATermAppl)this.mary), ATermUtils.makeTypeAtom((ATermAppl)this.bob, (ATermAppl)noRelatives)});
    }

    @Test
    public void testSubProp2() {
        ATermAppl nonHumanRelatives = ATermUtils.makeAllValues((ATerm)this.relative, (ATerm)ATermUtils.makeNot((ATerm)this.person));
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.bob);
        this.kb.addObjectProperty((ATerm)this.relative);
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addSubProperty((ATerm)this.sibling, this.relative);
        this.kb.addType(this.bob, nonHumanRelatives);
        this.kb.addType(this.mary, this.person);
        this.kb.addPropertyValue(this.sibling, this.bob, this.mary);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeSubProp((ATerm)this.sibling, (ATerm)this.relative), ATermUtils.makePropAtom((ATermAppl)this.sibling, (ATermAppl)this.bob, (ATermAppl)this.mary), ATermUtils.makeTypeAtom((ATermAppl)this.bob, (ATermAppl)nonHumanRelatives), ATermUtils.makeTypeAtom((ATermAppl)this.mary, (ATermAppl)this.person)});
    }

    @Test
    public void testTopBottom() {
        this.kb = new KnowledgeBase();
        this.kb.addSubClass(ATermUtils.TOP, ATermUtils.BOTTOM);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeSub((ATerm)ATermUtils.TOP, (ATerm)ATermUtils.BOTTOM)});
    }

    @Test
    public void testTransitive() {
        this.kb.addObjectProperty((ATerm)this.sibling);
        this.kb.addTransitiveProperty(this.sibling);
        this.kb.addIndividual(this.robert);
        this.kb.addIndividual(this.mary);
        this.kb.addIndividual(this.victor);
        ATermAppl notVictorsSibling = ATermUtils.makeNot((ATerm)ATermUtils.makeHasValue((ATerm)this.sibling, (ATerm)this.victor));
        this.kb.addType(this.robert, notVictorsSibling);
        this.kb.addPropertyValue(this.sibling, this.robert, this.mary);
        this.kb.addPropertyValue(this.sibling, this.mary, this.victor);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeTypeAtom((ATermAppl)this.robert, (ATermAppl)notVictorsSibling), ATermUtils.makeTransitive((ATerm)this.sibling), ATermUtils.makePropAtom((ATermAppl)this.sibling, (ATermAppl)this.robert, (ATermAppl)this.mary), ATermUtils.makePropAtom((ATermAppl)this.sibling, (ATermAppl)this.mary, (ATermAppl)this.victor)});
    }

    @Test
    public void testRuleExplanation() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = ATermUtils.makeTermAppl((String)"C");
        ATermAppl D = ATermUtils.makeTermAppl((String)"D");
        ATermAppl i = ATermUtils.makeTermAppl((String)"i");
        ArrayList<ClassAtom> body = new ArrayList<ClassAtom>();
        ArrayList<ClassAtom> head = new ArrayList<ClassAtom>();
        body.add(new ClassAtom(C, (AtomIObject)new AtomIVariable("x")));
        head.add(new ClassAtom(D, (AtomIObject)new AtomIVariable("x")));
        Rule rule = new Rule(head, body);
        kb.addClass(C);
        kb.addClass(D);
        kb.addIndividual(i);
        kb.addType(i, C);
        kb.addRule(rule);
        kb.setDoExplanation(true);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isType(i, D));
        Set actual = kb.getExplanationSet();
        kb.setDoExplanation(false);
        HashSet<ATermAppl> expected = new HashSet<ATermAppl>();
        ATermAppl x = ATermUtils.makeVar((String)"x");
        ATermAppl[] b = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)x, (ATermAppl)C)};
        ATermAppl[] h = new ATermAppl[]{ATermUtils.makeTypeAtom((ATermAppl)x, (ATermAppl)D)};
        expected.add(ATermUtils.makeTypeAtom((ATermAppl)i, (ATermAppl)C));
        expected.add(ATermUtils.makeRule((ATermAppl[])h, (ATermAppl[])b));
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testInverseCardinality1() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl invP = TermFactory.term((String)"invP");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        this.kb.addClass(C);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addObjectProperty((ATerm)invP);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addSubClass(C, TermFactory.max((ATermAppl)invP, (int)0, (ATermAppl)TermFactory.TOP));
        this.kb.addInverseProperty(p, invP);
        this.kb.addPropertyValue(p, b, a);
        this.kb.addType(a, C);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeSub((ATerm)C, (ATerm)TermFactory.max((ATermAppl)invP, (int)0, (ATermAppl)TermFactory.TOP)), ATermUtils.makeInvProp((ATerm)p, (ATerm)invP), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)b, (ATermAppl)a), ATermUtils.makeTypeAtom((ATermAppl)a, (ATermAppl)C)});
    }

    @Test
    public void testInverseCardinality2() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl invP = TermFactory.term((String)"invP");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermList inds = ATermUtils.makeList((ATerm[])new ATerm[]{a, b, c});
        this.kb.addClass(C);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addObjectProperty((ATerm)invP);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addIndividual(c);
        this.kb.addSubClass(C, TermFactory.max((ATermAppl)invP, (int)1, (ATermAppl)TermFactory.TOP));
        this.kb.addInverseProperty(p, invP);
        this.kb.addPropertyValue(p, b, a);
        this.kb.addPropertyValue(p, c, a);
        this.kb.addType(a, C);
        this.kb.addAllDifferent(inds);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeSub((ATerm)C, (ATerm)TermFactory.max((ATermAppl)invP, (int)1, (ATermAppl)TermFactory.TOP)), ATermUtils.makeInvProp((ATerm)p, (ATerm)invP), ATermUtils.makeAllDifferent((ATermList)inds), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)b, (ATermAppl)a), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)c, (ATermAppl)a), ATermUtils.makeTypeAtom((ATermAppl)a, (ATermAppl)C)});
    }

    @Test
    public void testInverseCardinality3() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl invP = TermFactory.term((String)"invP");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl d = TermFactory.term((String)"d");
        ATermList inds = ATermUtils.makeList((ATerm[])new ATerm[]{a, b, c, d});
        this.kb.addClass(C);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addObjectProperty((ATerm)invP);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addIndividual(c);
        this.kb.addIndividual(d);
        this.kb.addSubClass(C, TermFactory.max((ATermAppl)invP, (int)2, (ATermAppl)TermFactory.TOP));
        this.kb.addInverseProperty(p, invP);
        this.kb.addPropertyValue(p, b, a);
        this.kb.addPropertyValue(p, c, a);
        this.kb.addPropertyValue(p, d, a);
        this.kb.addType(a, C);
        this.kb.addAllDifferent(inds);
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeSub((ATerm)C, (ATerm)TermFactory.max((ATermAppl)invP, (int)2, (ATermAppl)TermFactory.TOP)), ATermUtils.makeInvProp((ATerm)p, (ATerm)invP), ATermUtils.makeAllDifferent((ATermList)inds), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)b, (ATermAppl)a), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)c, (ATermAppl)a), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)d, (ATermAppl)a), ATermUtils.makeTypeAtom((ATermAppl)a, (ATermAppl)C)});
    }

    @Test
    public void testInverseAllValues1() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl invP = TermFactory.term((String)"invP");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addObjectProperty((ATerm)invP);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addSubClass(C, TermFactory.all((ATermAppl)invP, (ATermAppl)D));
        this.kb.addInverseProperty(p, invP);
        this.kb.addPropertyValue(p, b, a);
        this.kb.addType(a, C);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isType(b, D));
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeSub((ATerm)C, (ATerm)TermFactory.all((ATermAppl)invP, (ATermAppl)D)), ATermUtils.makeInvProp((ATerm)p, (ATerm)invP), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)b, (ATermAppl)a), ATermUtils.makeTypeAtom((ATermAppl)a, (ATermAppl)C)});
    }

    @Test
    public void testInverseAllValues2() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl invP = TermFactory.term((String)"invP");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        this.kb.addClass(C);
        this.kb.addClass(D);
        this.kb.addObjectProperty((ATerm)p);
        this.kb.addObjectProperty((ATerm)invP);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addIndividual(c);
        this.kb.addSubClass(C, TermFactory.all((ATermAppl)invP, (ATermAppl)D));
        this.kb.addTransitiveProperty(p);
        this.kb.addInverseProperty(p, invP);
        this.kb.addPropertyValue(p, a, b);
        this.kb.addPropertyValue(p, b, c);
        this.kb.addType(c, C);
        this.kb.addType(a, TermFactory.not((ATermAppl)D));
        Assert.assertFalse((boolean)this.kb.isConsistent());
        Set explanation = this.kb.getExplanationSet();
        PelletTestCase.assertIteratorValues(explanation.iterator(), new Object[]{ATermUtils.makeSub((ATerm)C, (ATerm)TermFactory.all((ATermAppl)invP, (ATermAppl)D)), ATermUtils.makeTransitive((ATerm)p), ATermUtils.makeInvProp((ATerm)p, (ATerm)invP), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)a, (ATermAppl)b), ATermUtils.makePropAtom((ATermAppl)p, (ATermAppl)b, (ATermAppl)c), ATermUtils.makeTypeAtom((ATermAppl)a, (ATermAppl)TermFactory.not((ATermAppl)D)), ATermUtils.makeTypeAtom((ATermAppl)c, (ATermAppl)C)});
    }
}

