/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.rules;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import com.clarkparsia.pellet.rules.rete.AlphaNode;
import com.clarkparsia.pellet.rules.rete.BetaNode;
import com.clarkparsia.pellet.rules.rete.Node;
import com.clarkparsia.pellet.rules.rete.TermTuple;
import com.clarkparsia.pellet.utils.TermFactory;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.JUnit4TestAdapter;
import org.junit.Assert;
import org.junit.Test;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.owlapi.Reasoner;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.test.PelletTestSuite;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyManager;

public class MiscRuleTests {
    public static final String base = "file:" + PelletTestSuite.base + "swrl-test/misc/";
    private static final URI luigiFamily = URI.create("http://www.csc.liv.ac.uk/~luigi/ontologies/basicFamily");

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(MiscRuleTests.class);
    }

    private void nonTrivialBuiltInTest() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl d1 = TermFactory.typedLiteral((String)"1", (String)"http://www.w3.org/2001/XMLSchema#int");
        ATermAppl d2 = TermFactory.typedLiteral((String)"2", (String)"http://www.w3.org/2001/XMLSchema#int");
        ATermAppl d12 = TermFactory.typedLiteral((String)"3", (String)"http://www.w3.org/2001/XMLSchema#integer");
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl r = TermFactory.term((String)"r");
        kb.addDatatypeProperty((ATerm)p);
        kb.addDatatypeProperty((ATerm)q);
        kb.addDatatypeProperty((ATerm)r);
        kb.addIndividual(i);
        kb.addSubClass(TermFactory.TOP, TermFactory.hasValue((ATermAppl)p, (ATermAppl)d1));
        kb.addSubClass(TermFactory.TOP, TermFactory.hasValue((ATermAppl)q, (ATermAppl)d2));
        AtomIVariable x = new AtomIVariable("x");
        AtomDVariable z1 = new AtomDVariable("z1");
        AtomDVariable z2 = new AtomDVariable("z2");
        AtomDVariable z3 = new AtomDVariable("z3");
        ArrayList<Object> body = new ArrayList<Object>();
        body.add(new DatavaluedPropertyAtom(p, (AtomIObject)x, (AtomDObject)z1));
        body.add(new DatavaluedPropertyAtom(q, (AtomIObject)x, (AtomDObject)z2));
        body.add(new BuiltInAtom("http://www.w3.org/2003/11/swrlb#add", new AtomDObject[]{z3, z1, z2}));
        ArrayList<DatavaluedPropertyAtom> head = new ArrayList<DatavaluedPropertyAtom>();
        head.add(new DatavaluedPropertyAtom(r, (AtomIObject)x, (AtomDObject)z3));
        kb.addRule(new Rule(head, body));
        kb.realize();
        Assert.assertTrue((boolean)kb.hasPropertyValue(i, r, d12));
    }

    @Test
    public void betaNodeMarking() {
        TermTuple t = new TermTuple(DependencySet.INDEPENDENT, new ATermAppl[0]);
        AlphaNode a = new AlphaNode(t);
        BetaNode b1 = new BetaNode((Node)a, (Node)a, false);
        BetaNode b2 = new BetaNode((Node)a, (Node)a, false);
        BetaNode b3 = new BetaNode((Node)b1, (Node)b2, false);
        BetaNode b4 = new BetaNode((Node)b3, (Node)b3, false);
        Assert.assertTrue((boolean)b1.isDirty());
        Assert.assertTrue((boolean)b2.isDirty());
        Assert.assertTrue((boolean)b3.isDirty());
        Assert.assertTrue((boolean)b4.isDirty());
        b1.join();
        b2.join();
        b3.join();
        b4.join();
        Assert.assertFalse((boolean)b1.isDirty());
        Assert.assertFalse((boolean)b2.isDirty());
        Assert.assertFalse((boolean)b3.isDirty());
        Assert.assertFalse((boolean)b4.isDirty());
        a.markDirty();
        Assert.assertTrue((boolean)b1.isDirty());
        Assert.assertTrue((boolean)b2.isDirty());
        Assert.assertTrue((boolean)b3.isDirty());
        Assert.assertTrue((boolean)b4.isDirty());
    }

    @Test
    public void builtInDateTime() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl amy = TermFactory.term((String)"Amy");
        ATermAppl basil = TermFactory.term((String)"Basil");
        ATermAppl clara = TermFactory.term((String)"Clara");
        ATermAppl desmond = TermFactory.term((String)"Desmond");
        ATermAppl bDate = TermFactory.term((String)"bDate");
        ATermAppl bYear = TermFactory.term((String)"bYear");
        ATermAppl bMonth = TermFactory.term((String)"bMonth");
        ATermAppl bDay = TermFactory.term((String)"bDay");
        ATermAppl bTZ = TermFactory.term((String)"bTZ");
        kb.addDatatypeProperty((ATerm)bDate);
        kb.addDatatypeProperty((ATerm)bYear);
        kb.addDatatypeProperty((ATerm)bMonth);
        kb.addDatatypeProperty((ATerm)bDay);
        kb.addDatatypeProperty((ATerm)bTZ);
        kb.addIndividual(amy);
        kb.addPropertyValue(bDate, amy, TermFactory.typedLiteral((String)"2001-01-11", (String)"http://www.w3.org/2001/XMLSchema#date"));
        kb.addIndividual(basil);
        kb.addPropertyValue(bDate, basil, TermFactory.typedLiteral((String)"2002-02-12Z", (String)"http://www.w3.org/2001/XMLSchema#date"));
        kb.addIndividual(clara);
        kb.addPropertyValue(bYear, clara, TermFactory.typedLiteral((String)"2003", (String)"http://www.w3.org/2001/XMLSchema#integer"));
        kb.addPropertyValue(bMonth, clara, TermFactory.typedLiteral((String)"3", (String)"http://www.w3.org/2001/XMLSchema#integer"));
        kb.addPropertyValue(bDay, clara, TermFactory.typedLiteral((String)"13", (String)"http://www.w3.org/2001/XMLSchema#integer"));
        kb.addIndividual(desmond);
        kb.addPropertyValue(bYear, desmond, TermFactory.typedLiteral((String)"2004", (String)"http://www.w3.org/2001/XMLSchema#integer"));
        kb.addPropertyValue(bMonth, desmond, TermFactory.typedLiteral((String)"4", (String)"http://www.w3.org/2001/XMLSchema#integer"));
        kb.addPropertyValue(bDay, desmond, TermFactory.typedLiteral((String)"14", (String)"http://www.w3.org/2001/XMLSchema#integer"));
        kb.addPropertyValue(bTZ, desmond, TermFactory.literal((String)"+01:01"));
        AtomIVariable x = new AtomIVariable("x");
        AtomDVariable xDate = new AtomDVariable("xDate");
        AtomDVariable xYear = new AtomDVariable("xYear");
        AtomDVariable xMonth = new AtomDVariable("xMonth");
        AtomDVariable xDay = new AtomDVariable("xDay");
        AtomDVariable xTZ = new AtomDVariable("xTZ");
        BuiltInAtom dateBuiltIn = new BuiltInAtom("http://www.w3.org/2003/11/swrlb#date", new AtomDObject[]{xDate, xYear, xMonth, xDay});
        BuiltInAtom dateBuiltInTZ = new BuiltInAtom("http://www.w3.org/2003/11/swrlb#date", new AtomDObject[]{xDate, xYear, xMonth, xDay, xTZ});
        DatavaluedPropertyAtom bDateAtom = new DatavaluedPropertyAtom(bDate, (AtomIObject)x, (AtomDObject)xDate);
        DatavaluedPropertyAtom bYearAtom = new DatavaluedPropertyAtom(bYear, (AtomIObject)x, (AtomDObject)xYear);
        DatavaluedPropertyAtom bMonthAtom = new DatavaluedPropertyAtom(bMonth, (AtomIObject)x, (AtomDObject)xMonth);
        DatavaluedPropertyAtom bDayAtom = new DatavaluedPropertyAtom(bDay, (AtomIObject)x, (AtomDObject)xDay);
        DatavaluedPropertyAtom bTZAtom = new DatavaluedPropertyAtom(bTZ, (AtomIObject)x, (AtomDObject)xTZ);
        Rule fromDate = new Rule(Arrays.asList(bYearAtom, bMonthAtom, bDayAtom), Arrays.asList(dateBuiltIn, bDateAtom));
        kb.addRule(fromDate);
        Rule fromDateTZ = new Rule(Arrays.asList(bYearAtom, bMonthAtom, bDayAtom, bTZAtom), Arrays.asList(dateBuiltInTZ, bDateAtom));
        kb.addRule(fromDateTZ);
        Rule toDate = new Rule(Arrays.asList(bDateAtom), Arrays.asList(dateBuiltIn, bYearAtom, bMonthAtom, bDayAtom));
        kb.addRule(toDate);
        Rule toDateTZ = new Rule(Arrays.asList(bDateAtom), Arrays.asList(dateBuiltInTZ, bYearAtom, bMonthAtom, bDayAtom, bTZAtom));
        kb.addRule(toDateTZ);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.hasPropertyValue(amy, bYear, TermFactory.typedLiteral((String)"2001", (String)"http://www.w3.org/2001/XMLSchema#integer")));
        Assert.assertTrue((boolean)kb.hasPropertyValue(amy, bMonth, TermFactory.typedLiteral((String)"1", (String)"http://www.w3.org/2001/XMLSchema#integer")));
        Assert.assertTrue((boolean)kb.hasPropertyValue(amy, bDay, TermFactory.typedLiteral((String)"11", (String)"http://www.w3.org/2001/XMLSchema#integer")));
        Assert.assertTrue((boolean)kb.hasPropertyValue(basil, bYear, TermFactory.typedLiteral((String)"2002", (String)"http://www.w3.org/2001/XMLSchema#integer")));
        Assert.assertTrue((boolean)kb.hasPropertyValue(basil, bMonth, TermFactory.typedLiteral((String)"2", (String)"http://www.w3.org/2001/XMLSchema#integer")));
        Assert.assertTrue((boolean)kb.hasPropertyValue(basil, bDay, TermFactory.typedLiteral((String)"12", (String)"http://www.w3.org/2001/XMLSchema#integer")));
        Assert.assertTrue((boolean)kb.hasPropertyValue(basil, bTZ, TermFactory.literal((String)"Z")));
        Assert.assertTrue((boolean)kb.hasPropertyValue(clara, bDate, TermFactory.typedLiteral((String)"2003-03-13", (String)"http://www.w3.org/2001/XMLSchema#date")));
        Assert.assertTrue((boolean)kb.hasPropertyValue(desmond, bDate, TermFactory.typedLiteral((String)"2004-04-14+01:01", (String)"http://www.w3.org/2001/XMLSchema#date")));
    }

    @Test
    public void builtInMath() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl d1 = TermFactory.typedLiteral((String)"1", (String)"http://www.w3.org/2001/XMLSchema#int");
        ATermAppl d2 = TermFactory.typedLiteral((String)"1.5", (String)"http://www.w3.org/2001/XMLSchema#float");
        ATermAppl dif11 = TermFactory.typedLiteral((String)"0", (String)"http://www.w3.org/2001/XMLSchema#integer");
        ATermAppl dif12 = TermFactory.typedLiteral((String)"-0.5", (String)"http://www.w3.org/2001/XMLSchema#float");
        ATermAppl dif21 = TermFactory.typedLiteral((String)"0.5", (String)"http://www.w3.org/2001/XMLSchema#float");
        ATermAppl dif22 = TermFactory.typedLiteral((String)"0", (String)"http://www.w3.org/2001/XMLSchema#float");
        ATermAppl prod11 = TermFactory.typedLiteral((String)"1", (String)"http://www.w3.org/2001/XMLSchema#integer");
        ATermAppl prod12 = TermFactory.typedLiteral((String)"1.5", (String)"http://www.w3.org/2001/XMLSchema#float");
        ATermAppl prod22 = TermFactory.typedLiteral((String)"2.25", (String)"http://www.w3.org/2001/XMLSchema#float");
        ATermAppl quot11 = TermFactory.typedLiteral((String)"1", (String)"http://www.w3.org/2001/XMLSchema#decimal");
        ATermAppl quot12 = TermFactory.typedLiteral((String)Float.toString(0.6666667f), (String)"http://www.w3.org/2001/XMLSchema#float");
        ATermAppl quot21 = TermFactory.typedLiteral((String)"1.5", (String)"http://www.w3.org/2001/XMLSchema#float");
        ATermAppl quot22 = TermFactory.typedLiteral((String)"1", (String)"http://www.w3.org/2001/XMLSchema#float");
        ATermAppl sum11 = TermFactory.typedLiteral((String)"2", (String)"http://www.w3.org/2001/XMLSchema#integer");
        ATermAppl sum12 = TermFactory.typedLiteral((String)"2.5", (String)"http://www.w3.org/2001/XMLSchema#float");
        ATermAppl sum22 = TermFactory.typedLiteral((String)"3.0", (String)"http://www.w3.org/2001/XMLSchema#float");
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl sum = TermFactory.term((String)"sum");
        ATermAppl product = TermFactory.term((String)"product");
        ATermAppl difference = TermFactory.term((String)"difference");
        ATermAppl quotient = TermFactory.term((String)"quotient");
        kb.addDatatypeProperty((ATerm)p);
        kb.addDatatypeProperty((ATerm)sum);
        kb.addDatatypeProperty((ATerm)difference);
        kb.addDatatypeProperty((ATerm)product);
        kb.addDatatypeProperty((ATerm)quotient);
        kb.addIndividual(i);
        kb.addPropertyValue(p, i, d1);
        kb.addPropertyValue(p, i, d2);
        AtomIVariable x = new AtomIVariable("x");
        AtomDVariable z1 = new AtomDVariable("z1");
        AtomDVariable z2 = new AtomDVariable("z2");
        AtomDVariable z3 = new AtomDVariable("z3");
        AtomDVariable z4 = new AtomDVariable("z4");
        AtomDVariable z5 = new AtomDVariable("z5");
        AtomDVariable z6 = new AtomDVariable("z6");
        ArrayList<Object> body = new ArrayList<Object>();
        body.add(new DatavaluedPropertyAtom(p, (AtomIObject)x, (AtomDObject)z1));
        body.add(new DatavaluedPropertyAtom(p, (AtomIObject)x, (AtomDObject)z2));
        body.add(new BuiltInAtom("http://www.w3.org/2003/11/swrlb#add", new AtomDObject[]{z3, z1, z2}));
        body.add(new BuiltInAtom("http://www.w3.org/2003/11/swrlb#subtract", new AtomDObject[]{z4, z1, z2}));
        body.add(new BuiltInAtom("http://www.w3.org/2003/11/swrlb#multiply", new AtomDObject[]{z5, z1, z2}));
        body.add(new BuiltInAtom("http://www.w3.org/2003/11/swrlb#divide", new AtomDObject[]{z6, z1, z2}));
        ArrayList<DatavaluedPropertyAtom> head = new ArrayList<DatavaluedPropertyAtom>();
        head.add(new DatavaluedPropertyAtom(sum, (AtomIObject)x, (AtomDObject)z3));
        head.add(new DatavaluedPropertyAtom(difference, (AtomIObject)x, (AtomDObject)z4));
        head.add(new DatavaluedPropertyAtom(product, (AtomIObject)x, (AtomDObject)z5));
        head.add(new DatavaluedPropertyAtom(quotient, (AtomIObject)x, (AtomDObject)z6));
        Rule rule = new Rule(head, body);
        kb.addRule(rule);
        kb.realize();
        Assert.assertTrue((boolean)kb.hasPropertyValue(i, sum, sum11));
        Assert.assertTrue((boolean)kb.hasPropertyValue(i, sum, sum12));
        Assert.assertTrue((boolean)kb.hasPropertyValue(i, sum, sum22));
        Assert.assertTrue((boolean)kb.hasPropertyValue(i, difference, dif11));
        Assert.assertTrue((boolean)kb.hasPropertyValue(i, difference, dif12));
        Assert.assertTrue((boolean)kb.hasPropertyValue(i, difference, dif21));
        Assert.assertTrue((boolean)kb.hasPropertyValue(i, difference, dif22));
        Assert.assertTrue((boolean)kb.hasPropertyValue(i, product, prod11));
        Assert.assertTrue((boolean)kb.hasPropertyValue(i, product, prod12));
        Assert.assertTrue((boolean)kb.hasPropertyValue(i, product, prod22));
        Assert.assertTrue((boolean)kb.hasPropertyValue(i, quotient, quot11));
        Assert.assertTrue((boolean)kb.hasPropertyValue(i, quotient, quot12));
        Assert.assertTrue((boolean)kb.hasPropertyValue(i, quotient, quot21));
        Assert.assertTrue((boolean)kb.hasPropertyValue(i, quotient, quot22));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void builtInNonTrivialOldStrategy() {
        boolean whichStrategy = PelletOptions.USE_CONTINUOUS_RULES;
        PelletOptions.USE_CONTINUOUS_RULES = false;
        try {
            this.nonTrivialBuiltInTest();
        }
        finally {
            PelletOptions.USE_CONTINUOUS_RULES = whichStrategy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void builtInNonTrivialNewStrategy() {
        boolean whichStrategy = PelletOptions.USE_CONTINUOUS_RULES;
        PelletOptions.USE_CONTINUOUS_RULES = true;
        try {
            this.nonTrivialBuiltInTest();
        }
        finally {
            PelletOptions.USE_CONTINUOUS_RULES = whichStrategy;
        }
    }

    @Test
    public void dataPropertyChain1() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl d = TermFactory.literal((String)"d");
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl j = TermFactory.term((String)"j");
        ATermAppl k = TermFactory.term((String)"k");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl r = TermFactory.term((String)"r");
        kb.addDatatypeProperty((ATerm)p);
        kb.addObjectProperty((ATerm)r);
        kb.addIndividual(i);
        kb.addIndividual(j);
        kb.addIndividual(k);
        kb.addPropertyValue(p, i, d);
        kb.addPropertyValue(r, i, j);
        kb.addPropertyValue(r, j, k);
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        AtomDVariable z = new AtomDVariable("z");
        IndividualPropertyAtom body1 = new IndividualPropertyAtom(r, (AtomIObject)x, (AtomIObject)y);
        DatavaluedPropertyAtom body2 = new DatavaluedPropertyAtom(p, (AtomIObject)x, (AtomDObject)z);
        DatavaluedPropertyAtom head = new DatavaluedPropertyAtom(p, (AtomIObject)y, (AtomDObject)z);
        Rule rule = new Rule(Collections.singleton(head), Arrays.asList(body1, body2));
        kb.addRule(rule);
        kb.realize();
        Assert.assertTrue((boolean)kb.hasPropertyValue(j, p, d));
        Assert.assertTrue((boolean)kb.hasPropertyValue(k, p, d));
    }

    @Test
    public void dataPropertyChain2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl d = TermFactory.literal((String)"d");
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl j = TermFactory.term((String)"j");
        ATermAppl k = TermFactory.term((String)"k");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl r = TermFactory.term((String)"r");
        kb.addDatatypeProperty((ATerm)p);
        kb.addObjectProperty((ATerm)r);
        kb.addIndividual(i);
        kb.addIndividual(j);
        kb.addIndividual(k);
        kb.addSubClass(TermFactory.TOP, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{i, j, k}));
        kb.addSubClass(TermFactory.TOP, TermFactory.min((ATermAppl)r, (int)3, (ATermAppl)TermFactory.TOP));
        kb.addPropertyValue(p, i, d);
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        AtomDVariable z = new AtomDVariable("z");
        IndividualPropertyAtom body1 = new IndividualPropertyAtom(r, (AtomIObject)x, (AtomIObject)y);
        DatavaluedPropertyAtom body2 = new DatavaluedPropertyAtom(p, (AtomIObject)x, (AtomDObject)z);
        DatavaluedPropertyAtom head = new DatavaluedPropertyAtom(p, (AtomIObject)y, (AtomDObject)z);
        Rule rule = new Rule(Collections.singleton(head), Arrays.asList(body1, body2));
        kb.addRule(rule);
        kb.realize();
        Assert.assertTrue((boolean)kb.hasPropertyValue(j, p, d));
        Assert.assertTrue((boolean)kb.hasPropertyValue(k, p, d));
    }

    @Test
    public void inferredProperties() throws Exception {
        ATermAppl d = TermFactory.literal((String)"foo");
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl j = TermFactory.term((String)"j");
        ATermAppl k = TermFactory.term((String)"k");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl r = TermFactory.term((String)"r");
        KnowledgeBase kb = new KnowledgeBase();
        kb.addIndividual(i);
        kb.addIndividual(j);
        kb.addIndividual(k);
        kb.addDatatypeProperty((ATerm)p);
        kb.addObjectProperty((ATerm)r);
        kb.addSubClass(TermFactory.TOP, TermFactory.min((ATermAppl)r, (int)3, (ATermAppl)TermFactory.TOP));
        kb.addSubClass(TermFactory.TOP, TermFactory.or((ATermAppl[])new ATermAppl[]{TermFactory.value((ATermAppl)i), TermFactory.value((ATermAppl)j), TermFactory.value((ATermAppl)k)}));
        kb.addPropertyValue(p, i, d);
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        AtomDVariable z = new AtomDVariable("z");
        DatavaluedPropertyAtom head = new DatavaluedPropertyAtom(p, (AtomIObject)x, (AtomDObject)z);
        DatavaluedPropertyAtom body1 = new DatavaluedPropertyAtom(p, (AtomIObject)y, (AtomDObject)z);
        IndividualPropertyAtom body2 = new IndividualPropertyAtom(r, (AtomIObject)x, (AtomIObject)y);
        Rule rule = new Rule(Collections.singleton(head), Arrays.asList(body1, body2));
        kb.addRule(rule);
        Assert.assertTrue((boolean)kb.hasPropertyValue(j, p, d));
        Assert.assertTrue((boolean)kb.hasPropertyValue(k, p, d));
    }

    @Test
    public void testRuleIndividuals() throws Exception {
        ATermAppl c = TermFactory.term((String)"C");
        ATermAppl d = TermFactory.term((String)"D");
        ATermAppl i = TermFactory.term((String)"i");
        KnowledgeBase kb = new KnowledgeBase();
        kb.addClass(c);
        kb.addClass(d);
        kb.addIndividual(i);
        kb.addType(i, c);
        kb.addRule(new Rule(Arrays.asList(new ClassAtom(d, (AtomIObject)new AtomIConstant(i))), Arrays.asList(new ClassAtom(c, (AtomIObject)new AtomIConstant(i)))));
        kb.realize();
        Assert.assertTrue((boolean)kb.getTypes(i).contains(Collections.singleton(d)));
    }

    @Test
    public void testRuleEquality() {
        ATermAppl r = TermFactory.term((String)"r");
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl j = TermFactory.term((String)"j");
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        KnowledgeBase kb = new KnowledgeBase();
        kb.addIndividual(i);
        kb.addIndividual(j);
        kb.addObjectProperty((ATerm)r);
        kb.addSubClass(TermFactory.TOP, TermFactory.min((ATermAppl)r, (int)1, (ATermAppl)TermFactory.TOP));
        kb.addSubClass(TermFactory.TOP, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{i, j}));
        kb.addRule(new Rule(Collections.singletonList(new DifferentIndividualsAtom((AtomIObject)x, (AtomIObject)y)), Collections.singletonList(new IndividualPropertyAtom(r, (AtomIObject)x, (AtomIObject)y))));
        kb.realize();
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isDifferentFrom(i, j));
    }

    public void testLuigiFamilyJena() throws Exception {
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        ontModel.read(base + "basicFamilyReference.owl");
        ontModel.read(base + "basicFamilyRules.owl");
        Resource nella = ontModel.createResource(luigiFamily.resolve("#Nella").toString());
        Property hasUncle = ontModel.createProperty(luigiFamily.resolve("#hasUncle").toString());
        Resource dino = ontModel.createResource(luigiFamily.resolve("#Dino").toString());
        Assert.assertFalse((boolean)ontModel.contains(nella, hasUncle, (RDFNode)dino));
    }

    public void testLuigiFamilyOWLApi() throws Exception {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology familyRef = manager.loadOntology(URI.create(base + "basicFamilyReference.owl"));
        OWLOntology familyRules = manager.loadOntology(URI.create(base + "basicFamilyRules.owl"));
        Reasoner reasoner = new Reasoner(manager);
        reasoner.loadOntology(familyRef);
        reasoner.loadOntology(familyRules);
        OWLIndividual nella = manager.getOWLDataFactory().getOWLIndividual(luigiFamily.resolve("#Nella"));
        OWLObjectProperty hasUncle = manager.getOWLDataFactory().getOWLObjectProperty(luigiFamily.resolve("#hasUncle"));
        OWLIndividual dino = manager.getOWLDataFactory().getOWLIndividual(luigiFamily.resolve("#Dino"));
        Assert.assertFalse((boolean)reasoner.hasObjectPropertyRelationship(nella, (OWLObjectPropertyExpression)hasUncle, dino));
    }

    public void testUncleRule() {
        ATermAppl hasParent = TermFactory.term((String)"hasParent");
        ATermAppl hasSibling = TermFactory.term((String)"hasSibling");
        ATermAppl hasUncle = TermFactory.term((String)"hasUncle");
        ATermAppl male = TermFactory.term((String)"Male");
        ATermAppl c11 = TermFactory.term((String)"c11");
        ATermAppl c12 = TermFactory.term((String)"c12");
        ATermAppl p1a = TermFactory.term((String)"p1a");
        ATermAppl p2a = TermFactory.term((String)"p2a");
        KnowledgeBase kb = new KnowledgeBase();
        kb.addClass(male);
        kb.addObjectProperty((ATerm)hasParent);
        kb.addObjectProperty((ATerm)hasSibling);
        kb.addObjectProperty((ATerm)hasUncle);
        kb.addIndividual(c11);
        kb.addIndividual(c12);
        kb.addIndividual(p1a);
        kb.addIndividual(p2a);
        kb.addPropertyValue(hasParent, c11, p1a);
        kb.addPropertyValue(hasSibling, c11, c12);
        kb.addPropertyValue(hasParent, c12, p1a);
        kb.addPropertyValue(hasSibling, c12, c11);
        kb.addPropertyValue(hasSibling, p1a, p2a);
        kb.addType(p2a, male);
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        AtomIVariable z = new AtomIVariable("z");
        kb.addRule(new Rule(Arrays.asList(new IndividualPropertyAtom(hasUncle, (AtomIObject)y, (AtomIObject)z)), Arrays.asList(new IndividualPropertyAtom(hasParent, (AtomIObject)y, (AtomIObject)x), new ClassAtom(male, (AtomIObject)z), new IndividualPropertyAtom(hasSibling, (AtomIObject)x, (AtomIObject)z))));
        PelletTestCase.assertIteratorValues(kb.getObjectPropertyValues(hasUncle, c11).iterator(), new Object[]{p2a});
    }

    public void testVariableUtils1() {
        AtomIVariable var1 = new AtomIVariable("var1");
        AtomIVariable var2 = new AtomIVariable("var2");
        SameIndividualAtom atom = new SameIndividualAtom((AtomIObject)var1, (AtomIObject)var2);
        PelletTestCase.assertIteratorValues(VariableUtils.getVars((RuleAtom)atom).iterator(), new Object[]{var1, var2});
    }

    public void testVariableUtils2() {
        ATermAppl p = TermFactory.term((String)"p");
        AtomIVariable var1 = new AtomIVariable("var1");
        AtomIVariable var2 = new AtomIVariable("var2");
        IndividualPropertyAtom atom = new IndividualPropertyAtom(p, (AtomIObject)var1, (AtomIObject)var2);
        PelletTestCase.assertIteratorValues(VariableUtils.getVars((RuleAtom)atom).iterator(), new Object[]{var1, var2});
    }

    @Test
    public void reteRestoreTest1() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl x = TermFactory.term((String)"x");
        ATermAppl y = TermFactory.term((String)"y");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl A = TermFactory.term((String)"A");
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl G = TermFactory.term((String)"G");
        ATermAppl H = TermFactory.term((String)"H");
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addIndividual(x);
        kb.addIndividual(y);
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        kb.addClass(A);
        kb.addClass(B);
        kb.addClass(C);
        kb.addClass(G);
        kb.addClass(H);
        kb.addType(a, A);
        kb.addType(b, B);
        kb.addType(c, C);
        kb.addType(x, TermFactory.or((ATermAppl)G, (ATermAppl)TermFactory.all((ATermAppl)q, (ATermAppl)TermFactory.not((ATermAppl)H))));
        kb.addType(x, TermFactory.max((ATermAppl)p, (int)2, (ATermAppl)TermFactory.TOP));
        kb.addType(y, H);
        kb.addPropertyValue(p, x, a);
        kb.addPropertyValue(p, x, b);
        kb.addPropertyValue(p, x, c);
        AtomIVariable v = new AtomIVariable("v");
        ClassAtom body = new ClassAtom(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.or((ATermAppl)TermFactory.and((ATermAppl)A, (ATermAppl)B), (ATermAppl)TermFactory.or((ATermAppl)TermFactory.and((ATermAppl)A, (ATermAppl)C), (ATermAppl)TermFactory.and((ATermAppl)B, (ATermAppl)C)))), (AtomIObject)v);
        IndividualPropertyAtom head = new IndividualPropertyAtom(q, (AtomIObject)v, (AtomIObject)new AtomIConstant(y));
        Rule rule = new Rule(Collections.singleton(head), Collections.singleton(body));
        kb.addRule(rule);
        v = new AtomIVariable("v");
        body = new ClassAtom(G, (AtomIObject)v);
        head = new IndividualPropertyAtom(p, (AtomIObject)v, (AtomIObject)new AtomIConstant(y));
        rule = new Rule(Collections.singleton(head), Collections.singleton(body));
        kb.addRule(rule);
        Assert.assertTrue((boolean)kb.isConsistent());
        PelletTestCase.assertIteratorValues(kb.getPropertyValues(p, x).iterator(), new ATermAppl[]{a, b, c, y});
        Assert.assertEquals(Collections.singletonList(y), (Object)kb.getPropertyValues(q, x));
        Assert.assertFalse((boolean)kb.hasPropertyValue(x, q, c));
    }

    @Test
    public void testQualifiedCardinality() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl E = TermFactory.term((String)"E");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl p = TermFactory.term((String)"p");
        kb.addClass(C);
        kb.addClass(D);
        kb.addClass(E);
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addType(b, C);
        kb.addType(c, C);
        kb.addEquivalentClass(D, TermFactory.min((ATermAppl)p, (int)2, (ATermAppl)E));
        kb.addEquivalentClass(E, TermFactory.some((ATermAppl)p, (ATermAppl)C));
        kb.addObjectProperty((ATerm)p);
        kb.addPropertyValue(p, a, b);
        kb.addPropertyValue(p, a, c);
        kb.addPropertyValue(p, b, b);
        kb.addPropertyValue(p, c, c);
        kb.addDifferent(b, c);
        AtomIVariable x = new AtomIVariable("x");
        ArrayList<ClassAtom> body = new ArrayList<ClassAtom>();
        body.add(new ClassAtom(C, (AtomIObject)x));
        ArrayList<ClassAtom> head = new ArrayList<ClassAtom>();
        head.add(new ClassAtom(C, (AtomIObject)x));
        Rule rule = new Rule(head, body);
        kb.addRule(rule);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertTrue((boolean)kb.isType(a, D));
        Assert.assertTrue((boolean)kb.isType(b, E));
        Assert.assertTrue((boolean)kb.isType(c, E));
    }

    @Test
    public void reteRestoreTest2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        kb.addClass(C);
        kb.addClass(D);
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addType(b, C);
        AtomIVariable x = new AtomIVariable("x");
        ArrayList<ClassAtom> body = new ArrayList<ClassAtom>();
        body.add(new ClassAtom(C, (AtomIObject)x));
        ArrayList<ClassAtom> head = new ArrayList<ClassAtom>();
        head.add(new ClassAtom(D, (AtomIObject)x));
        Rule rule = new Rule(head, body);
        kb.addRule(rule);
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertFalse((boolean)kb.isType(a, D));
        Assert.assertFalse((boolean)kb.isDifferentFrom(a, b));
        Assert.assertFalse((boolean)kb.isType(a, D));
    }

    @Test
    public void testEmptyRuleHead1() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl C = TermFactory.term((String)"C");
        AtomIVariable x = new AtomIVariable("x");
        kb.addClass(C);
        kb.addIndividual(i);
        kb.addType(i, C);
        ArrayList<ClassAtom> body = new ArrayList<ClassAtom>();
        ArrayList head = new ArrayList();
        body.add(new ClassAtom(C, (AtomIObject)x));
        kb.addRule(new Rule(head, body));
        Assert.assertFalse((boolean)kb.isConsistent());
    }

    @Test
    public void testEmptyRuleHead2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        AtomIVariable x = new AtomIVariable("x");
        kb.addClass(C);
        kb.addClass(D);
        kb.addSubClass(C, D);
        kb.addIndividual(i);
        kb.addType(i, C);
        ArrayList<ClassAtom> body = new ArrayList<ClassAtom>();
        ArrayList head = new ArrayList();
        body.add(new ClassAtom(C, (AtomIObject)x));
        kb.addRule(new Rule(head, body));
        Assert.assertFalse((boolean)kb.isConsistent());
    }

    @Test
    public void testEmptyRuleHead3() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        AtomIVariable x = new AtomIVariable("x");
        kb.addClass(C);
        kb.addClass(D);
        kb.addSubClass(C, D);
        kb.addIndividual(i);
        kb.addType(i, D);
        ArrayList<ClassAtom> body = new ArrayList<ClassAtom>();
        ArrayList head = new ArrayList();
        body.add(new ClassAtom(D, (AtomIObject)x));
        kb.addRule(new Rule(head, body));
        Assert.assertFalse((boolean)kb.isConsistent());
    }

    @Test
    public void testEmptyRuleHead4() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl R = TermFactory.term((String)"R");
        ATermAppl l = TermFactory.literal((String)"l");
        AtomIVariable v = new AtomIVariable("v");
        AtomDConstant c = new AtomDConstant(l);
        kb.addIndividual(i);
        kb.addDatatypeProperty((ATerm)R);
        kb.addPropertyValue(R, i, l);
        ArrayList<DatavaluedPropertyAtom> body = new ArrayList<DatavaluedPropertyAtom>();
        ArrayList head = new ArrayList();
        body.add(new DatavaluedPropertyAtom(R, (AtomIObject)v, (AtomDObject)c));
        kb.addRule(new Rule(head, body));
        Assert.assertFalse((boolean)kb.isConsistent());
    }

    @Test
    public void testEmptyRuleHead5() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl CuD = TermFactory.or((ATermAppl)C, (ATermAppl)D);
        AtomIVariable x = new AtomIVariable("x");
        kb.addClass(C);
        kb.addClass(D);
        kb.addClass(CuD);
        kb.addIndividual(i);
        kb.addType(i, C);
        ArrayList<ClassAtom> body = new ArrayList<ClassAtom>();
        ArrayList head = new ArrayList();
        body.add(new ClassAtom(CuD, (AtomIObject)x));
        kb.addRule(new Rule(head, body));
        Assert.assertFalse((boolean)kb.isConsistent());
    }

    @Test
    public void testTransitiveProperty() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        kb.addTransitiveProperty(p);
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addPropertyValue(p, a, b);
        kb.addPropertyValue(p, b, c);
        ArrayList<IndividualPropertyAtom> body = new ArrayList<IndividualPropertyAtom>();
        ArrayList<IndividualPropertyAtom> head = new ArrayList<IndividualPropertyAtom>();
        body.add(new IndividualPropertyAtom(p, (AtomIObject)x, (AtomIObject)y));
        head.add(new IndividualPropertyAtom(q, (AtomIObject)x, (AtomIObject)y));
        kb.addRule(new Rule(head, body));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, p, b));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, p, c));
        Assert.assertTrue((boolean)kb.hasPropertyValue(b, p, c));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, q, b));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, q, c));
        Assert.assertTrue((boolean)kb.hasPropertyValue(b, q, c));
        Map results = kb.getPropertyValues(p);
        PelletTestCase.assertIteratorValues(((List)results.get(b)).iterator(), new ATermAppl[]{c});
        PelletTestCase.assertIteratorValues(((List)results.get(a)).iterator(), new ATermAppl[]{b, c});
        results = kb.getPropertyValues(q);
        PelletTestCase.assertIteratorValues(((List)results.get(b)).iterator(), new ATermAppl[]{c});
        PelletTestCase.assertIteratorValues(((List)results.get(a)).iterator(), new ATermAppl[]{b, c});
    }

    @Test
    public void testUnsafeVariable() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        kb.addClass(C);
        kb.addObjectProperty((ATerm)p);
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addEquivalentClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.TOP));
        AtomIVariable x = new AtomIVariable("x");
        AtomIVariable y = new AtomIVariable("y");
        ArrayList<ClassAtom> body = new ArrayList<ClassAtom>();
        body.add(new ClassAtom(C, (AtomIObject)x));
        ArrayList<IndividualPropertyAtom> head = new ArrayList<IndividualPropertyAtom>();
        head.add(new IndividualPropertyAtom(p, (AtomIObject)x, (AtomIObject)y));
        Rule rule = new Rule(head, body);
        kb.addRule(rule);
        Assert.assertEquals(Collections.singleton(rule), (Object)kb.getRules());
        Assert.assertNull(kb.getNormalizedRules().get(rule));
        Assert.assertTrue((boolean)kb.isConsistent());
        Assert.assertFalse((boolean)kb.isType(a, C));
    }
}

