/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.rules;

import java.net.URI;
import java.util.HashSet;
import junit.framework.JUnit4TestAdapter;
import org.junit.Assert;
import org.junit.Test;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.SWRLAtomIObject;
import org.semanticweb.owl.model.SWRLAtomIVariable;
import org.semanticweb.owl.model.SWRLClassAtom;
import uk.ac.manchester.cs.owl.OWLDataFactoryImpl;

public class TestComplexConsequent {
    private String NS = "http://example.org#";

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestComplexConsequent.class);
    }

    @Test
    public void test1() {
        OWLOntology ontology = null;
        OWLDataFactoryImpl owlDataFactory = new OWLDataFactoryImpl();
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        Reasoner reasoner = new Reasoner(manager);
        try {
            ontology = manager.createOntology(URI.create("http://example.org#this"));
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
        HashSet<SWRLClassAtom> bodyAtoms = new HashSet<SWRLClassAtom>();
        HashSet<SWRLClassAtom> headAtoms = new HashSet<SWRLClassAtom>();
        OWLIndividual individualA = owlDataFactory.getOWLIndividual(URI.create(this.NS + "a"));
        OWLClass classC = owlDataFactory.getOWLClass(URI.create(this.NS + "C"));
        OWLClass classD = owlDataFactory.getOWLClass(URI.create(this.NS + "D"));
        OWLClass classE = owlDataFactory.getOWLClass(URI.create(this.NS + "E"));
        OWLObjectProperty propertyP = owlDataFactory.getOWLObjectProperty(URI.create(this.NS + "p"));
        SWRLAtomIVariable variable = owlDataFactory.getSWRLAtomIVariable(URI.create(this.NS + "x"));
        OWLObjectSomeRestriction restriction = owlDataFactory.getOWLObjectSomeRestriction((OWLObjectPropertyExpression)propertyP, (OWLDescription)classD);
        bodyAtoms.add(owlDataFactory.getSWRLClassAtom((OWLDescription)classC, (SWRLAtomIObject)variable));
        headAtoms.add(owlDataFactory.getSWRLClassAtom((OWLDescription)restriction, (SWRLAtomIObject)variable));
        try {
            manager.addAxiom(ontology, (OWLAxiom)owlDataFactory.getSWRLRule(bodyAtoms, headAtoms));
            manager.addAxiom(ontology, (OWLAxiom)owlDataFactory.getOWLEquivalentClassesAxiom((OWLDescription)classE, (OWLDescription)restriction));
            manager.addAxiom(ontology, (OWLAxiom)owlDataFactory.getOWLClassAssertionAxiom(individualA, (OWLDescription)classC));
            manager.addAxiom(ontology, (OWLAxiom)owlDataFactory.getOWLClassAssertionAxiom(individualA, (OWLDescription)classE));
            reasoner.loadOntology(ontology);
            Assert.assertTrue((boolean)reasoner.isConsistent());
            Assert.assertTrue((boolean)reasoner.hasType(individualA, (OWLDescription)classE));
        }
        catch (OWLOntologyChangeException e) {
            e.printStackTrace();
        }
    }
}

