/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena.graph.converter;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.graph.converter.ConceptConverter;
import org.mindswap.pellet.jena.graph.converter.TripleAdder;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.jena.vocabulary.SWRL;
import org.mindswap.pellet.utils.ATermUtils;

public class AxiomConverter {
    private KnowledgeBase kb;
    private ConceptConverter converter;
    private Graph graph;

    public AxiomConverter(KnowledgeBase kb, Graph g) {
        this.kb = kb;
        this.graph = g;
        this.converter = new ConceptConverter(this.graph);
    }

    public void convert(ATermAppl axiom) {
        if (axiom.getAFun().equals(ATermUtils.EQCLASSFUN)) {
            this.convertBinary(axiom, OWL.equivalentClass);
        } else if (axiom.getAFun().equals(ATermUtils.SUBFUN)) {
            this.convertBinary(axiom, RDFS.subClassOf);
        } else if (axiom.getAFun().equals(ATermUtils.DISJOINTFUN)) {
            this.convertBinary(axiom, OWL.disjointWith);
        } else if (axiom.getAFun().equals(ATermUtils.DISJOINTSFUN)) {
            this.convertNary(axiom, OWL2.AllDisjointClasses, OWL2.members);
        } else if (axiom.getAFun().equals(ATermUtils.EQPROPFUN)) {
            this.convertBinary(axiom, OWL.equivalentProperty);
        } else if (axiom.getAFun().equals(ATermUtils.SUBPROPFUN)) {
            this.convertBinary(axiom, RDFS.subPropertyOf);
        } else if (axiom.getAFun().equals(ATermUtils.DISJOINTPROPFUN)) {
            this.convertBinary(axiom, OWL2.propertyDisjointWith);
        } else if (axiom.getAFun().equals(ATermUtils.DISJOINTPROPSFUN)) {
            this.convertNary(axiom, OWL2.AllDisjointProperties, OWL2.members);
        } else if (axiom.getAFun().equals(ATermUtils.DOMAINFUN)) {
            this.convertBinary(axiom, RDFS.domain);
        } else if (axiom.getAFun().equals(ATermUtils.RANGEFUN)) {
            this.convertBinary(axiom, RDFS.range);
        } else if (axiom.getAFun().equals(ATermUtils.INVPROPFUN)) {
            this.convertBinary(axiom, OWL.inverseOf);
        } else if (axiom.getAFun().equals(ATermUtils.TRANSITIVEFUN)) {
            this.convertUnary(axiom, OWL.TransitiveProperty);
        } else if (axiom.getAFun().equals(ATermUtils.FUNCTIONALFUN)) {
            this.convertUnary(axiom, OWL.FunctionalProperty);
        } else if (axiom.getAFun().equals(ATermUtils.INVFUNCTIONALFUN)) {
            this.convertUnary(axiom, OWL.InverseFunctionalProperty);
        } else if (axiom.getAFun().equals(ATermUtils.SYMMETRICFUN)) {
            this.convertUnary(axiom, OWL.SymmetricProperty);
        } else if (axiom.getAFun().equals(ATermUtils.ASYMMETRICFUN)) {
            this.convertUnary(axiom, OWL2.AsymmetricProperty);
        } else if (axiom.getAFun().equals(ATermUtils.REFLEXIVEFUN)) {
            this.convertUnary(axiom, OWL2.ReflexiveProperty);
        } else if (axiom.getAFun().equals(ATermUtils.IRREFLEXIVEFUN)) {
            this.convertUnary(axiom, OWL2.IrreflexiveProperty);
        } else if (axiom.getAFun().equals(ATermUtils.TYPEFUN)) {
            this.convertBinary(axiom, RDF.type);
        } else if (axiom.getAFun().equals(ATermUtils.SAMEASFUN)) {
            this.convertBinary(axiom, OWL.sameAs);
        } else if (axiom.getAFun().equals(ATermUtils.DIFFERENTFUN)) {
            this.convertBinary(axiom, OWL.differentFrom);
        } else if (axiom.getAFun().equals(ATermUtils.ALLDIFFERENTFUN)) {
            this.convertNary(axiom, OWL.AllDifferent, OWL2.members);
        } else if (axiom.getAFun().equals(ATermUtils.NOTFUN)) {
            axiom = (ATermAppl)axiom.getArgument(0);
            Node p = this.converter.convert(axiom.getArgument(0));
            Node s = this.converter.convert(axiom.getArgument(1));
            Node o = this.converter.convert(axiom.getArgument(2));
            Node n = Node.createAnon();
            TripleAdder.add(this.graph, n, (Resource)RDF.type, (RDFNode)OWL2.NegativePropertyAssertion);
            TripleAdder.add(this.graph, n, (Resource)RDF.subject, s);
            TripleAdder.add(this.graph, n, (Resource)RDF.predicate, p);
            TripleAdder.add(this.graph, n, (Resource)RDF.object, o);
        } else if (axiom.getAFun().equals(ATermUtils.PROPFUN)) {
            Node p = this.converter.convert(axiom.getArgument(0));
            Node s = this.converter.convert(axiom.getArgument(1));
            Node o = this.converter.convert(axiom.getArgument(2));
            TripleAdder.add(this.graph, s, p, o);
        } else if (axiom.getAFun().equals(ATermUtils.RULEFUN)) {
            Node node = null;
            ATermAppl name = (ATermAppl)axiom.getArgument(0);
            node = name == ATermUtils.EMPTY ? Node.createAnon() : (ATermUtils.isBnode((ATermAppl)name) ? Node.createAnon((AnonId)new AnonId(((ATermAppl)name.getArgument(0)).getName())) : Node.createURI((String)name.getName()));
            TripleAdder.add(this.graph, node, (Resource)RDF.type, (RDFNode)SWRL.Imp);
            ATermList head = (ATermList)axiom.getArgument(1);
            if (head.isEmpty()) {
                TripleAdder.add(this.graph, node, (Resource)SWRL.head, (RDFNode)RDF.nil);
            } else {
                Node list = null;
                while (!head.isEmpty()) {
                    Node atomNode = this.convertAtom((ATermAppl)head.getFirst());
                    Node newList = Node.createAnon();
                    TripleAdder.add(this.graph, newList, (Resource)RDF.type, (RDFNode)SWRL.AtomList);
                    TripleAdder.add(this.graph, newList, (Resource)RDF.first, atomNode);
                    if (list != null) {
                        TripleAdder.add(this.graph, list, (Resource)RDF.rest, newList);
                    } else {
                        TripleAdder.add(this.graph, node, (Resource)SWRL.head, newList);
                    }
                    list = newList;
                    head = head.getNext();
                }
                TripleAdder.add(this.graph, list, (Resource)RDF.rest, (RDFNode)RDF.nil);
            }
            ATermList body = (ATermList)axiom.getArgument(2);
            if (body.isEmpty()) {
                TripleAdder.add(this.graph, node, (Resource)SWRL.body, (RDFNode)RDF.nil);
            } else {
                Node list = null;
                while (!body.isEmpty()) {
                    Node atomNode = this.convertAtom((ATermAppl)body.getFirst());
                    Node newList = Node.createAnon();
                    TripleAdder.add(this.graph, newList, (Resource)RDF.type, (RDFNode)SWRL.AtomList);
                    TripleAdder.add(this.graph, newList, (Resource)RDF.first, atomNode);
                    if (list != null) {
                        TripleAdder.add(this.graph, list, (Resource)RDF.rest, newList);
                    } else {
                        TripleAdder.add(this.graph, node, (Resource)SWRL.body, newList);
                    }
                    list = newList;
                    body = body.getNext();
                }
                TripleAdder.add(this.graph, list, (Resource)RDF.rest, (RDFNode)RDF.nil);
            }
        }
    }

    private Node convertAtom(ATermAppl term) {
        Node atom = Node.createAnon();
        if (term.getAFun().equals(ATermUtils.TYPEFUN)) {
            ATermAppl ind = (ATermAppl)term.getArgument(0);
            ATermAppl cls = (ATermAppl)term.getArgument(1);
            Node indNode = this.convertAtomObject(ind);
            Node clsNode = this.converter.convert((ATerm)cls);
            TripleAdder.add(this.graph, atom, (Resource)RDF.type, (RDFNode)SWRL.ClassAtom);
            TripleAdder.add(this.graph, atom, (Resource)SWRL.classPredicate, clsNode);
            TripleAdder.add(this.graph, atom, (Resource)SWRL.argument1, indNode);
        } else if (term.getAFun().equals(ATermUtils.PROPFUN)) {
            ATermAppl prop = (ATermAppl)term.getArgument(0);
            ATermAppl arg1 = (ATermAppl)term.getArgument(1);
            ATermAppl arg2 = (ATermAppl)term.getArgument(2);
            Node propNode = JenaUtils.makeGraphNode(prop);
            Node node1 = this.convertAtomObject(arg1);
            Node node2 = this.convertAtomObject(arg2);
            if (this.kb.isObjectProperty((ATerm)prop)) {
                TripleAdder.add(this.graph, atom, (Resource)RDF.type, (RDFNode)SWRL.IndividualPropertyAtom);
            } else if (this.kb.isDatatypeProperty((ATerm)prop)) {
                TripleAdder.add(this.graph, atom, (Resource)RDF.type, (RDFNode)SWRL.DatavaluedPropertyAtom);
            } else {
                throw new UnsupportedOperationException("Unknown property: " + prop);
            }
            TripleAdder.add(this.graph, atom, (Resource)SWRL.propertyPredicate, propNode);
            TripleAdder.add(this.graph, atom, (Resource)SWRL.argument1, node1);
            TripleAdder.add(this.graph, atom, (Resource)SWRL.argument2, node2);
        } else if (term.getAFun().equals(ATermUtils.SAMEASFUN)) {
            ATermAppl arg1 = (ATermAppl)term.getArgument(1);
            ATermAppl arg2 = (ATermAppl)term.getArgument(2);
            Node node1 = this.convertAtomObject(arg1);
            Node node2 = this.convertAtomObject(arg2);
            TripleAdder.add(this.graph, atom, (Resource)RDF.type, (RDFNode)SWRL.SameIndividualAtom);
            TripleAdder.add(this.graph, atom, (Resource)SWRL.argument1, node1);
            TripleAdder.add(this.graph, atom, (Resource)SWRL.argument2, node2);
        } else if (term.getAFun().equals(ATermUtils.DIFFERENTFUN)) {
            ATermAppl arg1 = (ATermAppl)term.getArgument(1);
            ATermAppl arg2 = (ATermAppl)term.getArgument(2);
            Node node1 = this.convertAtomObject(arg1);
            Node node2 = this.convertAtomObject(arg2);
            TripleAdder.add(this.graph, atom, (Resource)RDF.type, (RDFNode)SWRL.DifferentIndividualsAtom);
            TripleAdder.add(this.graph, atom, (Resource)SWRL.argument1, node1);
            TripleAdder.add(this.graph, atom, (Resource)SWRL.argument2, node2);
        } else if (term.getAFun().equals(ATermUtils.BUILTINFUN)) {
            ATermList args = (ATermList)term.getArgument(0);
            ATermAppl builtin = (ATermAppl)args.getFirst();
            args = args.getNext();
            TripleAdder.add(this.graph, atom, (Resource)RDF.type, (RDFNode)SWRL.BuiltinAtom);
            TripleAdder.add(this.graph, atom, (Resource)SWRL.builtin, Node.createURI((String)builtin.toString()));
            if (args.isEmpty()) {
                TripleAdder.add(this.graph, atom, (Resource)SWRL.arguments, (RDFNode)RDF.nil);
            } else {
                Node list = null;
                while (!args.isEmpty()) {
                    Node atomNode = this.convertAtomObject((ATermAppl)args.getFirst());
                    Node newList = Node.createAnon();
                    TripleAdder.add(this.graph, newList, (Resource)RDF.first, atomNode);
                    if (list != null) {
                        TripleAdder.add(this.graph, list, (Resource)RDF.rest, newList);
                    } else {
                        TripleAdder.add(this.graph, atom, (Resource)SWRL.arguments, newList);
                    }
                    list = newList;
                    args = args.getNext();
                }
                TripleAdder.add(this.graph, list, (Resource)RDF.rest, (RDFNode)RDF.nil);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported atom: " + atom);
        }
        return atom;
    }

    private Node convertAtomObject(ATermAppl t) {
        Node node;
        if (ATermUtils.isVar((ATermAppl)t)) {
            node = JenaUtils.makeGraphNode((ATermAppl)t.getArgument(0));
            TripleAdder.add(this.graph, node, (Resource)RDF.type, (RDFNode)SWRL.Variable);
        } else {
            node = JenaUtils.makeGraphNode(t);
        }
        return node;
    }

    private void convertNary(ATermAppl axiom, Resource type, Property p) {
        Node n = Node.createAnon();
        TripleAdder.add(this.graph, n, (Resource)RDF.type, (RDFNode)type);
        ATermList concepts = (ATermList)axiom.getArgument(0);
        this.converter.visitList(concepts);
        TripleAdder.add(this.graph, n, (Resource)p, this.converter.getResult());
    }

    private void convertBinary(ATermAppl axiom, Property p) {
        Node s = this.converter.convert(axiom.getArgument(0));
        Node o = this.converter.convert(axiom.getArgument(1));
        TripleAdder.add(this.graph, s, (Resource)p, o);
    }

    private void convertUnary(ATermAppl axiom, Resource o) {
        Node s = this.converter.convert(axiom.getArgument(0));
        TripleAdder.add(this.graph, s, RDF.type.asNode(), o.asNode());
    }
}

